/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.proxies;

import java.util.Map;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.state.PEStateProps;
import moze_intel.projecte.api.state.enums.EnumFuelType;
import moze_intel.projecte.api.state.enums.EnumMatterType;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.blocks.NovaCataclysm;
import moze_intel.projecte.gameObjs.blocks.NovaCatalyst;
import moze_intel.projecte.gameObjs.entity.EntityFireProjectile;
import moze_intel.projecte.gameObjs.entity.EntityHomingArrow;
import moze_intel.projecte.gameObjs.entity.EntityLavaProjectile;
import moze_intel.projecte.gameObjs.entity.EntityLensProjectile;
import moze_intel.projecte.gameObjs.entity.EntityMobRandomizer;
import moze_intel.projecte.gameObjs.entity.EntityNovaCataclysmPrimed;
import moze_intel.projecte.gameObjs.entity.EntityNovaCatalystPrimed;
import moze_intel.projecte.gameObjs.entity.EntitySWRGProjectile;
import moze_intel.projecte.gameObjs.entity.EntityWaterProjectile;
import moze_intel.projecte.gameObjs.items.KleinStar;
import moze_intel.projecte.gameObjs.tiles.AlchChestTile;
import moze_intel.projecte.gameObjs.tiles.CondenserMK2Tile;
import moze_intel.projecte.gameObjs.tiles.CondenserTile;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.manual.ManualPageHandler;
import moze_intel.projecte.proxies.IProxy;
import moze_intel.projecte.rendering.ChestRenderer;
import moze_intel.projecte.rendering.CondenserMK2Renderer;
import moze_intel.projecte.rendering.CondenserRenderer;
import moze_intel.projecte.rendering.LayerYue;
import moze_intel.projecte.rendering.NovaCataclysmRenderer;
import moze_intel.projecte.rendering.NovaCatalystRenderer;
import moze_intel.projecte.rendering.PedestalRenderer;
import moze_intel.projecte.utils.ClientKeyHelper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.entity.RenderTippedArrow;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="projecte")
public class ClientProxy
implements IProxy {
    @Override
    public void clearClientKnowledge() {
        ((IKnowledgeProvider)FMLClientHandler.instance().getClientPlayerEntity().getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null)).clearKnowledge();
    }

    @Override
    public IKnowledgeProvider getClientTransmutationProps() {
        return (IKnowledgeProvider)FMLClientHandler.instance().getClientPlayerEntity().getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null);
    }

    @Override
    public IAlchBagProvider getClientBagProps() {
        return (IAlchBagProvider)FMLClientHandler.instance().getClientPlayerEntity().getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY, null);
    }

    @Override
    public void registerKeyBinds() {
        ClientKeyHelper.registerMCBindings();
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent evt) {
        ModelLoader.setCustomStateMapper((Block)ObjHandler.novaCatalyst, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{NovaCatalyst.field_176246_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ObjHandler.novaCataclysm, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{NovaCataclysm.field_176246_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ObjHandler.alchChest, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{PEStateProps.FACING}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ObjHandler.condenser, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{PEStateProps.FACING}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ObjHandler.condenserMk2, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{PEStateProps.FACING}).func_178441_a());
        ClientProxy.registerCovalenceDust();
        ClientProxy.registerBags();
        ClientProxy.registerFuels();
        ClientProxy.registerMatter();
        ClientProxy.registerKlein();
        ClientProxy.registerPowerItems();
        ClientProxy.registerItem(ObjHandler.bodyStone);
        ClientProxy.registerItem(ObjHandler.soulStone);
        ClientProxy.registerItem(ObjHandler.mindStone);
        ClientProxy.registerItem(ObjHandler.lifeStone);
        ClientProxy.registerItem(ObjHandler.blackHole);
        ClientProxy.registerItem(ObjHandler.harvestGod);
        ClientProxy.registerItem(ObjHandler.eternalDensity);
        ClientProxy.registerItem(ObjHandler.timeWatch);
        ClientProxy.registerItem(ObjHandler.ignition);
        ClientProxy.registerItem(ObjHandler.zero);
        ClientProxy.registerItem(ObjHandler.voidRing);
        ClientProxy.registerItem(ObjHandler.waterOrb);
        ClientProxy.registerItem(ObjHandler.lavaOrb);
        ClientProxy.registerItem(ObjHandler.mobRandomizer);
        ClientProxy.registerItem(ObjHandler.lensExplosive);
        ClientProxy.registerItem(ObjHandler.windProjectile);
        ClientProxy.registerItem(ObjHandler.fireProjectile);
        ClientProxy.registerItem(ObjHandler.philosStone);
        ClientProxy.registerItem(ObjHandler.repairTalisman);
        ClientProxy.registerItem(ObjHandler.ironBand);
        ClientProxy.registerItem(ObjHandler.dCatalyst);
        ClientProxy.registerItem(ObjHandler.hyperLens);
        ClientProxy.registerItem(ObjHandler.cataliticLens);
        ClientProxy.registerItem(ObjHandler.tome);
        ClientProxy.registerItem(ObjHandler.transmutationTablet);
        ClientProxy.registerItem(ObjHandler.everTide);
        ClientProxy.registerItem(ObjHandler.volcanite);
        ClientProxy.registerItem(ObjHandler.dRod1);
        ClientProxy.registerItem(ObjHandler.dRod2);
        ClientProxy.registerItem(ObjHandler.dRod3);
        ClientProxy.registerItem(ObjHandler.angelSmite);
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.angelSmite, (int)1, (ModelResourceLocation)new ModelResourceLocation(ObjHandler.angelSmite.getRegistryName(), "inventory"));
        ClientProxy.registerItem(ObjHandler.mercEye);
        ClientProxy.registerItem(ObjHandler.dmPick);
        ClientProxy.registerItem(ObjHandler.dmAxe);
        ClientProxy.registerItem(ObjHandler.dmShovel);
        ClientProxy.registerItem(ObjHandler.dmSword);
        ClientProxy.registerItem(ObjHandler.dmHoe);
        ClientProxy.registerItem(ObjHandler.dmShears);
        ClientProxy.registerItem(ObjHandler.dmHammer);
        ClientProxy.registerItem(ObjHandler.dmHelmet);
        ClientProxy.registerItem(ObjHandler.dmChest);
        ClientProxy.registerItem(ObjHandler.dmLegs);
        ClientProxy.registerItem(ObjHandler.dmFeet);
        ClientProxy.registerItem(ObjHandler.rmPick);
        ClientProxy.registerItem(ObjHandler.rmAxe);
        ClientProxy.registerItem(ObjHandler.rmShovel);
        ClientProxy.registerItem(ObjHandler.rmSword);
        ClientProxy.registerItem(ObjHandler.rmHoe);
        ClientProxy.registerItem(ObjHandler.rmShears);
        ClientProxy.registerItem(ObjHandler.rmHammer);
        ClientProxy.registerItem(ObjHandler.rmKatar);
        ClientProxy.registerItem(ObjHandler.rmStar);
        ClientProxy.registerItem(ObjHandler.rmHelmet);
        ClientProxy.registerItem(ObjHandler.rmChest);
        ClientProxy.registerItem(ObjHandler.rmLegs);
        ClientProxy.registerItem(ObjHandler.rmFeet);
        ClientProxy.registerItem(ObjHandler.gemHelmet);
        ClientProxy.registerItem(ObjHandler.gemChest);
        ClientProxy.registerItem(ObjHandler.gemLegs);
        ClientProxy.registerItem(ObjHandler.gemFeet);
        ClientProxy.registerItem(ObjHandler.manual);
        ClientProxy.registerBlock(ObjHandler.alchChest);
        ClientProxy.registerBlock(ObjHandler.collectorMK2);
        ClientProxy.registerBlock(ObjHandler.collectorMK3);
        ClientProxy.registerBlock(ObjHandler.condenser);
        ClientProxy.registerBlock(ObjHandler.condenserMk2);
        ClientProxy.registerBlock(ObjHandler.interdictionTorch);
        ClientProxy.registerBlock(ObjHandler.dmFurnaceOff);
        ClientProxy.registerBlock(ObjHandler.dmPedestal);
        ClientProxy.registerBlock(ObjHandler.collectorMK1);
        ClientProxy.registerBlock(ObjHandler.novaCatalyst);
        ClientProxy.registerBlock(ObjHandler.novaCataclysm);
        ClientProxy.registerBlock(ObjHandler.relay);
        ClientProxy.registerBlock(ObjHandler.relayMK2);
        ClientProxy.registerBlock(ObjHandler.relayMK3);
        ClientProxy.registerBlock(ObjHandler.rmFurnaceOff);
        ClientProxy.registerBlock(ObjHandler.transmuteStone);
    }

    private static void registerBlock(Block b) {
        String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b).toString();
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)b), (int)0, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
    }

    private static void registerItem(Item i) {
        ClientProxy.registerItem(i, 0);
    }

    private static void registerItem(Item i, int meta) {
        String name = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)i).toString();
        ModelLoader.setCustomModelResourceLocation((Item)i, (int)meta, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
    }

    private static void registerCovalenceDust() {
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.covalence, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:covalence_low", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.covalence, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:covalence_medium", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.covalence, (int)2, (ModelResourceLocation)new ModelResourceLocation("projecte:covalence_high", "inventory"));
    }

    private static void registerBags() {
        for (EnumDyeColor e : EnumDyeColor.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.alchBag, (int)e.func_176765_a(), (ModelResourceLocation)new ModelResourceLocation("projecte:bags/alchbag_" + e.func_176610_l(), "inventory"));
        }
    }

    private static void registerFuels() {
        for (EnumFuelType e : EnumFuelType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.fuels, (int)e.ordinal(), (ModelResourceLocation)new ModelResourceLocation("projecte:" + e.func_176610_l(), "inventory"));
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)ObjHandler.fuelBlock).toString();
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ObjHandler.fuelBlock), (int)e.ordinal(), (ModelResourceLocation)new ModelResourceLocation(name, "fueltype=" + e.func_176610_l()));
        }
    }

    private static void registerMatter() {
        for (EnumMatterType m : EnumMatterType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.matter, (int)m.ordinal(), (ModelResourceLocation)new ModelResourceLocation("projecte:" + m.func_176610_l(), "inventory"));
            String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)ObjHandler.matterBlock).toString();
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ObjHandler.matterBlock), (int)m.ordinal(), (ModelResourceLocation)new ModelResourceLocation(name, "tier=" + m.func_176610_l()));
        }
    }

    private static void registerKlein() {
        for (KleinStar.EnumKleinTier e : KleinStar.EnumKleinTier.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.kleinStars, (int)e.ordinal(), (ModelResourceLocation)new ModelResourceLocation("projecte:stars/klein_star_" + e.name, "inventory"));
        }
    }

    private static void registerPowerItems() {
        ModelResourceLocation off = new ModelResourceLocation("projecte:swrg_off", "inventory");
        ModelResourceLocation fly = new ModelResourceLocation("projecte:swrg_fly", "inventory");
        ModelResourceLocation repel = new ModelResourceLocation("projecte:swrg_repel", "inventory");
        ModelResourceLocation both = new ModelResourceLocation("projecte:swrg_both", "inventory");
        ModelLoader.registerItemVariants((Item)ObjHandler.swrg, (ResourceLocation[])new ResourceLocation[]{off, fly, repel, both});
        ModelLoader.setCustomMeshDefinition((Item)ObjHandler.swrg, stack -> {
            if (stack.func_77942_o()) {
                switch (stack.func_77978_p().func_74762_e("Mode")) {
                    default: {
                        return off;
                    }
                    case 1: {
                        return fly;
                    }
                    case 2: {
                        return repel;
                    }
                    case 3: 
                }
                return both;
            }
            return off;
        });
        ModelResourceLocation zero = new ModelResourceLocation("projecte:arcana_zero_off", "inventory");
        ModelResourceLocation ignition = new ModelResourceLocation("projecte:arcana_ignition_off", "inventory");
        ModelResourceLocation harv = new ModelResourceLocation("projecte:arcana_harv_off", "inventory");
        ModelResourceLocation swrg = new ModelResourceLocation("projecte:arcana_swrg_off", "inventory");
        ModelLoader.registerItemVariants((Item)ObjHandler.arcana, (ResourceLocation[])new ResourceLocation[]{zero, ignition, harv, swrg});
        ModelLoader.setCustomMeshDefinition((Item)ObjHandler.arcana, stack -> {
            if (stack.func_77942_o()) {
                switch (stack.func_77978_p().func_74771_c("Mode")) {
                    default: {
                        return zero;
                    }
                    case 1: {
                        return ignition;
                    }
                    case 2: {
                        return harv;
                    }
                    case 3: 
                }
                return swrg;
            }
            return zero;
        });
    }

    @Override
    public void registerRenderers() {
        ClientRegistry.bindTileEntitySpecialRenderer(AlchChestTile.class, (TileEntitySpecialRenderer)new ChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(CondenserTile.class, (TileEntitySpecialRenderer)new CondenserRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(CondenserMK2Tile.class, (TileEntitySpecialRenderer)new CondenserMK2Renderer());
        ClientRegistry.bindTileEntitySpecialRenderer(DMPedestalTile.class, (TileEntitySpecialRenderer)new PedestalRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityWaterProjectile.class, ClientProxy.createRenderFactoryForSnowball(ObjHandler.waterOrb));
        RenderingRegistry.registerEntityRenderingHandler(EntityLavaProjectile.class, ClientProxy.createRenderFactoryForSnowball(ObjHandler.lavaOrb));
        RenderingRegistry.registerEntityRenderingHandler(EntityMobRandomizer.class, ClientProxy.createRenderFactoryForSnowball(ObjHandler.mobRandomizer));
        RenderingRegistry.registerEntityRenderingHandler(EntityLensProjectile.class, ClientProxy.createRenderFactoryForSnowball(ObjHandler.lensExplosive));
        RenderingRegistry.registerEntityRenderingHandler(EntityFireProjectile.class, ClientProxy.createRenderFactoryForSnowball(ObjHandler.fireProjectile));
        RenderingRegistry.registerEntityRenderingHandler(EntitySWRGProjectile.class, ClientProxy.createRenderFactoryForSnowball(ObjHandler.windProjectile));
        RenderingRegistry.registerEntityRenderingHandler(EntityNovaCatalystPrimed.class, NovaCatalystRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityNovaCataclysmPrimed.class, NovaCataclysmRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHomingArrow.class, RenderTippedArrow::new);
    }

    @Override
    public void registerLayerRenderers() {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        RenderPlayer render = (RenderPlayer)skinMap.get("default");
        render.func_177094_a((LayerRenderer)new LayerYue(render));
        render = (RenderPlayer)skinMap.get("slim");
        render.func_177094_a((LayerRenderer)new LayerYue(render));
    }

    private static <T extends Entity> IRenderFactory<T> createRenderFactoryForSnowball(Item itemToRender) {
        return manager -> new RenderSnowball(manager, itemToRender, Minecraft.func_71410_x().func_175599_af());
    }

    @Override
    public void initializeManual() {
        ManualPageHandler.init();
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    @Override
    public boolean isJumpPressed() {
        return FMLClientHandler.instance().getClient().field_71474_y.field_74314_A.func_151470_d();
    }
}

