import mods.artisanworktables.builder.RecipeBuilder;
import mods.gregtech.recipe.RecipeMap;
val blast_furnace = mods.gregtech.recipe.RecipeMap.getByName("blast_furnace");
val fluid_extractor = mods.gregtech.recipe.RecipeMap.getByName("fluid_extractor");
val mixer = mods.gregtech.recipe.RecipeMap.getByName("mixer");
val solidifier = mods.gregtech.recipe.RecipeMap.getByName("fluid_solidifier");
val chemical_bath = mods.gregtech.recipe.RecipeMap.getByName("chemical_bath");
val vacFreezer = mods.gregtech.recipe.RecipeMap.getByName("vacuum_freezer");

print("---------------Thermal Foundation Start------------------");

	#Cryotheum Dust
recipes.remove(<thermalfoundation:material:1025>);
mods.gregtech.recipe.RecipeMap.getByName("mixer").recipeBuilder()
	.inputs([<ore:dustBlizz>.firstItem * 2, <minecraft:snowball>, <ore:dustRedstone>])
	.fluidInputs(<liquid:brine> * 500)
	.outputs(<ore:dustCryotheum>.firstItem * 2)
	.duration(120)
	.EUt(32)
	.buildAndRegister();

	#Enderium
mixer.recipeBuilder()
	.inputs([<ore:dustLead> * 3, <ore:dustPlatinum>])
	.fluidInputs(<liquid:ender> * 1000)
	.outputs(<thermalfoundation:material:103> * 2)
	.duration(120)
	.EUt(32)
	.buildAndRegister();

	#Lumium
mixer.recipeBuilder()
	.inputs([<ore:dustTin> * 3, <ore:dustSilver>])
	.fluidInputs(<liquid:glowstone> * 1000)
	.outputs(<thermalfoundation:material:102> * 2)
	.duration(120)
	.EUt(32)
	.buildAndRegister();

	#Rockwool
mixer.recipeBuilder()
    .inputs(<minecraft:gravel>*4, <minecraft:sand>*4, <ore:blockWool>)
    .fluidInputs([<liquid:water> * 100])
	.outputs(<thermalfoundation:rockwool:7>)
    .duration(800)
    .EUt(3)
    .buildAndRegister();

	#Signalum
mixer.recipeBuilder()
	.inputs([<ore:dustCopper> * 3, <ore:dustRedstone>])
	.fluidInputs(<liquid:redstone> * 1000)
	.outputs(<thermalfoundation:material:101> * 2)
	.duration(120)
	.EUt(32)
	.buildAndRegister();

	#remove small and tiny piles from dust
	recipes.remove(<ore:dustSmallSignalum>.firstItem);
	recipes.remove(<ore:dustTinySignalum>.firstItem);
	
	#Destabilized Redstone Bucket recipes
recipes.removeByRecipeName("thermalfoundation:dust_signalum");
recipes.removeByRecipeName("redstonearsenal:gem_crystal_flux");
recipes.removeByRecipeName("redstonearsenal:dust_electrum_flux_alloy");
recipes.removeByRecipeName("redstonearsenal:dust_electrum_flux");


	#Enderium
	vacFreezer.findRecipe(120, [<ore:ingotHotEnderium>.firstItem], null).remove();
	blast_furnace.findRecipe(120, [<ore:dustEnderium>.firstItem], null).remove();
blast_furnace.recipeBuilder()
    .inputs(<thermalfoundation:material:103>*2, <thermalfoundation:material:1024>)
    .fluidInputs([<liquid:helium> * 100])
    .outputs(<ore:ingotHotEnderium>.firstItem*2)
    .property("temperature", 4500)
    .duration(2200)
    .EUt(480)
    .buildAndRegister();

vacFreezer.recipeBuilder()
	.inputs([<ore:ingotHotEnderium>])
	.outputs(<thermalfoundation:material:167>)
	.duration(280)
	.EUt(120)
	.buildAndRegister();
	
	
	#remove small and tiny piles from dust
	recipes.remove(<ore:dustSmallEnderium>.firstItem);
	recipes.remove(<ore:dustTinyEnderium>.firstItem);


	#Energized Glowstone Bucket recipes
recipes.removeByRecipeName("thermalfoundation:dust_lumium");

	#petrotheym dust
solidifier.recipeBuilder()
    .fluidInputs([<liquid:petrotheum> * 144])
	.notConsumable(<metaitem:shape.mold.ball>)
	.outputs(<ore:dustPetrotheum>.firstItem)
	.duration(800)
	.EUt(18)
	.buildAndRegister();		
	
	#blitz dust
	chemical_bath.recipeBuilder()
	.inputs(<ore:dustNiter> *2)
	.fluidInputs([<liquid:xpjuice> * 200])
	.outputs(<thermalfoundation:material:2051>)
    .duration(160)
    .EUt(18)
    .buildAndRegister();

	chemical_bath.recipeBuilder()
	.inputs(<ore:dustNiter> *2)
	.fluidInputs([<liquid:essence> * 200])
	.outputs(<thermalfoundation:material:2051>)
    .duration(160)
    .EUt(18)
    .buildAndRegister();
		
	chemical_bath.recipeBuilder()
	.inputs(<ore:dustNiter> *2)
	.fluidInputs([<liquid:experience> * 200])
	.outputs(<thermalfoundation:material:2051>)
    .duration(160)
    .EUt(18)
    .buildAndRegister();
	
	#infused mana deblockify
	recipes.addShapeless(<thermalfoundation:material:136> * 9, [<thermalfoundation:storage:8>]);

	#Pyrotheum Dust
recipes.remove(<thermalfoundation:material:1024>);
mods.gregtech.recipe.RecipeMap.getByName("mixer").recipeBuilder()
	.inputs([<minecraft:blaze_powder> * 2, <ore:dustSulfur>, <ore:dustRedstone>])
	.fluidInputs(<liquid:brine> * 500)
	.outputs(<ore:dustPyrotheum>.firstItem * 2)
	.duration(120)
	.EUt(32)
	.buildAndRegister();

	#Pyrotheum Fluid
fluid_extractor.recipeBuilder()
	.inputs(<ore:dustPyrotheum>)
	.fluidOutputs(<liquid:pyrotheum>*144)
	.duration(80)
	.EUt(32)
	.buildAndRegister();
	
	#Petrotheum Fluid
fluid_extractor.recipeBuilder()
	.inputs(<ore:dustPetrotheum>)
	.fluidOutputs(<liquid:petrotheum>*144)
	.duration(80)
	.EUt(32)
	.buildAndRegister();

	#Cryotheum Fluid
fluid_extractor.recipeBuilder()
	.inputs(<ore:dustCryotheum>)
	.fluidOutputs(<liquid:cryotheum>*144)
	.duration(80)
	.EUt(32)
	.buildAndRegister();
	
	#Aerotheum Fluid
fluid_extractor.recipeBuilder()
	.inputs(<ore:dustAerotheum>)
	.fluidOutputs(<liquid:aerotheum>*144)
	.duration(80)
	.EUt(32)
	.buildAndRegister();	

	#Resonant Ender Bucket recipes
recipes.removeByRecipeName("thermalfoundation:dust_enderium");

	#Signalum
blast_furnace.recipeBuilder()
    .inputs(<thermalfoundation:material:101>)
    .fluidInputs([<liquid:nitrogen> * 250])
    .outputs(<thermalfoundation:material:165>)
    .property("temperature", 1350)
    .duration(220)
    .EUt(120)
    .buildAndRegister();	

	#Lumium
blast_furnace.recipeBuilder()
    .inputs(<thermalfoundation:material:102>)
    .fluidInputs([<liquid:nitrogen> * 250])
    .outputs(<thermalfoundation:material:166>)
    .property("temperature", 2100)
    .duration(220)
    .EUt(120)
    .buildAndRegister();	

	
print("----------------Thermal Foundation End-------------------");
