/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex;

import com.github.atomicblom.weirdinggadget.Logger;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.Curve;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexAnimation;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexKey;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexMatrixTransform;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexNode;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexRotation;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexScene;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTime;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTrack;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTransform;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTranslation;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexValue;

public class Animation {
    public static float[][] calculateTransforms(OgexScene scene, float animationTime, OgexNode[] nodes, Integer[] nodeParentMap) {
        float[][] nodeTransforms = new float[nodes.length][16];
        float[][] parentTransforms = new float[nodes.length][16];
        for (int nodeIndex = 0; nodeIndex < nodes.length; ++nodeIndex) {
            Object parentMatrix;
            OgexNode node = nodes[nodeIndex];
            float[] nodeMatrix = OgexMatrixTransform.identity();
            Integer parentNodeIndex = nodeParentMap[nodeIndex];
            if (parentNodeIndex != null) {
                parentMatrix = parentTransforms[parentNodeIndex];
                nodeMatrix = (float[])parentMatrix.clone();
            }
            for (OgexAnimation animation : node.getAnimations()) {
                float actualAnimationTime;
                for (actualAnimationTime = animation.getBegin() + animationTime; actualAnimationTime > animation.getEnd(); actualAnimationTime -= animation.getEnd()) {
                }
                for (OgexTrack track : animation) {
                    Object target = track.getTarget();
                    float value = Animation.getCurrentValueForTrack(scene, track, actualAnimationTime);
                    if (target instanceof OgexTranslation.ComponentTranslation) {
                        ((OgexTranslation.ComponentTranslation)target).setTranslation(value);
                        continue;
                    }
                    if (target instanceof OgexRotation.ComponentRotation) {
                        ((OgexRotation.ComponentRotation)target).setAngle(value);
                        continue;
                    }
                    Logger.info("Breakpoint", new Object[0]);
                }
            }
            parentMatrix = (float[])nodeMatrix.clone();
            for (OgexTransform transform : node.getTransforms()) {
                float[] right = transform.toMatrix();
                nodeMatrix = OgexMatrixTransform.multiply(nodeMatrix, right);
                if (transform.isObjectOnly()) continue;
                parentMatrix = OgexMatrixTransform.multiply((float[])parentMatrix, right);
            }
            nodeTransforms[nodeIndex] = nodeMatrix;
            parentTransforms[nodeIndex] = (float[])parentMatrix;
        }
        return nodeTransforms;
    }

    private static float getCurrentValueForTrack(OgexScene model, OgexTrack track, float animationTime) {
        TimeData keyData = Animation.getKeyData(track.getTime());
        ValueData valueData = Animation.getValueData(track.getValue());
        float timeScale = model.getMetrics().getTime();
        int index = Animation.getKeyIndexForTime(keyData, timeScale, animationTime);
        float adjustedTime = 1.0f;
        if (track.getTime().getCurve() == Curve.Bezier) {
            adjustedTime = Animation.getAdjustedBezierTime(keyData, timeScale, animationTime, index);
        } else if (track.getTime().getCurve() == Curve.Linear) {
            adjustedTime = Animation.getAdjustedLinearTime(keyData, timeScale, animationTime, index);
        }
        float trackValue = 1.0f;
        if (track.getValue().getCurve() == Curve.Bezier) {
            trackValue = Animation.getAdjustedBezierValue(valueData, index, adjustedTime);
        } else if (track.getValue().getCurve() == Curve.Linear) {
            trackValue = Animation.getAdjustedLinearValue(valueData, index, adjustedTime);
        }
        return trackValue;
    }

    private static float getAdjustedLinearValue(ValueData valueData, int index, float adjustedTime) {
        float[] value = valueData.value;
        float s = adjustedTime;
        float v1 = value[index - 1];
        float v2 = value[index];
        return s * (v2 - v1) + v1;
    }

    private static float getAdjustedBezierValue(ValueData valueData, int index, float adjustedTime) {
        float[] value = valueData.value;
        float s = adjustedTime;
        float v1 = value[index - 1];
        float p1 = valueData.positiveControl[index - 1];
        float p2 = valueData.negativeControl[index];
        float v2 = value[index];
        float v = (1.0f - s) * (1.0f - s) * (1.0f - s) * v1 + 3.0f * s * ((1.0f - s) * (1.0f - s)) * p1 + 3.0f * (s * s) * (1.0f - s) * p2 + s * s * s * v2;
        return v;
    }

    private static float getAdjustedLinearTime(TimeData keyData, float scale, float currentTime, int index) {
        float[] value = keyData.value;
        float t = currentTime;
        float t1 = value[index - 1] * scale;
        float t2 = value[index] * scale;
        if (t1 >= t2) {
            return 0.0f;
        }
        float si = (t - t1) / (t2 - t1);
        float finalTime = value[value.length - 1];
        if (si > finalTime) {
            si = finalTime;
        }
        return si;
    }

    private static float getAdjustedBezierTime(TimeData keyData, float scale, float currentTime, int index) {
        float[] value = keyData.value;
        float[] positiveControl = keyData.positiveControl;
        float[] negativeControl = keyData.negativeControl;
        float si = 0.0f;
        float t = currentTime;
        float t1 = value[index - 1] * scale;
        float c1 = positiveControl[index - 1] * scale;
        float c2 = negativeControl[index] * scale;
        float t2 = value[index] * scale;
        if (t1 >= c1 || c1 >= c2 || c2 >= t2) {
            return 0.0f;
        }
        int i = 0;
        float oldSi = 0.0f;
        while (true) {
            float splusone;
            si = i == 0 ? (t - t1) / (t2 - t1) : (splusone = si - ((t2 - 3.0f * c2 + 3.0f * c1 - t1) * (si * si * si) + 3.0f * (c2 - 2.0f * c1 + t1) * (si * si) + 3.0f * (c1 - t1) * si + t1 - t) / (3.0f * (t2 - 3.0f * c2 + 3.0f * c1 - t1) * (si * si) + 6.0f * (c2 - 2.0f * c1 + t1) * si + 3.0f * (c1 - t1)));
            if (Math.floor(oldSi * 10000.0f) == Math.floor(si * 10000.0f) || i >= 4) break;
            ++i;
            oldSi = si;
        }
        float finalTime = value[value.length - 1];
        if (si > finalTime) {
            si = finalTime;
        }
        return si;
    }

    private static int getKeyIndexForTime(TimeData keyData, float scale, float currentTime) {
        int i;
        float[] value = keyData.value;
        for (i = 0; i < value.length && !(value[i] * scale > currentTime); ++i) {
        }
        if (i >= value.length) {
            return value.length - 1;
        }
        if (i <= 0) {
            return 0;
        }
        return i;
    }

    private static TimeData getKeyData(OgexTime time) {
        OgexKey[] keys = time.getKeys();
        TimeData timeData = new TimeData(keys);
        block5: for (OgexKey key : keys) {
            switch (key.getKind()) {
                case Value: {
                    timeData.value = (float[])key.getData();
                    continue block5;
                }
                case PositiveControl: {
                    timeData.positiveControl = (float[])key.getData();
                    continue block5;
                }
                case NegativeControl: {
                    timeData.negativeControl = (float[])key.getData();
                }
            }
        }
        return timeData;
    }

    private static ValueData getValueData(OgexValue value) {
        OgexKey[] keys = value.getKeys();
        ValueData timeData = new ValueData(keys);
        block8: for (OgexKey key : keys) {
            switch (key.getKind()) {
                case Value: {
                    timeData.value = (float[])key.getData();
                    continue block8;
                }
                case PositiveControl: {
                    timeData.positiveControl = (float[])key.getData();
                    continue block8;
                }
                case NegativeControl: {
                    timeData.negativeControl = (float[])key.getData();
                    continue block8;
                }
                case Bias: {
                    timeData.bias = (float[])key.getData();
                    continue block8;
                }
                case Continuity: {
                    timeData.continuity = (float[])key.getData();
                    continue block8;
                }
                case Tension: {
                    timeData.tension = (float[])key.getData();
                }
            }
        }
        return timeData;
    }

    private static class TimeData {
        OgexKey[] keys;
        float[] value;
        float[] positiveControl;
        float[] negativeControl;

        public TimeData(OgexKey[] keys) {
            this.keys = keys;
        }
    }

    private static class ValueData {
        OgexKey[] keys;
        float[] value;
        float[] positiveControl;
        float[] negativeControl;
        float[] bias;
        float[] continuity;
        float[] tension;

        public ValueData(OgexKey[] keys) {
            this.keys = keys;
        }
    }
}

