/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever.action.recovery;

import com.buuz135.togetherforever.api.IOfflineSyncRecovery;
import com.buuz135.togetherforever.api.IPlayerInformation;
import com.buuz135.togetherforever.api.data.TogetherRegistries;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class AbstractOfflineRecovery
implements IOfflineSyncRecovery {
    protected ListMultimap<IPlayerInformation, NBTTagCompound> offlineRecoveries = ArrayListMultimap.create();

    @Override
    public void storeMissingPlayers(List<IPlayerInformation> playersInformation, NBTTagCompound store) {
        for (IPlayerInformation playerInformation : playersInformation) {
            this.storeMissingPlayer(playerInformation, store);
        }
    }

    @Override
    public void storeMissingPlayer(IPlayerInformation playerInformation, NBTTagCompound store) {
        this.offlineRecoveries.put((Object)playerInformation, (Object)store);
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        for (IPlayerInformation playerInformation : this.offlineRecoveries.keySet()) {
            String uuid = playerInformation.getUUID().toString();
            NBTTagCompound recovery = new NBTTagCompound();
            recovery.func_74782_a("ID", (NBTBase)playerInformation.getNBTTag());
            recovery.func_74778_a("PlayerID", TogetherRegistries.getPlayerInformationID(playerInformation.getClass()));
            int id = 0;
            for (NBTTagCompound compound : this.offlineRecoveries.get((Object)playerInformation)) {
                recovery.func_74782_a(Integer.toString(id), (NBTBase)compound);
                ++id;
            }
            tagCompound.func_74782_a(uuid, (NBTBase)recovery);
        }
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.offlineRecoveries.clear();
        for (String uuid : compound.func_150296_c()) {
            NBTTagCompound recovery = compound.func_74775_l(uuid);
            Class<? extends IPlayerInformation> plClass = TogetherRegistries.getPlayerInformationClass(recovery.func_74779_i("PlayerID"));
            if (plClass == null) continue;
            try {
                IPlayerInformation info = plClass.newInstance();
                info.readFromNBT(recovery.func_74775_l("ID"));
                for (String id : recovery.func_150296_c()) {
                    if (id.equalsIgnoreCase("ID") || id.equalsIgnoreCase("PlayerID")) continue;
                    this.offlineRecoveries.put((Object)info, (Object)recovery.func_74775_l(id));
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }
}

