/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.itemfilters.integration.forestry;

import com.latmod.mods.itemfilters.filters.FilterBase;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.ISpeciesType;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class BeeFilter
extends FilterBase
implements INBTSerializable<NBTTagCompound> {
    private ItemStack beeStack = ItemStack.field_190927_a;
    private boolean checkSecondary = false;
    private EnumBeeType beeType = null;
    private String primary = null;
    private String secondary = null;

    @Override
    public String getID() {
        return "bee";
    }

    public void setBee(ItemStack stack) {
        if (BeeManager.beeRoot != null && BeeManager.beeRoot.getType(stack) != null) {
            this.beeStack = stack.func_77946_l();
            this.clearCache();
        }
    }

    @Override
    public boolean filter(ItemStack stack) {
        if (BeeManager.beeRoot == null) {
            return false;
        }
        if (this.beeType == null) {
            this.beeType = BeeManager.beeRoot.getType(this.beeStack);
            if (this.beeType == null) {
                return false;
            }
            IBee bee = BeeManager.beeRoot.getMember(this.beeStack);
            this.primary = bee.getGenome().getPrimary().getUID();
            this.secondary = bee.getGenome().getSecondary().getUID();
        } else if (BeeManager.beeRoot.isMember(stack, (ISpeciesType)this.beeType)) {
            IBee b = BeeManager.beeRoot.getMember(stack);
            return b != null && (!this.checkSecondary || b.getGenome().getSecondary().getUID().equals(this.secondary)) && b.getGenome().getPrimary().getUID().equals(this.primary);
        }
        return false;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = this.beeStack.serializeNBT();
        if (this.checkSecondary) {
            nbt.func_74757_a("check_secondary", true);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.beeStack = new ItemStack(nbt);
        this.checkSecondary = nbt.func_74767_n("check_secondary");
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.beeType = null;
        this.primary = null;
        this.secondary = null;
    }

    @Override
    public void getValidItems(List<ItemStack> stacks) {
        stacks.add(this.beeStack);
    }
}

