/*
 * Decompiled with CFR 0.152.
 */
package mcjty.tools.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import mcjty.tools.cache.StructureCache;
import mcjty.tools.rules.CommonRuleKeys;
import mcjty.tools.rules.IEventQuery;
import mcjty.tools.rules.IModRuleCompatibilityLayer;
import mcjty.tools.typed.AttributeMap;
import mcjty.tools.typed.Key;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class CommonRuleEvaluator {
    protected final List<BiFunction<Event, IEventQuery, Boolean>> checks = new ArrayList<BiFunction<Event, IEventQuery, Boolean>>();
    private final Logger logger;
    private final IModRuleCompatibilityLayer compatibility;
    private static Random rnd = new Random();
    private static final int[] EMPTYINTS = new int[0];

    public CommonRuleEvaluator(AttributeMap map, Logger logger, IModRuleCompatibilityLayer compatibility) {
        this.logger = logger;
        this.compatibility = compatibility;
        this.addChecks(map);
    }

    protected void addChecks(AttributeMap map) {
        if (map.has(CommonRuleKeys.RANDOM)) {
            this.addRandomCheck(map);
        }
        if (map.has(CommonRuleKeys.MINTIME)) {
            this.addMinTimeCheck(map);
        }
        if (map.has(CommonRuleKeys.MAXTIME)) {
            this.addMaxTimeCheck(map);
        }
        if (map.has(CommonRuleKeys.MINHEIGHT)) {
            this.addMinHeightCheck(map);
        }
        if (map.has(CommonRuleKeys.MAXHEIGHT)) {
            this.addMaxHeightCheck(map);
        }
        if (map.has(CommonRuleKeys.WEATHER)) {
            this.addWeatherCheck(map);
        }
        if (map.has(CommonRuleKeys.TEMPCATEGORY)) {
            this.addTempCategoryCheck(map);
        }
        if (map.has(CommonRuleKeys.DIFFICULTY)) {
            this.addDifficultyCheck(map);
        }
        if (map.has(CommonRuleKeys.DIMENSION)) {
            this.addDimensionCheck(map);
        }
        if (map.has(CommonRuleKeys.MINSPAWNDIST)) {
            this.addMinSpawnDistCheck(map);
        }
        if (map.has(CommonRuleKeys.MAXSPAWNDIST)) {
            this.addMaxSpawnDistCheck(map);
        }
        if (map.has(CommonRuleKeys.MINLIGHT)) {
            this.addMinLightCheck(map);
        }
        if (map.has(CommonRuleKeys.MAXLIGHT)) {
            this.addMaxLightCheck(map);
        }
        if (map.has(CommonRuleKeys.MINDIFFICULTY)) {
            this.addMinAdditionalDifficultyCheck(map);
        }
        if (map.has(CommonRuleKeys.MAXDIFFICULTY)) {
            this.addMaxAdditionalDifficultyCheck(map);
        }
        if (map.has(CommonRuleKeys.SEESKY)) {
            this.addSeeSkyCheck(map);
        }
        if (map.has(CommonRuleKeys.BLOCK)) {
            this.addBlocksCheck(map);
        }
        if (map.has(CommonRuleKeys.BLOCKUP)) {
            this.addBlocksCheckUp(map);
        }
        if (map.has(CommonRuleKeys.BIOME)) {
            this.addBiomesCheck(map);
        }
        if (map.has(CommonRuleKeys.BIOMETYPE)) {
            this.addBiomeTypesCheck(map);
        }
        if (map.has(CommonRuleKeys.HELMET)) {
            this.addHelmetCheck(map);
        }
        if (map.has(CommonRuleKeys.CHESTPLATE)) {
            this.addChestplateCheck(map);
        }
        if (map.has(CommonRuleKeys.LEGGINGS)) {
            this.addLeggingsCheck(map);
        }
        if (map.has(CommonRuleKeys.BOOTS)) {
            this.addBootsCheck(map);
        }
        if (map.has(CommonRuleKeys.HELDITEM)) {
            this.addHeldItemCheck(map);
        }
        if (map.has(CommonRuleKeys.OFFHANDITEM)) {
            this.addOffHandItemCheck(map);
        }
        if (map.has(CommonRuleKeys.BOTHHANDSITEM)) {
            this.addBothHandsItemCheck(map);
        }
        if (map.has(CommonRuleKeys.STRUCTURE)) {
            this.addStructureCheck(map);
        }
        if (map.has(CommonRuleKeys.SUMMER)) {
            if (this.compatibility.hasSereneSeasons()) {
                this.addSummerCheck(map);
            } else {
                this.logger.warn("Serene Seaons is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.WINTER)) {
            if (this.compatibility.hasSereneSeasons()) {
                this.addWinterCheck(map);
            } else {
                this.logger.warn("Serene Seaons is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.SPRING)) {
            if (this.compatibility.hasSereneSeasons()) {
                this.addSpringCheck(map);
            } else {
                this.logger.warn("Serene Seaons is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.AUTUMN)) {
            if (this.compatibility.hasSereneSeasons()) {
                this.addAutumnCheck(map);
            } else {
                this.logger.warn("Serene Seaons is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.GAMESTAGE)) {
            if (this.compatibility.hasGameStages()) {
                this.addGameStageCheck(map);
            } else {
                this.logger.warn("Game Stages is missing: the 'gamestage' test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.INCITY)) {
            if (this.compatibility.hasLostCities()) {
                this.addInCityCheck(map);
            } else {
                this.logger.warn("The Lost Cities is missing: the 'incity' test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.INSTREET)) {
            if (this.compatibility.hasLostCities()) {
                this.addInStreetCheck(map);
            } else {
                this.logger.warn("The Lost Cities is missing: the 'instreet' test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.INSPHERE)) {
            if (this.compatibility.hasLostCities()) {
                this.addInSphereCheck(map);
            } else {
                this.logger.warn("The Lost Cities is missing: the 'insphere' test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.INBUILDING)) {
            if (this.compatibility.hasLostCities()) {
                this.addInBuildingCheck(map);
            } else {
                this.logger.warn("The Lost Cities is missing: the 'inbuilding' test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.AMULET)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.AMULET, this.compatibility::getAmuletSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.RING)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.RING, this.compatibility::getRingSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.BELT)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.BELT, this.compatibility::getBeltSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.TRINKET)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.TRINKET, this.compatibility::getTrinketSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.HEAD)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.HEAD, this.compatibility::getHeadSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.BODY)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.BODY, this.compatibility::getBodySlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.CHARM)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.CHARM, this.compatibility::getCharmSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
    }

    private void addRandomCheck(AttributeMap map) {
        float r = map.get(CommonRuleKeys.RANDOM).floatValue();
        this.checks.add((event, query) -> rnd.nextFloat() < r);
    }

    private void addSeeSkyCheck(AttributeMap map) {
        if (map.get(CommonRuleKeys.SEESKY).booleanValue()) {
            this.checks.add((event, query) -> query.getWorld(event).func_175710_j(query.getPos(event)));
        } else {
            this.checks.add((event, query) -> !query.getWorld(event).func_175710_j(query.getPos(event)));
        }
    }

    private void addDimensionCheck(AttributeMap map) {
        List<Integer> dimensions = map.getList(CommonRuleKeys.DIMENSION);
        if (dimensions.size() == 1) {
            Integer dim = dimensions.get(0);
            this.checks.add((event, query) -> query.getWorld(event).field_73011_w.getDimension() == dim.intValue());
        } else {
            HashSet<Integer> dims = new HashSet<Integer>(dimensions);
            this.checks.add((event, query) -> dims.contains(query.getWorld(event).field_73011_w.getDimension()));
        }
    }

    private void addDifficultyCheck(AttributeMap map) {
        String difficulty = map.get(CommonRuleKeys.DIFFICULTY).toLowerCase();
        EnumDifficulty diff = null;
        for (EnumDifficulty d : EnumDifficulty.values()) {
            if (!d.func_151526_b().endsWith("." + difficulty)) continue;
            diff = d;
            break;
        }
        if (diff != null) {
            EnumDifficulty finalDiff = diff;
            this.checks.add((event, query) -> query.getWorld(event).func_175659_aa() == finalDiff);
        } else {
            this.logger.log(Level.ERROR, "Unknown difficulty '" + difficulty + "'! Use one of 'easy', 'normal', 'hard',  or 'peaceful'");
        }
    }

    private void addWeatherCheck(AttributeMap map) {
        String weather = map.get(CommonRuleKeys.WEATHER);
        boolean raining = weather.toLowerCase().startsWith("rain");
        boolean thunder = weather.toLowerCase().startsWith("thunder");
        if (raining) {
            this.checks.add((event, query) -> query.getWorld(event).func_72896_J());
        } else if (thunder) {
            this.checks.add((event, query) -> query.getWorld(event).func_72911_I());
        } else {
            this.logger.log(Level.ERROR, "Unknown weather '" + weather + "'! Use 'rain' or 'thunder'");
        }
    }

    private void addTempCategoryCheck(AttributeMap map) {
        String tempcategory = map.get(CommonRuleKeys.TEMPCATEGORY).toLowerCase();
        Biome.TempCategory cat = null;
        if ("cold".equals(tempcategory)) {
            cat = Biome.TempCategory.COLD;
        } else if ("medium".equals(tempcategory)) {
            cat = Biome.TempCategory.MEDIUM;
        } else if ("warm".equals(tempcategory)) {
            cat = Biome.TempCategory.WARM;
        } else if ("ocean".equals(tempcategory)) {
            cat = Biome.TempCategory.OCEAN;
        } else {
            this.logger.log(Level.ERROR, "Unknown tempcategory '" + tempcategory + "'! Use one of 'cold', 'medium', 'warm',  or 'ocean'");
            return;
        }
        Biome.TempCategory finalCat = cat;
        this.checks.add((event, query) -> {
            Biome biome = query.getWorld(event).func_180494_b(query.getPos(event));
            return biome.func_150561_m() == finalCat;
        });
    }

    private void addStructureCheck(AttributeMap map) {
        String structure = map.get(CommonRuleKeys.STRUCTURE);
        this.checks.add((event, query) -> StructureCache.CACHE.isInStructure(query.getWorld(event), structure, query.getPos(event)));
    }

    private void addBiomesCheck(AttributeMap map) {
        List<String> biomes = map.getList(CommonRuleKeys.BIOME);
        if (biomes.size() == 1) {
            String biomename = biomes.get(0);
            this.checks.add((event, query) -> {
                Biome biome = query.getWorld(event).func_180494_b(query.getPos(event));
                return biomename.equals(this.compatibility.getBiomeName(biome));
            });
        } else {
            HashSet<String> biomenames = new HashSet<String>(biomes);
            this.checks.add((event, query) -> {
                Biome biome = query.getWorld(event).func_180494_b(query.getPos(event));
                return biomenames.contains(this.compatibility.getBiomeName(biome));
            });
        }
    }

    private void addBiomeTypesCheck(AttributeMap map) {
        List<String> biomeTypes = map.getList(CommonRuleKeys.BIOMETYPE);
        if (biomeTypes.size() == 1) {
            String biometype = biomeTypes.get(0);
            BiomeDictionary.Type type = BiomeDictionary.Type.getType((String)biometype, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            this.checks.add((event, query) -> {
                Biome biome = query.getWorld(event).func_180494_b(query.getPos(event));
                return BiomeDictionary.getTypes((Biome)biome).contains(type);
            });
        } else {
            HashSet<BiomeDictionary.Type> types = new HashSet<BiomeDictionary.Type>();
            for (String s : biomeTypes) {
                types.add(BiomeDictionary.Type.getType((String)s, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
            }
            this.checks.add((event, query) -> {
                Biome biome = query.getWorld(event).func_180494_b(query.getPos(event));
                return BiomeDictionary.getTypes((Biome)biome).stream().anyMatch(s -> types.contains(s));
            });
        }
    }

    private void addBlocksCheck(AttributeMap map) {
        List<String> blocks = map.getList(CommonRuleKeys.BLOCK);
        if (blocks.size() == 1) {
            String blockname = blocks.get(0);
            if (blockname.startsWith("ore:")) {
                int oreId = OreDictionary.getOreID((String)blockname.substring(4));
                this.checks.add((event, query) -> {
                    BlockPos pos = query.getValidBlockPos(event);
                    Block block = query.getWorld(event).func_180495_p(pos).func_177230_c();
                    ItemStack stack = new ItemStack(block);
                    int[] oreIDs = stack.func_190926_b() ? EMPTYINTS : OreDictionary.getOreIDs((ItemStack)stack);
                    return this.isMatchingOreId(oreIDs, oreId);
                });
            } else {
                this.checks.add((event, query) -> {
                    BlockPos pos = query.getValidBlockPos(event);
                    ResourceLocation registryName = query.getWorld(event).func_180495_p(pos).func_177230_c().getRegistryName();
                    if (registryName == null) {
                        return false;
                    }
                    String name = registryName.toString();
                    return blockname.equals(name);
                });
            }
        } else {
            HashSet<String> blocknames = new HashSet<String>(blocks);
            this.checks.add((event, query) -> {
                BlockPos pos = query.getValidBlockPos(event);
                Block block = query.getWorld(event).func_180495_p(pos).func_177230_c();
                ItemStack stack = new ItemStack(block);
                int[] oreIDs = stack.func_190926_b() ? EMPTYINTS : OreDictionary.getOreIDs((ItemStack)stack);
                ResourceLocation registryName = block.getRegistryName();
                if (registryName == null) {
                    return false;
                }
                String name = registryName.toString();
                for (String blockname : blocknames) {
                    int oreId;
                    if (!(blockname.startsWith("ore:") ? this.isMatchingOreId(oreIDs, oreId = OreDictionary.getOreID((String)blockname.substring(4))) : blockname.equals(name))) continue;
                    return true;
                }
                return false;
            });
        }
    }

    private void addBlocksCheckUp(AttributeMap map) {
        List<String> blocks = map.getList(CommonRuleKeys.BLOCKUP);
        if (blocks.size() == 1) {
            String blockname = blocks.get(0);
            if (blockname.startsWith("ore:")) {
                int oreId = OreDictionary.getOreID((String)blockname.substring(4));
                this.checks.add((event, query) -> {
                    BlockPos pos = query.getValidBlockPos(event).func_177984_a();
                    Block block = query.getWorld(event).func_180495_p(pos).func_177230_c();
                    ItemStack stack = new ItemStack(block);
                    int[] oreIDs = stack.func_190926_b() ? EMPTYINTS : OreDictionary.getOreIDs((ItemStack)stack);
                    return this.isMatchingOreId(oreIDs, oreId);
                });
            } else {
                this.checks.add((event, query) -> {
                    BlockPos pos = query.getValidBlockPos(event).func_177984_a();
                    ResourceLocation registryName = query.getWorld(event).func_180495_p(pos).func_177230_c().getRegistryName();
                    if (registryName == null) {
                        return false;
                    }
                    String name = registryName.toString();
                    return blockname.equals(name);
                });
            }
        } else {
            HashSet<String> blocknames = new HashSet<String>(blocks);
            this.checks.add((event, query) -> {
                BlockPos pos = query.getValidBlockPos(event).func_177984_a();
                Block block = query.getWorld(event).func_180495_p(pos).func_177230_c();
                ItemStack stack = new ItemStack(block);
                int[] oreIDs = stack.func_190926_b() ? EMPTYINTS : OreDictionary.getOreIDs((ItemStack)stack);
                ResourceLocation registryName = block.getRegistryName();
                if (registryName == null) {
                    return false;
                }
                String name = registryName.toString();
                for (String blockname : blocknames) {
                    int oreId;
                    if (!(blockname.startsWith("ore:") ? this.isMatchingOreId(oreIDs, oreId = OreDictionary.getOreID((String)blockname.substring(4))) : blockname.equals(name))) continue;
                    return true;
                }
                return false;
            });
        }
    }

    private boolean isMatchingOreId(int[] oreIDs, int oreId) {
        if (oreIDs.length > 0) {
            for (int id : oreIDs) {
                if (id != oreId) continue;
                return true;
            }
        }
        return false;
    }

    private void addMinTimeCheck(AttributeMap map) {
        int mintime = map.get(CommonRuleKeys.MINTIME);
        this.checks.add((event, query) -> {
            int time = (int)query.getWorld(event).func_72820_D();
            return time >= mintime;
        });
    }

    private void addMaxTimeCheck(AttributeMap map) {
        int maxtime = map.get(CommonRuleKeys.MAXTIME);
        this.checks.add((event, query) -> {
            int time = (int)query.getWorld(event).func_72820_D();
            return time <= maxtime;
        });
    }

    private void addMinSpawnDistCheck(AttributeMap map) {
        Float d = Float.valueOf(map.get(CommonRuleKeys.MINSPAWNDIST).floatValue() * map.get(CommonRuleKeys.MINSPAWNDIST).floatValue());
        this.checks.add((event, query) -> {
            BlockPos pos = query.getPos(event);
            double sqdist = pos.func_177951_i((Vec3i)query.getWorld(event).func_175694_M());
            return sqdist >= (double)d.floatValue();
        });
    }

    private void addMaxSpawnDistCheck(AttributeMap map) {
        Float d = Float.valueOf(map.get(CommonRuleKeys.MAXSPAWNDIST).floatValue() * map.get(CommonRuleKeys.MAXSPAWNDIST).floatValue());
        this.checks.add((event, query) -> {
            BlockPos pos = query.getPos(event);
            double sqdist = pos.func_177951_i((Vec3i)query.getWorld(event).func_175694_M());
            return sqdist <= (double)d.floatValue();
        });
    }

    private void addMinLightCheck(AttributeMap map) {
        int minlight = map.get(CommonRuleKeys.MINLIGHT);
        this.checks.add((event, query) -> {
            BlockPos pos = query.getPos(event);
            return query.getWorld(event).func_175721_c(pos, true) >= minlight;
        });
    }

    private void addMaxLightCheck(AttributeMap map) {
        int maxlight = map.get(CommonRuleKeys.MAXLIGHT);
        this.checks.add((event, query) -> {
            BlockPos pos = query.getPos(event);
            return query.getWorld(event).func_175721_c(pos, true) <= maxlight;
        });
    }

    private void addMinAdditionalDifficultyCheck(AttributeMap map) {
        Float mindifficulty = map.get(CommonRuleKeys.MINDIFFICULTY);
        this.checks.add((event, query) -> query.getWorld(event).func_175649_E(query.getPos(event)).func_180168_b() >= mindifficulty.floatValue());
    }

    private void addMaxAdditionalDifficultyCheck(AttributeMap map) {
        Float maxdifficulty = map.get(CommonRuleKeys.MAXDIFFICULTY);
        this.checks.add((event, query) -> query.getWorld(event).func_175649_E(query.getPos(event)).func_180168_b() <= maxdifficulty.floatValue());
    }

    private void addMaxHeightCheck(AttributeMap map) {
        int maxheight = map.get(CommonRuleKeys.MAXHEIGHT);
        this.checks.add((event, query) -> query.getY(event) <= maxheight);
    }

    private void addMinHeightCheck(AttributeMap map) {
        int minheight = map.get(CommonRuleKeys.MINHEIGHT);
        this.checks.add((event, query) -> query.getY(event) >= minheight);
    }

    public boolean match(Event event, IEventQuery query) {
        for (BiFunction<Event, IEventQuery, Boolean> rule : this.checks) {
            if (rule.apply(event, query).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected List<Item> getItems(List<String> itemNames) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (String name : itemNames) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
            if (item == null) {
                this.logger.log(Level.ERROR, "Unknown item '" + name + "'!");
                continue;
            }
            items.add(item);
        }
        return items;
    }

    public void addHelmetCheck(AttributeMap map) {
        List<Item> items = this.getItems(map.getList(CommonRuleKeys.HELMET));
        this.addArmorCheck(items, EntityEquipmentSlot.HEAD);
    }

    public void addChestplateCheck(AttributeMap map) {
        List<Item> items = this.getItems(map.getList(CommonRuleKeys.CHESTPLATE));
        this.addArmorCheck(items, EntityEquipmentSlot.CHEST);
    }

    public void addLeggingsCheck(AttributeMap map) {
        List<Item> items = this.getItems(map.getList(CommonRuleKeys.LEGGINGS));
        this.addArmorCheck(items, EntityEquipmentSlot.LEGS);
    }

    public void addBootsCheck(AttributeMap map) {
        List<Item> items = this.getItems(map.getList(CommonRuleKeys.BOOTS));
        this.addArmorCheck(items, EntityEquipmentSlot.FEET);
    }

    private void addArmorCheck(List<Item> items, EntityEquipmentSlot slot) {
        this.checks.add((event, query) -> {
            ItemStack armorItem;
            EntityPlayer player = query.getPlayer(event);
            if (player != null && !(armorItem = player.func_184582_a(slot)).func_190926_b()) {
                for (Item item : items) {
                    if (armorItem.func_77973_b() != item) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public void addHeldItemCheck(AttributeMap map) {
        List<Item> items = this.getItems(map.getList(CommonRuleKeys.HELDITEM));
        this.checks.add((event, query) -> {
            ItemStack mainhand;
            EntityPlayer player = query.getPlayer(event);
            if (player != null && !(mainhand = player.func_184614_ca()).func_190926_b()) {
                for (Item item : items) {
                    if (mainhand.func_77973_b() != item) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public void addOffHandItemCheck(AttributeMap map) {
        List<Item> items = this.getItems(map.getList(CommonRuleKeys.OFFHANDITEM));
        this.checks.add((event, query) -> {
            ItemStack offhand;
            EntityPlayer player = query.getPlayer(event);
            if (player != null && !(offhand = player.func_184592_cb()).func_190926_b()) {
                for (Item item : items) {
                    if (offhand.func_77973_b() != item) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public void addBothHandsItemCheck(AttributeMap map) {
        List<Item> items = this.getItems(map.getList(CommonRuleKeys.BOTHHANDSITEM));
        this.checks.add((event, query) -> {
            EntityPlayer player = query.getPlayer(event);
            if (player != null) {
                ItemStack mainhand;
                ItemStack offhand = player.func_184592_cb();
                if (!offhand.func_190926_b()) {
                    for (Item item : items) {
                        if (offhand.func_77973_b() != item) continue;
                        return true;
                    }
                }
                if (!(mainhand = player.func_184614_ca()).func_190926_b()) {
                    for (Item item : items) {
                        if (mainhand.func_77973_b() != item) continue;
                        return true;
                    }
                }
            }
            return false;
        });
    }

    private void addSummerCheck(AttributeMap map) {
        Boolean s = map.get(CommonRuleKeys.SUMMER);
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isSummer(query.getWorld(event)));
    }

    private void addWinterCheck(AttributeMap map) {
        Boolean s = map.get(CommonRuleKeys.WINTER);
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isWinter(query.getWorld(event)));
    }

    private void addSpringCheck(AttributeMap map) {
        Boolean s = map.get(CommonRuleKeys.SPRING);
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isSpring(query.getWorld(event)));
    }

    private void addAutumnCheck(AttributeMap map) {
        Boolean s = map.get(CommonRuleKeys.AUTUMN);
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isAutumn(query.getWorld(event)));
    }

    private void addGameStageCheck(AttributeMap map) {
        String stage = map.get(CommonRuleKeys.GAMESTAGE);
        this.checks.add((event, query) -> this.compatibility.hasGameStage(query.getPlayer(event), stage));
    }

    private void addInCityCheck(AttributeMap map) {
        if (map.get(CommonRuleKeys.INCITY).booleanValue()) {
            this.checks.add((event, query) -> this.compatibility.isCity(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.isCity(query, event));
        }
    }

    private void addInStreetCheck(AttributeMap map) {
        if (map.get(CommonRuleKeys.INSTREET).booleanValue()) {
            this.checks.add((event, query) -> this.compatibility.isStreet(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.isStreet(query, event));
        }
    }

    private void addInSphereCheck(AttributeMap map) {
        if (map.get(CommonRuleKeys.INSPHERE).booleanValue()) {
            this.checks.add((event, query) -> this.compatibility.inSphere(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.inSphere(query, event));
        }
    }

    private void addInBuildingCheck(AttributeMap map) {
        if (map.get(CommonRuleKeys.INBUILDING).booleanValue()) {
            this.checks.add((event, query) -> this.compatibility.isBuilding(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.isBuilding(query, event));
        }
    }

    public void addBaubleCheck(AttributeMap map, Key<String> key, Supplier<int[]> slotSupplier) {
        List<Item> items = this.getItems(map.getList(key));
        this.checks.add((event, query) -> {
            EntityPlayer player = query.getPlayer(event);
            if (player != null) {
                for (int slot : (int[])slotSupplier.get()) {
                    ItemStack stack = this.compatibility.getBaubleStack(player, slot);
                    if (stack.func_190926_b()) continue;
                    for (Item item : items) {
                        if (stack.func_77973_b() != item) continue;
                        return true;
                    }
                }
            }
            return false;
        });
    }
}

