/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.api;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.ISpecialBattery;
import flaxbeard.cyberware.api.item.HotkeyHelper;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.IHudjack;
import flaxbeard.cyberware.api.item.IMenuItem;
import flaxbeard.cyberware.common.CyberwareConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CyberwareUserDataImpl
implements ICyberwareUserData {
    public static final Capability.IStorage<ICyberwareUserData> STORAGE = new CyberwareUserDataStorage();
    private NonNullList<NonNullList<ItemStack>> wares = NonNullList.func_191196_a();
    private boolean[] missingEssentials = new boolean[ICyberware.EnumSlot.values().length * 2];
    private int storedPower = 0;
    private int prod = 0;
    private int lastProd = 0;
    private int cons = 0;
    private int lastCons = 0;
    private int powerCap = 0;
    private Map<ItemStack, Integer> powerBuffer = new HashMap<ItemStack, Integer>();
    private Map<ItemStack, Integer> powerBufferLast = new HashMap<ItemStack, Integer>();
    private NonNullList<ItemStack> outOfPower = NonNullList.func_191196_a();
    private List<Integer> outOfPowerTimes = new ArrayList<Integer>();
    private int missingEssence = 0;
    private NonNullList<ItemStack> specialBatteries = NonNullList.func_191196_a();
    private int essence = 0;
    private int maxEssence = 0;
    private NonNullList<ItemStack> activeItems = NonNullList.func_191196_a();
    private NonNullList<ItemStack> hudjackItems = NonNullList.func_191196_a();
    private Map<Integer, ItemStack> hotkeys = new HashMap<Integer, ItemStack>();
    private NBTTagCompound hudData = new NBTTagCompound();
    private boolean hasOpenedRadialMenu = false;
    private int hudColor = 65535;
    private float[] hudColorFloat = new float[]{0.0f, 1.0f, 1.0f};
    private boolean canGiveOut = true;
    private boolean isImmune = false;

    public CyberwareUserDataImpl() {
        this.hudData = new NBTTagCompound();
        for (int i = 0; i < ICyberware.EnumSlot.values().length; ++i) {
            NonNullList wareSlot = NonNullList.func_191196_a();
            for (int j = 0; j < 10; ++j) {
                wareSlot.add((Object)ItemStack.field_190927_a);
            }
            this.wares.add((Object)wareSlot);
        }
        this.resetWare(null);
    }

    @Override
    public void resetWare(EntityLivingBase e) {
        for (NonNullList slot : this.wares) {
            for (ItemStack item : slot) {
                if (!CyberwareAPI.isCyberware(item)) continue;
                CyberwareAPI.getCyberware(item).onRemoved(e, item);
            }
        }
        this.missingEssence = 0;
        for (int i = 0; i < this.wares.size(); ++i) {
            NonNullList wareSlot = NonNullList.func_191196_a();
            NonNullList<ItemStack> startItems = CyberwareConfig.getStartingItems(ICyberware.EnumSlot.values()[i]);
            for (ItemStack s : startItems) {
                wareSlot.add((Object)s.func_77946_l());
            }
            this.wares.set(i, (Object)wareSlot);
        }
        this.missingEssentials = new boolean[ICyberware.EnumSlot.values().length * 2];
        this.updateCapacity();
    }

    @Override
    public List<ItemStack> getPowerOutages() {
        return this.outOfPower;
    }

    @Override
    public List<Integer> getPowerOutageTimes() {
        return this.outOfPowerTimes;
    }

    @Override
    public int getCapacity() {
        int specialCap = 0;
        for (ItemStack item : this.specialBatteries) {
            ISpecialBattery battery = (ISpecialBattery)((Object)CyberwareAPI.getCyberware(item));
            specialCap += battery.getCapacity(item);
        }
        return this.powerCap + specialCap;
    }

    @Override
    public int getStoredPower() {
        int specialStored = 0;
        for (ItemStack item : this.specialBatteries) {
            ISpecialBattery battery = (ISpecialBattery)((Object)CyberwareAPI.getCyberware(item));
            specialStored += battery.getStoredEnergy(item);
        }
        return this.storedPower + specialStored;
    }

    @Override
    public float getPercentFull() {
        if (this.getCapacity() == 0) {
            return -1.0f;
        }
        return (float)this.getStoredPower() / (1.0f * (float)this.getCapacity());
    }

    @Override
    public boolean isAtCapacity(ItemStack stack) {
        return this.isAtCapacity(stack, 0);
    }

    @Override
    public boolean isAtCapacity(ItemStack stack, int buffer) {
        int leftOverSpaceNormal = this.powerCap - this.storedPower;
        if (leftOverSpaceNormal > buffer) {
            return false;
        }
        int leftOverSpaceSpecial = 0;
        for (ItemStack batteryStack : this.specialBatteries) {
            ISpecialBattery battery = (ISpecialBattery)((Object)CyberwareAPI.getCyberware(batteryStack));
            int spaceInThisSpecial = battery.add(batteryStack, stack, buffer + 1, true);
            if (leftOverSpaceNormal + (leftOverSpaceSpecial += spaceInThisSpecial) <= buffer) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addPower(int amount, ItemStack inputter) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount must be positive!");
        }
        int amountAlready = 0;
        ItemStack stack = ItemStack.field_190927_a;
        if (!inputter.func_190926_b()) {
            stack = new ItemStack(inputter.func_77973_b(), 1, inputter.func_77952_i());
        }
        if (this.powerBuffer.containsKey(stack)) {
            amountAlready = this.powerBuffer.get(stack);
        }
        this.powerBuffer.put(stack, amount + amountAlready);
        this.prod += amount;
    }

    @Override
    public boolean usePower(ItemStack stack, int amount) {
        return this.usePower(stack, amount, true);
    }

    private int addMap(Map<ItemStack, Integer> map) {
        int total = 0;
        for (ItemStack key : map.keySet()) {
            total += map.get(key).intValue();
        }
        return total;
    }

    private void subtractFromBufferLast(int amount) {
        for (ItemStack key : this.powerBufferLast.keySet()) {
            int get = this.powerBufferLast.get(key);
            int amountToSubtract = Math.min(get, amount);
            this.powerBufferLast.put(key, get - amountToSubtract);
            if ((amount -= amountToSubtract) > 0) continue;
            break;
        }
    }

    @Override
    public boolean usePower(ItemStack stack, int amount, boolean isPassive) {
        if (this.isImmune) {
            return true;
        }
        if (!this.canGiveOut) {
            if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                this.setOutOfPower(stack);
            }
            return false;
        }
        this.cons += amount;
        int getPowerBufferLast = this.addMap(this.powerBufferLast);
        int amountAvailable = this.storedPower + getPowerBufferLast;
        int amountAvailableSpecial = 0;
        if (amountAvailable < amount) {
            int extract;
            ISpecialBattery battery;
            int toGo = amount - amountAvailable;
            for (ItemStack batteryStack : this.specialBatteries) {
                battery = (ISpecialBattery)((Object)CyberwareAPI.getCyberware(batteryStack));
                extract = battery.extract(batteryStack, toGo, true);
                amountAvailableSpecial += extract;
                if ((toGo -= extract) > 0) continue;
                break;
            }
            if (amountAvailableSpecial + amountAvailable >= amount) {
                ItemStack batteryStack;
                toGo = amount - amountAvailable;
                Iterator iterator = this.specialBatteries.iterator();
                while (iterator.hasNext() && (toGo -= (extract = (battery = (ISpecialBattery)((Object)CyberwareAPI.getCyberware(batteryStack = (ItemStack)iterator.next()))).extract(batteryStack, toGo, false))) > 0) {
                }
                amount -= amountAvailableSpecial;
            }
        }
        if (amountAvailable < amount) {
            if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                this.setOutOfPower(stack);
            }
            if (isPassive) {
                this.canGiveOut = false;
            }
            return false;
        }
        int leftAfterBuffer = Math.max(0, amount - getPowerBufferLast);
        this.subtractFromBufferLast(amount);
        this.storedPower -= leftAfterBuffer;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void setOutOfPower(ItemStack stack) {
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        if (p != null && !stack.func_190926_b()) {
            int i = -1;
            int n = 0;
            for (ItemStack e : this.outOfPower) {
                if (!e.func_190926_b() && e.func_77973_b() == stack.func_77973_b() && e.func_77952_i() == stack.func_77952_i()) {
                    i = n;
                    break;
                }
                ++n;
            }
            if (i != -1) {
                this.outOfPower.remove(i);
                this.outOfPowerTimes.remove(i);
            }
            this.outOfPower.add((Object)stack);
            this.outOfPowerTimes.add(p.field_70173_aa);
            if (this.outOfPower.size() >= 8) {
                this.outOfPower.remove(0);
                this.outOfPowerTimes.remove(0);
            }
        }
    }

    @Override
    public NonNullList<ItemStack> getInstalledCyberware(ICyberware.EnumSlot slot) {
        return (NonNullList)this.wares.get(slot.ordinal());
    }

    @Override
    public boolean hasEssential(ICyberware.EnumSlot slot) {
        return !this.missingEssentials[slot.ordinal() * 2];
    }

    @Override
    public boolean hasEssential(ICyberware.EnumSlot slot, ICyberware.ISidedLimb.EnumSide side) {
        return !this.missingEssentials[slot.ordinal() * 2 + (side == ICyberware.ISidedLimb.EnumSide.LEFT ? 0 : 1)];
    }

    @Override
    public void setHasEssential(ICyberware.EnumSlot slot, boolean hasLeft, boolean hasRight) {
        this.missingEssentials[slot.ordinal() * 2] = !hasLeft;
        this.missingEssentials[slot.ordinal() * 2 + 1] = !hasRight;
    }

    @Override
    public void setInstalledCyberware(EntityLivingBase entity, ICyberware.EnumSlot slot, List<ItemStack> cyberware) {
        while (cyberware.size() > 10) {
            cyberware.remove(cyberware.size() - 1);
        }
        while (cyberware.size() < 10) {
            cyberware.add(ItemStack.field_190927_a);
        }
        this.setInstalledCyberware(entity, slot, cyberware);
    }

    @Override
    public void updateCapacity() {
        this.powerCap = 0;
        this.specialBatteries = NonNullList.func_191196_a();
        this.activeItems = NonNullList.func_191196_a();
        this.hudjackItems = NonNullList.func_191196_a();
        this.hotkeys = new HashMap<Integer, ItemStack>();
        for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
            for (ItemStack wareStack : this.getInstalledCyberware(slot)) {
                if (!CyberwareAPI.isCyberware(wareStack)) continue;
                ICyberware ware = CyberwareAPI.getCyberware(wareStack);
                if (ware instanceof IMenuItem && ((IMenuItem)((Object)ware)).hasMenu(wareStack)) {
                    this.activeItems.add((Object)wareStack);
                    int hotkey = HotkeyHelper.getHotkey(wareStack);
                    if (hotkey != -1) {
                        this.hotkeys.put(hotkey, wareStack);
                    }
                }
                if (ware instanceof IHudjack) {
                    this.hudjackItems.add((Object)wareStack);
                }
                if (ware instanceof ISpecialBattery) {
                    this.specialBatteries.add((Object)wareStack);
                    continue;
                }
                this.powerCap += ware.getCapacity(wareStack);
            }
        }
        this.storedPower = Math.min(this.storedPower, this.powerCap);
    }

    @Override
    public void setInstalledCyberware(EntityLivingBase entity, ICyberware.EnumSlot slot, NonNullList<ItemStack> cyberware) {
        if (cyberware.size() != ((NonNullList)this.wares.get(slot.ordinal())).size()) {
            System.out.println("ERROR!");
        }
        NonNullList<ItemStack> newWares = cyberware;
        NonNullList oldWares = (NonNullList)this.wares.get(slot.ordinal());
        if (entity != null) {
            boolean found;
            for (ItemStack oldWare : oldWares) {
                if (!CyberwareAPI.isCyberware(oldWare)) continue;
                found = false;
                for (ItemStack newWare : newWares) {
                    if (!CyberwareAPI.areCyberwareStacksEqual(newWare, oldWare) || newWare.func_190916_E() != oldWare.func_190916_E()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                CyberwareAPI.getCyberware(oldWare).onRemoved(entity, oldWare);
            }
            for (ItemStack newWare : newWares) {
                if (!CyberwareAPI.isCyberware(newWare)) continue;
                found = false;
                for (ItemStack oldWare : oldWares) {
                    if (!CyberwareAPI.areCyberwareStacksEqual(newWare, oldWare) || newWare.func_190916_E() != oldWare.func_190916_E()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                CyberwareAPI.getCyberware(newWare).onAdded(entity, newWare);
            }
        }
        this.wares.set(slot.ordinal(), cyberware);
    }

    @Override
    public boolean isCyberwareInstalled(ItemStack cyberware) {
        return this.getCyberwareRank(cyberware) > 0;
    }

    @Override
    public int getCyberwareRank(ItemStack cyberware) {
        ItemStack cw = this.getCyberware(cyberware);
        if (!cw.func_190926_b()) {
            return cw.func_190916_E();
        }
        return 0;
    }

    @Override
    public ItemStack getCyberware(ItemStack cyberware) {
        NonNullList<ItemStack> slotItems = this.getInstalledCyberware(CyberwareAPI.getCyberware(cyberware).getSlot(cyberware));
        for (ItemStack item : slotItems) {
            if (item.func_190926_b() || item.func_77973_b() != cyberware.func_77973_b() || item.func_77952_i() != cyberware.func_77952_i()) continue;
            return item;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
            NBTTagList list2 = new NBTTagList();
            for (ItemStack cyberware : this.getInstalledCyberware(slot)) {
                NBTTagCompound temp = new NBTTagCompound();
                if (!cyberware.func_190926_b()) {
                    temp = cyberware.func_77955_b(temp);
                }
                list2.func_74742_a((NBTBase)temp);
            }
            list.func_74742_a((NBTBase)list2);
        }
        compound.func_74782_a("cyberware", (NBTBase)list);
        NBTTagList essentialList = new NBTTagList();
        for (int i = 0; i < this.missingEssentials.length; ++i) {
            essentialList.func_74742_a((NBTBase)new NBTTagByte((byte)(this.missingEssentials[i] ? 1 : 0)));
        }
        compound.func_74782_a("discard", (NBTBase)essentialList);
        compound.func_74782_a("powerBuffer", (NBTBase)this.writeMap(this.powerBuffer));
        compound.func_74782_a("powerBufferLast", (NBTBase)this.writeMap(this.powerBufferLast));
        compound.func_74768_a("powerCap", this.powerCap);
        compound.func_74768_a("storedPower", this.storedPower);
        compound.func_74768_a("missingEssence", this.missingEssence);
        compound.func_74782_a("hud", (NBTBase)this.hudData);
        compound.func_74768_a("color", this.hudColor);
        compound.func_74757_a("hasOpenedRadialMenu", this.hasOpenedRadialMenu);
        return compound;
    }

    private NBTTagList writeMap(Map<ItemStack, Integer> map) {
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : map.keySet()) {
            NBTTagCompound temp = new NBTTagCompound();
            NBTTagCompound item = new NBTTagCompound();
            temp.func_74757_a("null", stack.func_190926_b());
            if (!stack.func_190926_b()) {
                stack.func_77955_b(item);
                temp.func_74782_a("item", (NBTBase)item);
            }
            temp.func_74768_a("value", map.get(stack).intValue());
            list.func_74742_a((NBTBase)temp);
        }
        return list;
    }

    private Map<ItemStack, Integer> readMap(NBTTagList list) {
        HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound temp = list.func_150305_b(i);
            boolean isNull = temp.func_74767_n("null");
            ItemStack stack = ItemStack.field_190927_a;
            if (!isNull) {
                stack = new ItemStack(temp.func_74775_l("item"));
            }
            map.put(stack, temp.func_74762_e("value"));
        }
        return map;
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        this.powerBuffer = this.readMap((NBTTagList)tag.func_74781_a("powerBuffer"));
        this.powerCap = tag.func_74762_e("powerCap");
        this.powerBufferLast = this.readMap((NBTTagList)tag.func_74781_a("powerBufferLast"));
        this.storedPower = tag.func_74762_e("storedPower");
        this.missingEssence = tag.func_74764_b("essence") ? this.getMaxEssence() - tag.func_74762_e("essence") : tag.func_74762_e("missingEssence");
        this.hudData = tag.func_74775_l("hud");
        this.hasOpenedRadialMenu = tag.func_74767_n("hasOpenedRadialMenu");
        NBTTagList essentialList = (NBTTagList)tag.func_74781_a("discard");
        for (int i = 0; i < essentialList.func_74745_c(); ++i) {
            this.missingEssentials[i] = ((NBTTagByte)essentialList.func_179238_g(i)).func_150290_f() > 0;
        }
        NBTTagList list = (NBTTagList)tag.func_74781_a("cyberware");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            int j;
            ICyberware.EnumSlot slot = ICyberware.EnumSlot.values()[i];
            NBTTagList list2 = (NBTTagList)list.func_179238_g(i);
            NonNullList cyberware = NonNullList.func_191196_a();
            for (j = 0; j < 10; ++j) {
                cyberware.add((Object)ItemStack.field_190927_a);
            }
            for (j = 0; j < list2.func_74745_c() && j < cyberware.size(); ++j) {
                cyberware.set(j, (Object)new ItemStack(list2.func_150305_b(j)));
            }
            this.setInstalledCyberware(null, slot, (NonNullList<ItemStack>)cyberware);
        }
        int color = 65535;
        if (tag.func_74764_b("color")) {
            color = tag.func_74762_e("color");
        }
        this.setHudColor(color);
        this.updateCapacity();
    }

    private void storePower(Map<ItemStack, Integer> map) {
        for (ItemStack item : this.specialBatteries) {
            for (ItemStack key : map.keySet()) {
                ISpecialBattery battery = (ISpecialBattery)((Object)CyberwareAPI.getCyberware(item));
                int keyAmount = map.get(key);
                int amountTaken = battery.add(item, key, keyAmount, false);
                map.put(key, keyAmount - amountTaken);
            }
        }
        this.storedPower = Math.min(this.powerCap, this.storedPower + this.addMap(map));
    }

    @Override
    public void resetBuffer() {
        this.canGiveOut = true;
        this.storePower(this.powerBufferLast);
        this.powerBufferLast = this.powerBuffer;
        this.powerBuffer = new HashMap<ItemStack, Integer>();
        this.isImmune = false;
        this.lastCons = this.cons;
        this.lastProd = this.prod;
        this.prod = 0;
        this.cons = 0;
    }

    @Override
    public void setImmune() {
        this.isImmune = true;
    }

    @Override
    @Deprecated
    public int getEssence() {
        return this.getMaxEssence() - this.missingEssence;
    }

    @Override
    @Deprecated
    public int getMaxEssence() {
        return CyberwareConfig.ESSENCE;
    }

    @Override
    @Deprecated
    public void setEssence(int e) {
        this.missingEssence = this.getMaxEssence() - e;
    }

    @Override
    public int getMaxTolerance(EntityLivingBase e) {
        return (int)e.func_110140_aT().func_111151_a(CyberwareAPI.TOLERANCE_ATTR).func_111126_e();
    }

    @Override
    public int getTolerance(EntityLivingBase e) {
        return this.getMaxTolerance(e) - this.missingEssence;
    }

    @Override
    public void setTolerance(EntityLivingBase e, int amt) {
        this.missingEssence = this.getMaxTolerance(e) - amt;
    }

    @Override
    public int getNumActiveItems() {
        return this.activeItems.size();
    }

    @Override
    public List<ItemStack> getActiveItems() {
        return this.activeItems;
    }

    @Override
    public List<ItemStack> getHudjackItems() {
        return this.hudjackItems;
    }

    @Override
    public void removeHotkey(int i) {
        if (this.hotkeys.containsKey(i)) {
            this.hotkeys.remove(i);
        }
    }

    @Override
    public void addHotkey(int i, ItemStack stack) {
        this.hotkeys.put(i, stack);
    }

    @Override
    public ItemStack getHotkey(int i) {
        if (!this.hotkeys.containsKey(i)) {
            return ItemStack.field_190927_a;
        }
        return this.hotkeys.get(i);
    }

    @Override
    public Iterable<Integer> getHotkeys() {
        return this.hotkeys.keySet();
    }

    @Override
    public void setHudData(NBTTagCompound comp) {
        this.hudData = comp;
    }

    @Override
    public NBTTagCompound getHudData() {
        return this.hudData;
    }

    @Override
    public boolean hasOpenedRadialMenu() {
        return this.hasOpenedRadialMenu;
    }

    @Override
    public void setOpenedRadialMenu(boolean hasOpenedRadialMenu) {
        this.hasOpenedRadialMenu = hasOpenedRadialMenu;
    }

    @Override
    public void setHudColor(int hexVal) {
        float r = (float)(hexVal >> 16 & 0xFF) / 255.0f;
        float g = (float)(hexVal >> 8 & 0xFF) / 255.0f;
        float b = (float)(hexVal & 0xFF) / 255.0f;
        this.setHudColor(new float[]{r, g, b});
    }

    @Override
    public int getHudColorHex() {
        return this.hudColor;
    }

    @Override
    public void setHudColor(float[] color) {
        this.hudColorFloat = color;
        int ri = Math.round(color[0] * 255.0f);
        int gi = Math.round(color[1] * 255.0f);
        int bi = Math.round(color[2] * 255.0f);
        int rp = ri << 16 & 0xFF0000;
        int gp = gi << 8 & 0xFF00;
        int bp = bi & 0xFF;
        this.hudColor = rp | gp | bp;
    }

    @Override
    public float[] getHudColor() {
        return this.hudColorFloat;
    }

    @Override
    public int getProduction() {
        return this.lastProd;
    }

    @Override
    public int getConsumption() {
        return this.lastCons;
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        public static final ResourceLocation NAME = new ResourceLocation("cyberware", "cyberware");
        private final ICyberwareUserData cap = new CyberwareUserDataImpl();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CyberwareAPI.CYBERWARE_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CyberwareAPI.CYBERWARE_CAPABILITY) {
                return (T)CyberwareAPI.CYBERWARE_CAPABILITY.cast((Object)this.cap);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return this.cap.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.cap.deserializeNBT(nbt);
        }
    }

    private static class CyberwareUserDataStorage
    implements Capability.IStorage<ICyberwareUserData> {
        private CyberwareUserDataStorage() {
        }

        public NBTBase writeNBT(Capability<ICyberwareUserData> capability, ICyberwareUserData instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<ICyberwareUserData> capability, ICyberwareUserData instance, EnumFacing side, NBTBase nbt) {
            if (!(nbt instanceof NBTTagCompound)) {
                throw new IllegalStateException("Cyberware NBT should be a NBTTagCompound!");
            }
            instance.deserializeNBT((NBTTagCompound)nbt);
        }
    }
}

