/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.tile.base;

import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.TileColorableMachineComponent;
import modulardiversity.components.requirements.RequirementMana;
import modulardiversity.util.ICraftingResourceHolder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import vazkii.botania.api.mana.IManaReceiver;

public abstract class TileEntityMana
extends TileColorableMachineComponent
implements MachineComponentTile,
IManaReceiver,
ICraftingResourceHolder<RequirementMana.ResourceToken> {
    private int mana;
    private int capacity = 10000;

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.mana = compound.func_74762_e("mana");
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74768_a("mana", this.mana);
    }

    @Override
    public boolean consume(RequirementMana.ResourceToken token, boolean doConsume) {
        int manaConsumed = Math.min(this.getCurrentMana(), token.getMana());
        token.setMana(token.getMana() - manaConsumed);
        if (doConsume) {
            this.setCurrentMana(this.getCurrentMana() - manaConsumed);
        }
        return manaConsumed > 0;
    }

    @Override
    public boolean generate(RequirementMana.ResourceToken token, boolean doGenerate) {
        int manaAdded = Math.min(this.getManaCapacity() - this.getCurrentMana(), token.getMana());
        token.setMana(token.getMana() - manaAdded);
        if (doGenerate) {
            this.setCurrentMana(this.getCurrentMana() + manaAdded);
        }
        return manaAdded > 0;
    }

    public int getManaCapacity() {
        return this.capacity;
    }

    public void setCurrentMana(int mana) {
        this.mana = mana;
    }

    public void recieveMana(int i) {
        this.setCurrentMana(MathHelper.func_76125_a((int)(this.getCurrentMana() + i), (int)0, (int)this.getManaCapacity()));
    }

    public int getCurrentMana() {
        return this.mana;
    }
}

