/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.List;
import javax.annotation.Nonnull;
import modulardiversity.util.ICraftingResourceHolder;
import modulardiversity.util.IResourceToken;

public abstract class RequirementConsumePerTick<T, V extends IResourceToken>
extends ComponentRequirement.PerTick<T> {
    V checkToken;
    V perTickToken;

    public RequirementConsumePerTick(ComponentType componentType, MachineComponent.IOType actionType) {
        super(componentType, actionType);
    }

    public boolean startCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance resultChance) {
        return this.canStartCrafting(component, context, Lists.newArrayList()) == ComponentRequirement.CraftCheck.SUCCESS;
    }

    public boolean finishCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance resultChance) {
        return true;
    }

    public ComponentRequirement.CraftCheck canStartCrafting(MachineComponent component, RecipeCraftingContext context, List<ComponentOutputRestrictor> list) {
        if (!this.isCorrectHatch(component)) {
            return ComponentRequirement.CraftCheck.INVALID_SKIP;
        }
        ICraftingResourceHolder handler = (ICraftingResourceHolder)context.getProvidedCraftingComponent(component);
        switch (this.getActionType()) {
            case INPUT: {
                boolean didConsume = handler.consume(this.checkToken, false);
                if (!didConsume) {
                    return ComponentRequirement.CraftCheck.FAILURE_MISSING_INPUT;
                }
                if (this.checkToken.isEmpty()) {
                    return ComponentRequirement.CraftCheck.SUCCESS;
                }
                return ComponentRequirement.CraftCheck.PARTIAL_SUCCESS;
            }
            case OUTPUT: {
                handler.generate(this.checkToken, false);
                if (this.checkToken.isEmpty()) {
                    return ComponentRequirement.CraftCheck.SUCCESS;
                }
                return ComponentRequirement.CraftCheck.PARTIAL_SUCCESS;
            }
        }
        return ComponentRequirement.CraftCheck.FAILURE_MISSING_INPUT;
    }

    public void startRequirementCheck(ResultChance chance, RecipeCraftingContext context) {
        this.checkToken = this.emitConsumptionToken(context);
        this.checkToken.setModifier(context.applyModifiers((ComponentRequirement)this, this.getActionType(), this.checkToken.getModifier(), false));
    }

    public void endRequirementCheck() {
        this.checkToken = this.emitConsumptionToken(null);
    }

    public void resetIOTick(RecipeCraftingContext context) {
        this.perTickToken = this.emitConsumptionToken(context);
    }

    public void startIOTick(RecipeCraftingContext context, float durationMultiplier) {
        this.perTickToken.setModifier(context.applyModifiers((ComponentRequirement)this, this.getActionType(), this.perTickToken.getModifier(), false) * durationMultiplier);
    }

    protected abstract V emitConsumptionToken(RecipeCraftingContext var1);

    protected abstract boolean isCorrectHatch(MachineComponent var1);

    @Nonnull
    public ComponentRequirement.CraftCheck doIOTick(MachineComponent component, RecipeCraftingContext context) {
        if (!this.isCorrectHatch(component)) {
            return ComponentRequirement.CraftCheck.INVALID_SKIP;
        }
        ICraftingResourceHolder handler = (ICraftingResourceHolder)context.getProvidedCraftingComponent(component);
        switch (this.getActionType()) {
            case INPUT: {
                boolean didConsume = handler.consume(this.perTickToken, true);
                if (!didConsume) {
                    return ComponentRequirement.CraftCheck.FAILURE_MISSING_INPUT;
                }
                if (this.perTickToken.isEmpty()) {
                    return ComponentRequirement.CraftCheck.SUCCESS;
                }
                return ComponentRequirement.CraftCheck.PARTIAL_SUCCESS;
            }
            case OUTPUT: {
                handler.generate(this.perTickToken, true);
                if (this.perTickToken.isEmpty()) {
                    return ComponentRequirement.CraftCheck.SUCCESS;
                }
                return ComponentRequirement.CraftCheck.PARTIAL_SUCCESS;
            }
        }
        return ComponentRequirement.CraftCheck.INVALID_SKIP;
    }
}

