/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.tile;

import com.teamwizardry.librarianlib.features.autoregister.TileRegister;
import com.teamwizardry.librarianlib.features.base.block.tile.module.ModuleInventory;
import com.teamwizardry.librarianlib.features.saving.Module;
import com.teamwizardry.librarianlib.features.saving.Save;
import com.teamwizardry.wizardry.api.block.TileManaInteractor;
import com.teamwizardry.wizardry.api.capability.mana.IWizardryCapability;
import com.teamwizardry.wizardry.api.capability.mana.WizardryCapabilityProvider;
import com.teamwizardry.wizardry.api.item.ICooldown;
import com.teamwizardry.wizardry.api.item.IManaCell;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellUtils;
import com.teamwizardry.wizardry.common.item.ItemNacrePearl;
import com.teamwizardry.wizardry.common.item.ItemOrb;
import com.teamwizardry.wizardry.common.tile.TileManaMagnet;
import com.teamwizardry.wizardry.init.ModItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.items.ItemStackHandler;

@TileRegister(value="wizardry:pedestal")
public class TilePearlHolder
extends TileManaInteractor
implements ICooldown {
    @Module
    public ModuleInventory inventory = new ModuleInventory(new ItemStackHandler(){

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            if (stack.func_77973_b() instanceof IManaCell || stack.func_77973_b() instanceof ItemNacrePearl) {
                return super.getStackLimit(slot, stack);
            }
            return 0;
        }
    });
    @Save
    public boolean isPartOfStructure = false;
    @Save
    @Nullable
    public BlockPos structurePos = null;

    @Override
    @Nullable
    public IWizardryCapability getWizardryCap() {
        if (this.containsAnyOrb()) {
            return WizardryCapabilityProvider.getCap(this.getItemStack());
        }
        return null;
    }

    public TilePearlHolder() {
        super(300.0, 300.0);
    }

    @Override
    @Nonnull
    public Vec3d getOffset() {
        return new Vec3d(0.0, 0.5, 0.0);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.containsAnyOrb()) {
            ModItems.ORB.func_77663_a(this.getItemStack(), this.func_145831_w(), null, 0, true);
        } else if (this.containsNacrePearl()) {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            IWizardryCapability pearlCap = WizardryCapabilityProvider.getCap(this.getItemStack());
            if (pearlCap == null || pearlCap.getMana() > pearlCap.getMaxMana() || this.isPartOfStructure || this.structurePos != null) {
                return;
            }
            if (this.field_145850_b.func_175640_z(this.func_174877_v())) {
                return;
            }
            if (this.isCoolingDown(this.field_145850_b, this.getItemStack())) {
                return;
            }
            if (pearlCap.getMana() == 0.0) {
                return;
            }
            BlockPos closestMagnet = this.getNearestTilePos(TileManaMagnet.class);
            if (closestMagnet == null) {
                return;
            }
            Vec3d direction = new Vec3d((Vec3i)closestMagnet).func_178788_d(new Vec3d((Vec3i)this.func_174877_v())).func_72432_b();
            SpellData spell = new SpellData(this.func_145831_w());
            spell.addData(SpellData.DefaultKeys.LOOK, direction);
            spell.addData(SpellData.DefaultKeys.ORIGIN, new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, 1.5, 0.5));
            spell.addData(SpellData.DefaultKeys.CAPABILITY, pearlCap);
            SpellUtils.runSpell(this.getItemStack(), spell);
            this.setCooldown(this.field_145850_b, null, null, this.getItemStack(), spell);
        }
    }

    public boolean containsSomething() {
        return this.containsAnyOrb() || this.containsNacrePearl();
    }

    public boolean containsAnyOrb() {
        return this.getItemStack().func_77973_b() instanceof ItemOrb;
    }

    public boolean containsGlassOrb() {
        return this.getItemStack().func_77973_b() instanceof ItemOrb && this.getItemStack().func_77952_i() == 0;
    }

    public boolean containsManaOrb() {
        return this.getItemStack().func_77973_b() instanceof ItemOrb && this.getItemStack().func_77952_i() == 1;
    }

    public boolean containsNacrePearl() {
        return this.getItemStack().func_77973_b() instanceof ItemNacrePearl;
    }

    public ItemStack getItemStack() {
        return ((ItemStackHandler)this.inventory.getHandler()).getStackInSlot(0);
    }

    public void setItemStack(ItemStack stack) {
        ((ItemStackHandler)this.inventory.getHandler()).setStackInSlot(0, stack);
    }
}

