/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.shapes;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpCircle;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.api.spell.ILingeringModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.ModuleOverride;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleShape;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceShape;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.common.module.shapes.IShapeOverrides;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@RegisterModule(ID="shape_zone")
public class ModuleShapeZone
implements IModuleShape,
ILingeringModule {
    public static final String ZONE_OFFSET = "zone offset";
    public static final String ZONE_CAST = "zone cast";

    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_aoe", "modifier_increase_potency", "modifier_extend_range", "modifier_extend_time"};
    }

    @Override
    public boolean ignoreResultsForRendering() {
        return true;
    }

    @Override
    public boolean shouldRunChildren() {
        return false;
    }

    @Override
    public boolean run(ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Vec3d targetPos = spell.getTargetWithFallback();
        if (targetPos == null) {
            return false;
        }
        double aoe = spellRing.getAttributeValue(AttributeRegistry.AREA, spell);
        double potency = spellRing.getAttributeValue(AttributeRegistry.POTENCY, spell);
        double range = spellRing.getAttributeValue(AttributeRegistry.RANGE, spell);
        Vec3d min = targetPos.func_178786_a(aoe / 2.0, range / 2.0, aoe / 2.0);
        Vec3d max = targetPos.func_72441_c(aoe / 2.0, range / 2.0, aoe / 2.0);
        NBTTagCompound info = spell.getData(SpellData.DefaultKeys.COMPOUND, new NBTTagCompound());
        double zoneOffset = info.func_74769_h(ZONE_OFFSET) + potency;
        info.func_74757_a(ZONE_CAST, false);
        if (zoneOffset >= (double)ConfigValues.zoneTimer) {
            zoneOffset %= (double)ConfigValues.zoneTimer;
            if (!spellRing.taxCaster(spell, true)) {
                info.func_74780_a(ZONE_OFFSET, zoneOffset);
                spell.addData(SpellData.DefaultKeys.COMPOUND, info);
                return false;
            }
            IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
            overrides.onRunZone(spell, spellRing);
            BlockPos target = new BlockPos(RandUtil.nextDouble(min.field_72450_a, max.field_72450_a), RandUtil.nextDouble(min.field_72448_b, max.field_72448_b), RandUtil.nextDouble(min.field_72449_c, max.field_72449_c));
            List entities = world.func_72839_b(null, new AxisAlignedBB(target));
            for (Entity entity : entities) {
                Vec3d vec = new Vec3d(RandUtil.nextDouble(min.field_72450_a, max.field_72450_a), RandUtil.nextDouble(min.field_72448_b, max.field_72448_b), RandUtil.nextDouble(min.field_72449_c, max.field_72449_c));
                SpellData copy = spell.copy();
                copy.processEntity(entity, false);
                copy.addData(SpellData.DefaultKeys.YAW, Float.valueOf(entity.field_70177_z));
                copy.addData(SpellData.DefaultKeys.PITCH, Float.valueOf(entity.field_70125_A));
                copy.addData(SpellData.DefaultKeys.ORIGIN, vec);
                if (spellRing.getChildRing() == null) continue;
                spellRing.getChildRing().runSpellRing(spell);
            }
            Vec3d pos = new Vec3d((Vec3i)target).func_72441_c(0.5, 0.5, 0.5);
            SpellData copy = spell.copy();
            copy.addData(SpellData.DefaultKeys.ORIGIN, pos);
            copy.processBlock(target, EnumFacing.UP, pos);
            copy.addData(SpellData.DefaultKeys.YAW, Float.valueOf(RandUtil.nextFloat(-180.0f, 180.0f)));
            copy.addData(SpellData.DefaultKeys.PITCH, Float.valueOf(RandUtil.nextFloat(-50.0f, 50.0f)));
            if (spellRing.getChildRing() != null) {
                spellRing.getChildRing().runSpellRing(copy);
            }
        }
        info.func_74780_a(ZONE_OFFSET, zoneOffset);
        spell.addData(SpellData.DefaultKeys.COMPOUND, info);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
        if (overrides.onRenderZone(spell, spellRing)) {
            return;
        }
        Vec3d target = spell.getTarget();
        if (target == null) {
            return;
        }
        if (RandUtil.nextInt(10) != 0) {
            return;
        }
        double aoe = spellRing.getAttributeValue(AttributeRegistry.AREA, spell);
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
        glitter.setCollision(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)spell.world, (InterpFunction)new InterpCircle(target, new Vec3d(0.0, 1.0, 0.0), (float)aoe, 1.0f, RandUtil.nextFloat()), (int)((int)(aoe * 25.0)), (int)10, (aFloat, particleBuilder) -> {
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 0.3f));
            glitter.setLifetime(RandUtil.nextInt(30, 50));
            glitter.setColorFunction((InterpFunction)new InterpColorHSV(spellRing.getPrimaryColor(), spellRing.getSecondaryColor()));
            glitter.setMotion(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.01, 0.01)));
        });
    }

    @Override
    public int getLingeringTime(SpellData spell, SpellRing spellRing) {
        return (int)spellRing.getAttributeValue(AttributeRegistry.DURATION, spell) * 10;
    }

    @ModuleOverride(value="shape_zone_run")
    public void onRunZone(SpellData data, SpellRing shape) {
    }

    @ModuleOverride(value="shape_zone_render")
    public boolean onRenderZone(SpellData data, SpellRing shape) {
        return false;
    }
}

