/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.shapes;

import com.google.common.base.Predicate;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpLine;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.ModuleOverride;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleShape;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceShape;
import com.teamwizardry.wizardry.api.util.PosUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RayTrace;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.common.module.shapes.IShapeOverrides;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@RegisterModule(ID="shape_cone")
public class ModuleShapeCone
implements IModuleShape {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_potency", "modifier_extend_range"};
    }

    @Override
    public boolean ignoreResultsForRendering() {
        return true;
    }

    @Override
    public boolean shouldRunChildren() {
        return false;
    }

    @Override
    public boolean run(ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        float yaw = spell.getData(SpellData.DefaultKeys.YAW, Float.valueOf(0.0f)).floatValue();
        float pitch = spell.getData(SpellData.DefaultKeys.PITCH, Float.valueOf(0.0f)).floatValue();
        Entity caster = spell.getCaster();
        Vec3d origin = spell.getOriginHand();
        if (origin == null) {
            return false;
        }
        double range = spellRing.getAttributeValue(AttributeRegistry.RANGE, spell);
        int potency = (int)spellRing.getAttributeValue(AttributeRegistry.POTENCY, spell);
        for (int i = 0; i < potency; ++i) {
            if (!spellRing.taxCaster(spell, 1.0 / (double)potency, true)) {
                return false;
            }
            long seed = RandUtil.nextLong(100L, 10000L);
            spell.addData(SpellData.DefaultKeys.SEED, seed);
            IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
            overrides.onRunCone(spell, spellRing);
            float angle = (float)range * 2.0f;
            float newPitch = pitch + RandUtil.nextFloat(-angle, angle);
            float newYaw = yaw + RandUtil.nextFloat(-angle, angle);
            Vec3d target = PosUtils.vecFromRotations(newPitch, newYaw);
            SpellData newSpell = spell.copy();
            RayTraceResult result = new RayTrace(world, target.func_72432_b(), origin, range).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != caster)).trace();
            Vec3d lookFallback = spell.getData(SpellData.DefaultKeys.LOOK);
            if (lookFallback != null) {
                lookFallback.func_186678_a(range);
            }
            newSpell.processTrace(result, lookFallback);
            instance.sendRenderPacket(newSpell, spellRing);
            newSpell.addData(SpellData.DefaultKeys.ORIGIN, result.field_72307_f);
            if (spellRing.getChildRing() == null) continue;
            spellRing.getChildRing().runSpellRing(newSpell.copy());
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
        if (overrides.onRenderCone(spell, spellRing)) {
            return;
        }
        Vec3d target = spell.getTarget();
        if (target == null) {
            return;
        }
        Vec3d origin = spell.getOriginHand();
        if (origin == null) {
            return;
        }
        ParticleBuilder lines = new ParticleBuilder(10);
        lines.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        lines.setScaleFunction((InterpFunction)new InterpScale(0.5f, 0.0f));
        lines.setColorFunction((InterpFunction)new InterpColorHSV(spellRing.getPrimaryColor(), spellRing.getSecondaryColor()));
        ParticleSpawner.spawn((ParticleBuilder)lines, (World)spell.world, (InterpFunction)new InterpLine(origin, target), (int)((int)target.func_72438_d(origin) * 4), (int)0, (aFloat, particleBuilder) -> {
            lines.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 0.3f));
            lines.setLifetime(RandUtil.nextInt(10, 20));
        });
    }

    @ModuleOverride(value="shape_cone_run")
    public void onRunCone(SpellData data, SpellRing shape) {
    }

    @ModuleOverride(value="shape_cone_render")
    public boolean onRenderCone(SpellData data, SpellRing shape) {
        return false;
    }
}

