/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.BlockUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.common.tile.TileLight;
import com.teamwizardry.wizardry.init.ModBlocks;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@RegisterModule(ID="effect_light")
public class ModuleEffectLight
implements IModuleEffect {
    @Override
    public boolean run(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        BlockPos targetPos = spell.getTargetPos();
        EnumFacing facing = spell.getFaceHit();
        Entity caster = spell.getCaster();
        if (!spellRing.taxCaster(spell, true)) {
            return false;
        }
        if (targetPos == null) {
            return true;
        }
        BlockPos finalPos = targetPos;
        if (facing != null && world.func_175623_d(targetPos.func_177972_a(facing))) {
            finalPos = targetPos.func_177972_a(facing);
        }
        BlockUtils.placeBlock(world, finalPos, ModBlocks.LIGHT.func_176223_P(), caster instanceof EntityPlayerMP ? (EntityPlayerMP)caster : null);
        TileLight te = BlockUtils.getTileEntity((IBlockAccess)world, finalPos, TileLight.class);
        if (te != null) {
            te.setModule(instance);
        }
        world.func_184133_a(null, targetPos, (SoundEvent)ModSounds.SPARKLE, SoundCategory.AMBIENT, 1.0f, 1.0f);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        BlockPos position = spell.getTargetPos();
        EnumFacing facing = spell.getFaceHit();
        if (position == null) {
            return;
        }
        BlockPos finalPos = position;
        if (facing != null && world.func_175623_d(position.func_177972_a(facing))) {
            finalPos = position.func_177972_a(facing);
        }
        ParticleBuilder glitter = new ParticleBuilder(30);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 0.3f));
        glitter.enableMotionCalculation();
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)new Vec3d((Vec3i)finalPos).func_72441_c(0.5, 0.5, 0.5)), (int)500, (int)0, (i, build) -> {
            double radius = 1.0;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.2f, 1.0f), 0.0f));
            build.setMotion(new Vec3d(x, RandUtil.nextDouble(-radius, radius), z).func_72432_b().func_186678_a((double)RandUtil.nextFloat()));
            build.setAcceleration(Vec3d.field_186680_a);
            build.setLifetime(20);
            build.setDeceleration(new Vec3d(0.4, 0.4, 0.4));
            if (RandUtil.nextBoolean()) {
                build.setColorFunction((InterpFunction)new InterpColorHSV(instance.getPrimaryColor(), instance.getSecondaryColor()));
            } else {
                build.setColorFunction((InterpFunction)new InterpColorHSV(instance.getSecondaryColor(), instance.getPrimaryColor()));
            }
        });
    }
}

