/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.block;

import com.teamwizardry.librarianlib.features.base.block.BlockMod;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCloud
extends BlockMod {
    public static final PropertyBool HAS_LIGHT_VALUE = PropertyBool.func_177716_a((String)"has_light_value");

    public BlockCloud() {
        super("cloud", Material.field_151580_n, new String[0]);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)HAS_LIGHT_VALUE, (Comparable)Boolean.valueOf(false)));
        this.func_149713_g(0);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = world.func_180495_p(pos.func_177972_a(side));
        return state != iblockstate;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HAS_LIGHT_VALUE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HAS_LIGHT_VALUE, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HAS_LIGHT_VALUE) != false ? 1 : 0;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int i;
        super.func_180633_a(world, pos, state, placer, stack);
        boolean hasLightValue = (Boolean)state.func_177229_b((IProperty)HAS_LIGHT_VALUE);
        for (i = 1; i < pos.func_177956_o(); ++i) {
            if (!hasLightValue || world.func_175623_d(pos.func_177979_c(i))) continue;
            hasLightValue = false;
            state = state.func_177226_a((IProperty)HAS_LIGHT_VALUE, (Comparable)Boolean.valueOf(false));
            break;
        }
        for (i = 1; i < 255 - pos.func_177956_o(); ++i) {
            if (world.func_180495_p(pos.func_177981_b(i)) != this.func_176223_P().func_177226_a((IProperty)HAS_LIGHT_VALUE, (Comparable)Boolean.valueOf(true))) continue;
            world.func_180501_a(pos.func_177981_b(i), this.func_176223_P().func_177226_a((IProperty)HAS_LIGHT_VALUE, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        int i;
        boolean isLowest = true;
        for (i = 1; i < pos.func_177956_o(); ++i) {
            if (world.func_175623_d(pos.func_177979_c(i))) continue;
            isLowest = false;
        }
        if (isLowest) {
            for (i = 1; i < 255 - pos.func_177956_o(); ++i) {
                if (world.func_180495_p(pos.func_177981_b(i)) != this.func_176223_P().func_177226_a((IProperty)HAS_LIGHT_VALUE, (Comparable)Boolean.valueOf(true))) continue;
                world.func_180501_a(pos.func_177981_b(i), this.func_176223_P().func_177226_a((IProperty)HAS_LIGHT_VALUE, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)HAS_LIGHT_VALUE) != false ? 15 : 0;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return true;
    }

    public void func_176216_a(World worldIn, Entity entityIn) {
        if (entityIn.field_70181_x < -0.5) {
            entityIn.field_70181_x = -entityIn.field_70181_x * 0.625;
            if (!(entityIn instanceof EntityLivingBase)) {
                entityIn.field_70181_x *= 0.8;
            }
        } else {
            entityIn.field_70181_x = 0.0;
        }
    }
}

