/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.render.block;

import com.teamwizardry.librarianlib.core.client.ClientTickHandler;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.common.tile.TileJar;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileJarRenderer
extends TileEntitySpecialRenderer<TileJar> {
    private IBakedModel modelJar;

    public TileJarRenderer() {
        ClientRunnable.registerReloadHandler(() -> {
            this.modelJar = null;
        });
    }

    private void getBakedModels() {
        IModel model = null;
        if (this.modelJar == null) {
            try {
                model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("wizardry", "block/jar"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.modelJar = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
        }
    }

    public void render(TileJar te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!te.hasFairy) {
            return;
        }
        double timeDifference = (double)((float)ClientTickHandler.getTicks() + partialTicks) / 20.0;
        Vec3d pos = new Vec3d((Vec3i)te.func_174877_v()).func_72441_c(0.5, 0.35 + 0.2 * (double)MathHelper.func_76126_a((float)((float)timeDifference)), 0.5);
        Color color = te.color;
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setColor(color);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.2f, 1.0f));
        glitter.setScale(0.3f);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)te.func_145831_w(), (InterpFunction)new StaticInterp((Object)pos), (int)1);
        if (RandUtil.nextInt(10) == 0) {
            ParticleBuilder trail = new ParticleBuilder(20);
            trail.setColor(te.color);
            trail.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            trail.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.2f, 1.0f));
            trail.setScale(0.2f);
            ParticleSpawner.spawn((ParticleBuilder)trail, (World)te.func_145831_w(), (InterpFunction)new StaticInterp((Object)pos), (int)1, (int)0, (aFloat, particleBuilder) -> trail.setMotion(new Vec3d(RandUtil.nextDouble(-0.005, 0.005), RandUtil.nextDouble(-0.005, 0.005), RandUtil.nextDouble(-0.005, 0.005))));
        }
    }
}

