/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.fx;

import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpBezier3D;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpHelix;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpLine;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.librarianlib.features.particlesystem.ParticleSystem;
import com.teamwizardry.librarianlib.features.particlesystem.ReadParticleBinding;
import com.teamwizardry.librarianlib.features.particlesystem.ReadWriteParticleBinding;
import com.teamwizardry.librarianlib.features.particlesystem.WriteParticleBinding;
import com.teamwizardry.librarianlib.features.particlesystem.bindings.EaseBinding;
import com.teamwizardry.librarianlib.features.particlesystem.bindings.StoredBinding;
import com.teamwizardry.librarianlib.features.particlesystem.modules.BasicPhysicsUpdateModule;
import com.teamwizardry.librarianlib.features.particlesystem.modules.SpriteRenderModule;
import com.teamwizardry.wizardry.api.util.ColorUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class LibParticles {
    public static void EXPLODE(World world, Vec3d pos, Color color1, Color color2, double strengthUpwards, double strengthSideways, int amount, int lifeTime, int lifeTimeRange, boolean bounce) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setCollision(true);
        glitter.enableMotionCalculation();
        glitter.setColorFunction((InterpFunction)new InterpColorHSV(ColorUtils.changeColorAlpha(color1, RandUtil.nextInt(50, 150)), ColorUtils.changeColorAlpha(color2, RandUtil.nextInt(50, 150))));
        glitter.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.03, -0.04), 0.0));
        glitter.setCanBounce(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)amount, (int)0, (i, build) -> {
            double radius = RandUtil.nextDouble(1.0, 2.0);
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            Vec3d normalize = new Vec3d(x, 0.0, z).func_72432_b();
            glitter.setMotion(new Vec3d(normalize.field_72450_a * RandUtil.nextDouble(-strengthSideways, strengthSideways), RandUtil.nextDouble(-strengthUpwards, strengthUpwards), normalize.field_72449_c * RandUtil.nextDouble(-strengthSideways, strengthSideways)));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, RandUtil.nextFloat()));
            glitter.setLifetime(RandUtil.nextInt(lifeTime - lifeTimeRange, lifeTime + lifeTimeRange));
            glitter.setScale(RandUtil.nextFloat());
        });
    }

    public static void FIZZING_AMBIENT(World world, Vec3d pos) {
        ParticleBuilder glitter = new ParticleBuilder(30);
        glitter.setScale(0.3f);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 0.3f));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)new Vec3d(pos.field_72450_a + RandUtil.nextDouble(-0.5, 0.5), pos.field_72448_b + RandUtil.nextDouble(-0.5, 0.5), pos.field_72449_c + RandUtil.nextDouble(-0.5, 0.5))), (int)1, (int)0, (aFloat, particleBuilder) -> {
            glitter.setColor(ColorUtils.changeColorAlpha(new Color(38911), RandUtil.nextInt(100, 255)));
            glitter.setLifetime(RandUtil.nextInt(20, 30));
            glitter.setMotion(new Vec3d(RandUtil.nextDouble(-0.05, 0.05), RandUtil.nextDouble(0.05, 0.1), RandUtil.nextDouble(-0.05, 0.05)));
        });
    }

    public static void FIZZING_ITEM(World world, Vec3d pos) {
        ParticleBuilder fizz = new ParticleBuilder(10);
        fizz.setScale(0.3f);
        fizz.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        fizz.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 0.3f));
        ParticleSpawner.spawn((ParticleBuilder)fizz, (World)world, (InterpFunction)new StaticInterp((Object)pos.func_72441_c(0.0, 0.5, 0.0)), (int)10, (int)0, (aFloat, particleBuilder) -> {
            fizz.setColor(ColorUtils.changeColorAlpha(new Color(38911), RandUtil.nextInt(100, 255)));
            fizz.setLifetime(RandUtil.nextInt(20, 30));
            fizz.setPositionOffset(new Vec3d(RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.1, 0.1)));
            fizz.setMotion(new Vec3d(RandUtil.nextDouble(-0.005, 0.005), RandUtil.nextDouble(0.04, 0.08), RandUtil.nextDouble(-0.005, 0.005)));
        });
    }

    public static void FIZZING_EXPLOSION(World world, Vec3d pos) {
        ParticleBuilder glitter = new ParticleBuilder(50);
        glitter.setScale(0.3f);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, 0.3f));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)300, (int)0, (aFloat, particleBuilder) -> {
            glitter.setLifetime(RandUtil.nextInt(20, 30));
            glitter.setColor(ColorUtils.changeColorAlpha(new Color(38911), RandUtil.nextInt(100, 255)));
            glitter.setMotion(new Vec3d(RandUtil.nextDouble(-0.5, 0.5), RandUtil.nextDouble(-0.5, 0.5), RandUtil.nextDouble(-0.5, 0.5)));
        });
    }

    public static void AIR_THROTTLE(World world, Vec3d pos, Vec3d normal, Color color1, Color color2, double scatter) {
        ParticleBuilder glitter = new ParticleBuilder(RandUtil.nextInt(30, 50));
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.1f, 0.3f));
        glitter.enableMotionCalculation();
        glitter.setCollision(true);
        glitter.setAcceleration(new Vec3d(0.0, -0.01, 0.0));
        glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)RandUtil.nextInt(40, 50), (int)1, (i, build) -> {
            glitter.setMotion(new Vec3d(normal.field_72450_a + RandUtil.nextDouble(-0.01, 0.01), normal.field_72448_b + RandUtil.nextDouble(-0.01, 0.01), normal.field_72449_c + RandUtil.nextDouble(-0.01, 0.01)));
            if (RandUtil.nextBoolean()) {
                glitter.setColor(color1);
            } else {
                glitter.setColor(color2);
            }
            if (scatter > 0.0) {
                double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
                double r = scatter * (double)RandUtil.nextFloat();
                double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
                double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
                glitter.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(-scatter, scatter), z));
            }
        });
    }

    public static void SPIRIT_WIGHT_FLAME_FAR(World world, Vec3d pos) {
        ParticleBuilder glitter = new ParticleBuilder(30);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 0.3f));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)5, (int)0, (i, build) -> {
            double radius = 0.15;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            glitter.setColorFunction((InterpFunction)new InterpColorHSV(Color.RED, 50, 20.0f));
            glitter.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(0.0, 0.5), z));
            glitter.addMotion(new Vec3d(0.0, RandUtil.nextDouble(0.0, 0.02), 0.0));
        });
    }

    public static void SPIRIT_WIGHT_FLAME_CLOSE(World world, Vec3d pos) {
        ParticleBuilder glitter = new ParticleBuilder(30);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 0.3f));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)20, (int)0, (i, build) -> {
            double radius = 0.2;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            glitter.setColor(Color.RED);
            glitter.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(0.0, 0.5), z));
            glitter.addMotion(new Vec3d(RandUtil.nextDouble(-0.02, 0.02), RandUtil.nextDouble(0.0, 0.03), RandUtil.nextDouble(-0.02, 0.02)));
        });
    }

    public static void SPIRIT_WIGHT_FLAME_NORMAL(World world, Vec3d pos) {
        ParticleBuilder glitter = new ParticleBuilder(30);
        glitter.setRender(new ResourceLocation("wizardry", "particles/smoke"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(1.0f, 1.0f));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)10, (int)0, (i, build) -> {
            double radius = 0.1;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            glitter.setLifetime(RandUtil.nextInt(10, 40));
            glitter.setColor(new Color(0x4DFFFFFF, true));
            glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, (float)RandUtil.nextDouble(4.0, 5.0)));
            glitter.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(0.0, 0.2), z));
            if (RandUtil.nextInt(15) == 0) {
                glitter.addMotion(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(0.0, 0.03), RandUtil.nextDouble(-0.01, 0.01)));
            }
        });
    }

    public static void CRAFTING_ALTAR_IDLE(World world, Vec3d pos) {
        ParticleBuilder glitter = new ParticleBuilder(30);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(1.0f, 1.0f));
        glitter.addMotion(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(0.0, 0.05), RandUtil.nextDouble(-0.01, 0.01)));
        glitter.setColor(new Color(8959));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)1, (int)0, (i, build) -> {
            double radius = 0.1;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            glitter.setScale((float)RandUtil.nextDouble(1.0, 2.0));
            glitter.setLifetime(RandUtil.nextInt(5, 30));
            glitter.setScaleFunction((InterpFunction)new InterpScale((float)RandUtil.nextDouble(1.0, 1.5), 0.0f));
            glitter.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(0.0, 0.3), z));
        });
    }

    public static void SPIRIT_WIGHT_HURT(World world, Vec3d pos) {
        ParticleBuilder glitter = new ParticleBuilder(RandUtil.nextInt(100, 150));
        glitter.setColorFunction((InterpFunction)new InterpColorHSV(Color.BLUE, 50, 20.0f));
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.1f, 0.1f));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)RandUtil.nextInt(40, 100), (int)0, (i, build) -> {
            double radius = 0.2;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            glitter.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(0.0, 0.4), z));
            glitter.setMotion(new Vec3d(0.0, RandUtil.nextDouble(0.0, 0.02), 0.0));
        });
    }

    public static void FAIRY_TRAIL(World world, Vec3d pos, Color color, boolean sad, int age) {
        if (age / 4 >= age / 2 || age == 0) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(RandUtil.nextInt(age / 8, age / 4));
        glitter.setColor(color);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.2f, 1.0f));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)RandUtil.nextInt(1, 3), (int)0, (i, build) -> {
            glitter.setMotion(new Vec3d(RandUtil.nextDouble(-0.02, 0.02), RandUtil.nextDouble(-0.02, 0.02), RandUtil.nextDouble(-0.02, 0.02)));
            if (sad) {
                glitter.setCollision(true);
                glitter.enableMotionCalculation();
            }
        });
    }

    public static void FAIRY_HEAD(World world, Vec3d pos, Color color) {
        ParticleBuilder glitter = new ParticleBuilder(3);
        glitter.setColor(color);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.2f, 1.0f));
        glitter.setScale(3.5f);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)2);
        ParticleBuilder glitter2 = new ParticleBuilder(5);
        glitter2.setColor(color);
        glitter2.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter2.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.2f, 1.0f));
        glitter2.setScale(1.0f);
        ParticleSpawner.spawn((ParticleBuilder)glitter2, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)3);
    }

    public static void STRUCTURE_FLAIR(World world, Vec3d pos, Color color) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRenderNormalLayer(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, 0.9f));
        glitter.setColor(color);
        glitter.setLifetime(40);
        glitter.setScale(2.0f);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)1, (int)0, (i, build) -> build.setScale(5.0f));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)10, (int)0, (i, build) -> {
            build.setScale(2.0f);
            int x = RandUtil.nextInt(4);
            switch (x) {
                case 0: {
                    glitter.setMotion(new Vec3d(0.0, 0.0, 0.2));
                    break;
                }
                case 1: {
                    glitter.setMotion(new Vec3d(0.0, 0.0, -0.2));
                    break;
                }
                case 2: {
                    glitter.setMotion(new Vec3d(0.2, 0.0, 0.0));
                    break;
                }
                case 3: {
                    glitter.setMotion(new Vec3d(-0.2, 0.0, 0.0));
                }
            }
        });
    }

    public static void STRUCTURE_BEACON(World world, Vec3d pos, Color color) {
        ParticleBuilder beacon = new ParticleBuilder(10);
        beacon.setRenderNormalLayer(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        beacon.setScale(2.0f);
        beacon.setLifetime(40);
        beacon.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, 0.9f));
        beacon.setColor(color);
        ParticleSpawner.spawn((ParticleBuilder)beacon, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)10, (int)0, (aFloat, particleBuilder) -> {
            if (RandUtil.nextBoolean()) {
                beacon.setMotion(new Vec3d(0.0, 0.2, 0.0));
            } else {
                beacon.setMotion(new Vec3d(0.0, -0.2, 0.0));
            }
        });
    }

    public static void CRAFTING_ALTAR_HELIX(World world, Vec3d pos) {
        ParticleBuilder beam = new ParticleBuilder(200);
        beam.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        beam.setAlphaFunction((InterpFunction)new InterpFloatInOut(1.0f, 1.0f));
        pos = pos.func_72441_c(0.0, 0.75, 0.0);
        ParticleSpawner.spawn((ParticleBuilder)beam, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)1, (int)0, (aFloat, particleBuilder) -> {
            beam.setScale(RandUtil.nextFloat());
            beam.setColor(ColorUtils.changeColorAlpha(new Color(38911), RandUtil.nextInt(100, 255)));
            beam.setMotion(new Vec3d(0.0, RandUtil.nextDouble(0.1, 0.8), 0.0));
            beam.setLifetime(RandUtil.nextInt(0, 40));
        });
        ParticleBuilder helix = new ParticleBuilder(200);
        helix.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        helix.setAlphaFunction((InterpFunction)new InterpFloatInOut(1.0f, 1.0f));
        ParticleSpawner.spawn((ParticleBuilder)helix, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)1, (int)0, (aFloat, particleBuilder) -> {
            helix.setScale(RandUtil.nextFloat());
            helix.setColor(ColorUtils.changeColorAlpha(new Color(38911), RandUtil.nextInt(200, 255)));
            helix.setPositionFunction((InterpFunction)new InterpHelix(Vec3d.field_186680_a, new Vec3d(0.0, RandUtil.nextDouble(0.0, 255.0), 0.0), 0.0f, (float)RandUtil.nextInt(1, 5), (float)RandUtil.nextInt(1, 5), 0.0f));
            helix.setLifetime(RandUtil.nextInt(0, 100));
        });
    }

    public static void CLUSTER_DRAPE(World world, Vec3d pos) {
        ParticleBuilder glitter = new ParticleBuilder(200);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 0.3f));
        glitter.enableMotionCalculation();
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)1, (int)0, (aFloat, particleBuilder) -> {
            glitter.setColor(ColorUtils.changeColorAlpha(new Color(38911), RandUtil.nextInt(100, 255)));
            glitter.setScale(RandUtil.nextFloat());
            glitter.addMotion(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.01, 0.01)));
            glitter.setLifetime(RandUtil.nextInt(30, 60));
        });
    }

    public static void MAGIC_DOT(World world, Vec3d pos, float scale) {
        ParticleBuilder glitter = new ParticleBuilder(3);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(1.0f, 1.0f));
        glitter.enableMotionCalculation();
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)1, (int)0, (aFloat, particleBuilder) -> {
            glitter.setColor(new Color(RandUtil.nextInt(0, 100), RandUtil.nextInt(0, 100), RandUtil.nextInt(50, 255)));
            if (scale == -1.0f) {
                glitter.setScale(RandUtil.nextFloat());
            } else {
                glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(1.0f, 1.0f));
                glitter.setMotion(new Vec3d(0.0, RandUtil.nextDouble(0.3), 0.0));
                glitter.setLifetime(RandUtil.nextInt(30));
                glitter.setScale(scale);
            }
        });
    }

    public static void CRAFTING_ALTAR_CLUSTER_SUCTION(World world, Vec3d pos, InterpFunction<Vec3d> bezier3D) {
        ParticleBuilder helix = new ParticleBuilder(200);
        helix.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        helix.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.5f, 0.3f));
        ParticleSpawner.spawn((ParticleBuilder)helix, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)1, (int)0, (aFloat, particleBuilder) -> {
            helix.setColorFunction((InterpFunction)new InterpColorHSV(ColorUtils.changeColorAlpha(Color.BLUE, RandUtil.nextInt(100, 150)), ColorUtils.changeColorAlpha(Color.CYAN, RandUtil.nextInt(100, 150))));
            helix.setScale(RandUtil.nextFloat());
            helix.setPositionFunction(bezier3D);
            helix.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
            helix.setLifetime(RandUtil.nextInt(10, 30));
        });
    }

    public static void CRAFTING_ALTAR_PEARL_EXPLODE(World world, Vec3d pos) {
        ParticleBuilder builder = new ParticleBuilder(1);
        builder.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, 0.1f));
        builder.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        builder.enableMotionCalculation();
        ParticleSpawner.spawn((ParticleBuilder)builder, (World)world, (InterpFunction)new InterpLine(pos, pos.func_72441_c(0.0, 100.0, 0.0)), (int)RandUtil.nextInt(400, 500), (int)0, (aFloat, particleBuilder) -> {
            builder.setColor(ColorUtils.changeColorAlpha(new Color(38911), RandUtil.nextInt(200, 255)));
            double radius = 1.0;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            builder.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(-0.1, 0.1), z));
            builder.setScale(RandUtil.nextFloat());
            builder.setMotion(new Vec3d(x, 0.0, z));
            builder.setLifetime(RandUtil.nextInt(400, 600));
        });
        ParticleBuilder shockwave = new ParticleBuilder(1);
        shockwave.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, 0.1f));
        shockwave.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        shockwave.setCollision(true);
        shockwave.enableMotionCalculation();
        ParticleSpawner.spawn((ParticleBuilder)shockwave, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)RandUtil.nextInt(200, 300), (int)0, (aFloat, particleBuilder) -> {
            shockwave.setColor(ColorUtils.changeColorAlpha(new Color(38911), RandUtil.nextInt(200, 255)));
            double radius = 2.0;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            shockwave.setScale(RandUtil.nextFloat());
            shockwave.setMotion(new Vec3d(x, RandUtil.nextDouble(0.5), z));
            shockwave.setLifetime(RandUtil.nextInt(50, 100));
        });
    }

    public static void COLORFUL_BATTERY_BEZIER(World world, BlockPos pedestal, BlockPos center) {
        ParticleBuilder glitter = new ParticleBuilder(200);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.5f, 0.3f));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)new Vec3d((Vec3i)pedestal).func_72441_c(0.5, 1.0, 0.5)), (int)1, (int)0, (aFloat, particleBuilder) -> {
            glitter.setColorFunction((InterpFunction)new InterpColorHSV(ColorUtils.changeColorAlpha(Color.BLUE, RandUtil.nextInt(100, 150)), ColorUtils.changeColorAlpha(Color.CYAN, RandUtil.nextInt(100, 150))));
            glitter.setScale(RandUtil.nextFloat());
            glitter.setPositionFunction((InterpFunction)new InterpBezier3D(Vec3d.field_186680_a, new Vec3d((Vec3i)center.func_177973_b((Vec3i)pedestal)), new Vec3d(0.0, 3.0, 0.0), new Vec3d(0.0, 5.0, 0.0)));
            glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.4f));
            glitter.setLifetime(RandUtil.nextInt(10, 30));
        });
    }

    public static void SHAPE_BEAM(World world, Vec3d target, Vec3d origin, Color color) {
        ParticleBuilder beam = new ParticleBuilder(10);
        beam.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        beam.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 1.0f));
        beam.setColor(ColorUtils.shiftColorHueRandomly(color, 10.0));
        beam.setCollision(true);
        Vec3d look = target.func_178788_d(origin).func_72432_b();
        double dist = target.func_72438_d(origin);
        ParticleSpawner.spawn((ParticleBuilder)beam, (World)world, (InterpFunction)new StaticInterp((Object)origin), (int)1, (int)0, (aFloat1, particleBuilder1) -> {
            particleBuilder1.setPositionOffset(look.func_186678_a(RandUtil.nextDouble(0.0, dist)));
            particleBuilder1.setScale(RandUtil.nextFloat(0.1f, 0.5f));
            int life = RandUtil.nextInt(50, 60);
            particleBuilder1.setLifetime(life);
            particleBuilder1.enableMotionCalculation();
            particleBuilder1.setCollision(true);
            particleBuilder1.setCanBounce(true);
            particleBuilder1.setAcceleration(new Vec3d(0.0, -0.03, 0.0));
            double radius = 2.0;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            Vec3d dest = new Vec3d(x, RandUtil.nextDouble(-1.0, 2.0), z);
            particleBuilder1.setPositionFunction((InterpFunction)new InterpBezier3D(Vec3d.field_186680_a, dest, dest.func_186678_a(2.0), new Vec3d(dest.field_72450_a, RandUtil.nextDouble(-2.0, 2.0), dest.field_72449_c)));
            particleBuilder1.setTick(particle -> {
                if ((double)particle.getAge() >= (double)particle.getLifetime() / RandUtil.nextDouble(2.0, 5.0)) {
                    if (particle.getAcceleration().field_72448_b == 0.0) {
                        particle.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.05, -0.01), 0.0));
                    }
                } else if (particle.getAcceleration().field_72450_a != 0.0 || particle.getAcceleration().field_72448_b != 0.0 || particle.getAcceleration().field_72449_c != 0.0) {
                    particle.setAcceleration(Vec3d.field_186680_a);
                }
            });
        });
        ParticleSpawner.spawn((ParticleBuilder)beam, (World)world, (InterpFunction)new StaticInterp((Object)origin), (int)10, (int)0, (aFloat, particleBuilder) -> {
            particleBuilder.setTick(particle -> particle.setAcceleration(Vec3d.field_186680_a));
            particleBuilder.setScaleFunction((InterpFunction)new InterpFloatInOut(0.0f, 1.0f));
            particleBuilder.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 0.2f));
            particleBuilder.setScale(RandUtil.nextFloat(0.5f, 1.5f));
            particleBuilder.setLifetime(RandUtil.nextInt(10, 20));
            particleBuilder.disableMotionCalculation();
            particleBuilder.setMotion(Vec3d.field_186680_a);
            particleBuilder.setCanBounce(false);
            particleBuilder.setPositionOffset(Vec3d.field_186680_a);
            particleBuilder.setPositionFunction((InterpFunction)new InterpLine(Vec3d.field_186680_a, target.func_178788_d(origin)));
        });
    }

    public static void EFFECT_NULL_GRAV(World world, @Nonnull Vec3d pos, @Nullable EntityLivingBase caster, Color color) {
        ParticleBuilder glitter = new ParticleBuilder(RandUtil.nextInt(20, 30));
        glitter.setColor(color == null ? Color.WHITE : color);
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 0.3f));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)RandUtil.nextInt(5, 10), (int)RandUtil.nextInt(0, 30), (aFloat, particleBuilder) -> {
            glitter.setScale((float)RandUtil.nextDouble(0.3, 0.8));
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            if (RandUtil.nextBoolean()) {
                glitter.setPositionFunction((InterpFunction)new InterpHelix(new Vec3d(0.0, caster == null ? 0.0 : (double)(caster.field_70131_O / 2.0f), 0.0), new Vec3d(0.0, caster == null ? -1.0 : (double)(-caster.field_70131_O), 0.0), 1.0f, 0.0f, 1.0f, RandUtil.nextFloat()));
            } else {
                glitter.setPositionFunction((InterpFunction)new InterpHelix(new Vec3d(0.0, caster == null ? 0.0 : (double)(caster.field_70131_O / 2.0f), 0.0), new Vec3d(0.0, caster == null ? 1.5 : (double)caster.field_70131_O + 0.5, 0.0), 1.0f, 0.0f, 1.0f, RandUtil.nextFloat()));
            }
        });
    }

    public static void EFFECT_REGENERATE(World world, @Nonnull Vec3d pos, Color color) {
        ParticleBuilder glitter = new ParticleBuilder(50);
        glitter.setColor(ColorUtils.changeColorAlpha(color, RandUtil.nextInt(200, 255)));
        glitter.setScale(1.0f);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.disableRandom();
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)20, (int)0, (aFloat, particleBuilder) -> {
            glitter.setLifetime(RandUtil.nextInt(10, 40));
            glitter.setScale(RandUtil.nextFloat());
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, RandUtil.nextFloat()));
            double radius = 1.0;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            Vec3d dest = new Vec3d(x, RandUtil.nextDouble(-1.0, 1.0), z);
            glitter.setPositionFunction((InterpFunction)new InterpBezier3D(Vec3d.field_186680_a, dest, dest.func_186678_a(2.0), new Vec3d(dest.field_72450_a, RandUtil.nextDouble(-2.0, 2.0), dest.field_72449_c)));
        });
    }

    public static void EFFECT_BURN(World world, @Nonnull Vec3d pos, Color color) {
        ParticleBuilder glitter = new ParticleBuilder(3);
        glitter.setScale(1.0f);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)4, (int)0, (aFloat, particleBuilder) -> {
            glitter.setColor(ColorUtils.changeColorAlpha(color, RandUtil.nextInt(200, 255)));
            glitter.setLifetime(RandUtil.nextInt(10, 30));
            glitter.setScaleFunction((InterpFunction)new InterpScale((float)RandUtil.nextDouble(3.0, 10.0), 0.0f));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, RandUtil.nextFloat()));
            glitter.addMotion(new Vec3d(RandUtil.nextDouble(-0.05, 0.05), RandUtil.nextDouble(0.05), RandUtil.nextDouble(-0.05, 0.05)));
            glitter.setPositionOffset(new Vec3d(RandUtil.nextDouble(-0.3, 0.3), RandUtil.nextDouble(-0.3, 0.3), RandUtil.nextDouble(-0.3, 0.3)));
        });
        ParticleBuilder dust = new ParticleBuilder(3);
        dust.setScale(1.0f);
        dust.setRenderNormalLayer(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        ParticleSpawner.spawn((ParticleBuilder)dust, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)3, (int)0, (aFloat, particleBuilder) -> {
            dust.setLifetime(RandUtil.nextInt(10, 30));
            dust.setScaleFunction((InterpFunction)new InterpScale(3.0f, 0.5f));
            dust.setAlphaFunction((InterpFunction)new InterpFloatInOut(1.0f, 1.0f));
            dust.setColor(Color.DARK_GRAY);
            dust.addMotion(new Vec3d(RandUtil.nextDouble(-0.05, 0.05), RandUtil.nextDouble(0.05), RandUtil.nextDouble(-0.05, 0.05)));
        });
    }

    public static void BLOCK_HIGHLIGHT(World world, BlockPos pos, Color color) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRenderNormalLayer(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 0.3f));
        glitter.setColor(color);
        glitter.disableRandom();
        glitter.disableMotionCalculation();
        glitter.setScale(2.0f);
        glitter.setLifetime(200);
        double indent = 0.75;
        Vec3d bottom = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5 - indent, (double)pos.func_177952_p() + 0.5);
        Vec3d top = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5 + indent, (double)pos.func_177952_p() + 0.5);
        Vec3d front = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5 + indent);
        Vec3d back = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5 - indent);
        Vec3d left = new Vec3d((double)pos.func_177958_n() + 0.5 + indent, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        Vec3d right = new Vec3d((double)pos.func_177958_n() + 0.5 - indent, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bottom), (int)1);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)top), (int)1);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)left), (int)1);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)right), (int)1);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)front), (int)1);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)back), (int)1);
    }

    public static void STRUCTURE_BOUNDS(World world, Vec3d pos, Color color) {
        ParticleBuilder glitter = new ParticleBuilder(RandUtil.nextInt(10));
        glitter.setScale(RandUtil.nextFloat());
        glitter.setRenderNormalLayer(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.9f, 0.9f));
        glitter.setScale(2.0f);
        glitter.setLifetime(40);
        glitter.setColor(color);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)1);
    }

    public static class ParticleExplosion
    extends ParticleSystem {
        public static ParticleExplosion INSTANCE = new ParticleExplosion();

        private ParticleExplosion() {
        }

        public void configure() {
            StoredBinding size = this.bind(1);
            StoredBinding position = this.bind(3);
            StoredBinding previousPosition = this.bind(3);
            StoredBinding velocity = this.bind(3);
            StoredBinding colorFrom = this.bind(4);
            StoredBinding colorTo = this.bind(4);
            this.getUpdateModules().add(new BasicPhysicsUpdateModule((ReadWriteParticleBinding)position, (WriteParticleBinding)previousPosition, (ReadParticleBinding)velocity, true, 0.1, 0.3f, 0.2f, 0.01f));
            this.getRenderModules().add(new SpriteRenderModule(new ResourceLocation("wizardry", "textures/particles/sparkle_blurred.png"), (ReadParticleBinding)previousPosition, (ReadParticleBinding)position, (ReadParticleBinding)new EaseBinding((ReadParticleBinding)this.getLifetime(), (ReadParticleBinding)this.getAge(), null, null, Easing.linear, 4, (ReadParticleBinding)colorFrom, (ReadParticleBinding)colorTo), (ReadParticleBinding)size));
        }

        public void spawn(int lifeTime, int lifeTimeRange, int amount, Vec3d pos, Color colorFrom, Color colorTo, double strengthUpwards, double strengthSideways) {
            this.reload();
            for (int i = 0; i < amount; ++i) {
                double radius = RandUtil.nextDouble(1.0, 2.0);
                double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
                double r = radius * (double)RandUtil.nextFloat();
                double x = r * (double)MathHelper.func_76134_b((float)((float)theta)) * RandUtil.nextDouble(-strengthSideways, strengthSideways);
                double z = r * (double)MathHelper.func_76126_a((float)((float)theta)) * RandUtil.nextDouble(-strengthSideways, strengthSideways);
                this.addParticle((double)lifeTime + RandUtil.nextDouble(-lifeTimeRange, lifeTimeRange), new double[]{RandUtil.nextDouble(0.2, 1.0), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, x, RandUtil.nextDouble(-strengthUpwards, strengthUpwards), z, (double)colorFrom.getRed() / 255.0, (double)colorFrom.getGreen() / 255.0, (double)colorFrom.getBlue() / 255.0, (double)colorFrom.getAlpha() / 255.0, (double)colorTo.getRed() / 255.0, (double)colorTo.getGreen() / 255.0, (double)colorTo.getBlue() / 255.0, (double)colorTo.getAlpha() / 255.0});
            }
        }
    }
}

