/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.core.renderer;

import com.teamwizardry.wizardry.common.entity.EntityUnicorn;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="wizardry", value={Side.CLIENT})
public class UnicornTrailRenderer {
    public static HashMap<EntityUnicorn, List<Point>> positions = new HashMap();

    private static BufferBuilder pos(BufferBuilder vb, Vec3d pos) {
        return vb.func_181662_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        List unicorns = world.func_175644_a(EntityUnicorn.class, input -> true);
        for (EntityUnicorn unicorn : unicorns) {
            if (unicorn == null) continue;
            if (unicorn.field_70128_L) {
                positions.remove((Object)unicorn);
                break;
            }
            positions.putIfAbsent(unicorn, new ArrayList());
            List<Point> poses = positions.get((Object)unicorn);
            if (!(poses.size() < 1000 && world.func_82737_E() % 20L != 0L || poses.isEmpty())) {
                poses.remove(0);
            }
            double mot = 0.05;
            if (poses.size() >= 1000) continue;
            if (unicorn.field_70159_w >= mot || unicorn.field_70159_w <= -mot || unicorn.field_70181_x >= mot || unicorn.field_70181_x <= -mot || unicorn.field_70179_y >= mot || unicorn.field_70179_y <= -mot) {
                Vec3d backCenter = unicorn.func_174791_d();
                Vec3d look = new Vec3d(unicorn.field_70159_w, unicorn.field_70181_x, unicorn.field_70179_y).func_72432_b();
                backCenter = backCenter.func_178787_e(look.func_186678_a(-1.0));
                Vec3d cross = look.func_72431_c(new Vec3d(0.0, 1.0, 0.0)).func_72432_b().func_186678_a((double)0.35f);
                poses.add(new Point(backCenter, cross, world.func_82737_E()));
                continue;
            }
            if (poses.isEmpty()) continue;
            poses.remove(0);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void render(RenderWorldLastEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || world == null) {
            return;
        }
        GlStateManager.func_179094_E();
        double interpPosX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double interpPosY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double interpPosZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY + 0.1), (double)(-interpPosZ));
        GlStateManager.func_179129_p();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179112_b((int)770, (int)1);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        HashSet<EntityUnicorn> corns = new HashSet<EntityUnicorn>(positions.keySet());
        for (EntityUnicorn corn : corns) {
            if (corn.field_70170_p.field_73011_w.getDimension() != world.field_73011_w.getDimension()) continue;
            ArrayList points = new ArrayList(positions.getOrDefault((Object)corn, new ArrayList()));
            boolean q = false;
            vb.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (Point pos : points) {
                if (pos == null) continue;
                float sub = world.func_82737_E() - pos.time;
                Color color = Color.getHSBColor(sub % 360.0f / 360.0f, 1.0f, 1.0f);
                int alpha = sub < 500.0f ? (int)(MathHelper.func_151237_a((double)(Math.log(sub + 1.0f) / 2.0), (double)0.0, (double)1.0) * 80.0) : (int)(MathHelper.func_151237_a((double)(1.0 - Math.log(sub) / 2.0), (double)0.0, (double)1.0) * 80.0);
                UnicornTrailRenderer.pos(vb, pos.origin.func_178788_d(pos.normal.func_186678_a(1.5))).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), alpha).func_181675_d();
                UnicornTrailRenderer.pos(vb, pos.origin.func_178787_e(pos.normal.func_186678_a(1.5))).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), alpha).func_181675_d();
                q = !q;
            }
            tessellator.func_78381_a();
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179121_F();
    }

    public static class Point {
        @Nonnull
        public final Vec3d origin;
        @Nonnull
        public final Vec3d normal;
        private final long time;

        public Point(@Nonnull Vec3d origin, @Nonnull Vec3d normal, long time) {
            this.origin = origin;
            this.normal = normal;
            this.time = time;
        }
    }
}

