/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.item.wheels;

import com.teamwizardry.wizardry.api.item.wheels.FindPearlWheelEvent;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public interface IPearlWheelHolder {
    @Nullable
    public ItemStackHandler getPearls(ItemStack var1);

    default public int getPearlCount(ItemStack holder) {
        ItemStackHandler handler = this.getPearls(holder);
        if (handler == null) {
            return 0;
        }
        int total = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack pearl = handler.getStackInSlot(i);
            if (pearl.func_190926_b()) continue;
            ++total;
        }
        return total;
    }

    default public ItemStack removePearl(ItemStack holder, int slot) {
        if (!this.shouldUse(holder)) {
            return ItemStack.field_190927_a;
        }
        ItemStackHandler handler = this.getPearls(holder);
        if (handler == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = handler.extractItem(slot, 1, false);
        NBTTagCompound tag = holder.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74782_a("inv", (NBTBase)handler.serializeNBT());
        holder.func_77982_d(tag);
        return stack;
    }

    default public boolean addPearl(ItemStack holder, ItemStack pearl) {
        if (!this.shouldUse(holder)) {
            return false;
        }
        ItemStackHandler handler = this.getPearls(holder);
        if (handler == null) {
            return false;
        }
        if (this.getPearlCount(holder) > 6) {
            return false;
        }
        ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)pearl, (boolean)false);
        NBTTagCompound tag = holder.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74782_a("inv", (NBTBase)handler.serializeNBT());
        holder.func_77982_d(tag);
        return true;
    }

    default public boolean shouldUse(ItemStack stack) {
        return true;
    }

    public static ItemStack getPearlHolder(EntityPlayer player) {
        FindPearlWheelEvent event = new FindPearlWheelEvent(player);
        event.addItems((Iterable<ItemStack>)player.field_71071_by.field_70462_a, 0);
        event.addItems((Iterable<ItemStack>)player.field_71071_by.field_70460_b, 1);
        event.addItems((Iterable<ItemStack>)player.field_71071_by.field_184439_c, 10000);
        MinecraftForge.EVENT_BUS.post((Event)event);
        Iterator<ItemStack> stacks = event.getCombinedIterator();
        while (stacks.hasNext()) {
            ItemStack next = stacks.next();
            if (!(next.func_77973_b() instanceof IPearlWheelHolder) || !((IPearlWheelHolder)next.func_77973_b()).shouldUse(next)) continue;
            return next;
        }
        return ItemStack.field_190927_a;
    }
}

