/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.capability.world;

import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.capability.world.WizardryWorld;
import com.teamwizardry.wizardry.api.capability.world.WizardryWorldCapability;
import com.teamwizardry.wizardry.api.spell.IDelayedModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.common.core.SpellTicker;
import com.teamwizardry.wizardry.common.core.nemez.NemezTracker;
import com.teamwizardry.wizardry.common.network.PacketSyncWizardryWorld;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class StandardWizardryWorld
implements WizardryWorld {
    private World world;
    private HashSet<SpellTicker.LingeringObject> lingeringStorageSet = new HashSet();
    private HashSet<SpellTicker.DelayedObject> delayedStorageSet = new HashSet();
    public HashMap<BlockPos, NemezTracker> nemezDrives = new HashMap();

    public static StandardWizardryWorld create(World world) {
        StandardWizardryWorld wizardryWorld = new StandardWizardryWorld();
        wizardryWorld.world = world;
        return wizardryWorld;
    }

    public static StandardWizardryWorld create() {
        return new StandardWizardryWorld();
    }

    @Override
    public void addLingerSpell(SpellRing spellRing, SpellData data, int expiry) {
        this.lingeringStorageSet.add(new SpellTicker.LingeringObject(spellRing, data, data.world.func_82737_E(), expiry));
        PacketHandler.NETWORK.sendToDimension((IMessage)new PacketSyncWizardryWorld(this.serializeNBT()), data.world.field_73011_w.getDimension());
    }

    @Override
    public void addDelayedSpell(ModuleInstance module, SpellRing spellRing, SpellData data, int expiry) {
        if (module.getModuleClass() instanceof IDelayedModule) {
            this.delayedStorageSet.add(new SpellTicker.DelayedObject(module, spellRing, data, data.world.func_82737_E(), expiry));
        }
        PacketHandler.NETWORK.sendToDimension((IMessage)new PacketSyncWizardryWorld(this.serializeNBT()), data.world.field_73011_w.getDimension());
    }

    @Override
    public NemezTracker addNemezDrive(BlockPos pos, NemezTracker nemezDrive) {
        this.nemezDrives.put(pos, nemezDrive);
        PacketHandler.NETWORK.sendToDimension((IMessage)new PacketSyncWizardryWorld(this.serializeNBT()), this.world.field_73011_w.getDimension());
        return nemezDrive;
    }

    @Override
    public void removeNemezDrive(BlockPos pos) {
        this.nemezDrives.remove(pos);
        PacketHandler.NETWORK.sendToDimension((IMessage)new PacketSyncWizardryWorld(this.serializeNBT()), this.world.field_73011_w.getDimension());
    }

    @Override
    public HashMap<BlockPos, NemezTracker> getNemezDrives() {
        return this.nemezDrives;
    }

    @Override
    public HashSet<SpellTicker.LingeringObject> getLingeringObjects() {
        return this.lingeringStorageSet;
    }

    @Override
    public HashSet<SpellTicker.DelayedObject> getDelayedObjects() {
        return this.delayedStorageSet;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList lingeringNBT = new NBTTagList();
        for (SpellTicker.LingeringObject lingeringObject : this.lingeringStorageSet) {
            if (lingeringObject == null) continue;
            lingeringNBT.func_74742_a((NBTBase)lingeringObject.serializeNBT());
        }
        NBTTagList delayedNBT = new NBTTagList();
        for (SpellTicker.DelayedObject object : this.delayedStorageSet) {
            if (object == null) continue;
            delayedNBT.func_74742_a((NBTBase)object.serializeNBT());
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (Map.Entry<BlockPos, NemezTracker> entry : this.nemezDrives.entrySet()) {
            if (entry == null) continue;
            NBTTagCompound compound1 = new NBTTagCompound();
            compound1.func_74772_a("pos", entry.getKey().func_177986_g());
            compound1.func_74782_a("drive", (NBTBase)entry.getValue().serializeNBT());
            nBTTagList.func_74742_a((NBTBase)compound1);
        }
        compound.func_74782_a("lingering", (NBTBase)lingeringNBT);
        compound.func_74782_a("delayed", (NBTBase)delayedNBT);
        compound.func_74782_a("drives", (NBTBase)nBTTagList);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("lingering")) {
            NBTTagList lingeringNBT = compound.func_150295_c("lingering", 10);
            for (NBTBase base : lingeringNBT) {
                if (!(base instanceof NBTTagCompound)) continue;
                this.lingeringStorageSet.add(SpellTicker.LingeringObject.deserialize(this.world, (NBTTagCompound)base));
            }
        }
        if (compound.func_74764_b("delayed")) {
            NBTTagList delayedNBT = compound.func_150295_c("delayed", 10);
            for (NBTBase base : delayedNBT) {
                if (!(base instanceof NBTTagCompound)) continue;
                this.delayedStorageSet.add(SpellTicker.DelayedObject.deserialize(this.world, (NBTTagCompound)base));
            }
        }
        if (compound.func_74764_b("drives")) {
            NBTTagList driveNBT = compound.func_150295_c("drives", 10);
            for (NBTBase base : driveNBT) {
                if (!(base instanceof NBTTagCompound) || !((NBTTagCompound)base).func_74764_b("pos") || !((NBTTagCompound)base).func_74764_b("drive")) continue;
                BlockPos pos = BlockPos.func_177969_a((long)((NBTTagCompound)base).func_74763_f("pos"));
                NemezTracker tracker = new NemezTracker();
                tracker.deserializeNBT(((NBTTagCompound)base).func_150295_c("drive", 10));
                this.nemezDrives.put(pos, tracker);
            }
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == WizardryWorldCapability.capability();
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == WizardryWorldCapability.capability() ? WizardryWorldCapability.capability().cast((Object)this) : null);
    }
}

