/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import sonar.core.translate.Localisation;
import sonar.flux.FluxNetworks;
import sonar.flux.FluxTranslate;
import sonar.flux.api.IFluxItemGui;
import sonar.flux.client.gui.tabs.GuiTabNetworkAdminSelection;
import sonar.flux.client.gui.tabs.GuiTabNetworkConnections;
import sonar.flux.client.gui.tabs.GuiTabNetworkCreate;
import sonar.flux.client.gui.tabs.GuiTabNetworkDebug;
import sonar.flux.client.gui.tabs.GuiTabNetworkEdit;
import sonar.flux.client.gui.tabs.GuiTabNetworkPlayers;
import sonar.flux.client.gui.tabs.GuiTabNetworkSelection;
import sonar.flux.client.gui.tabs.GuiTabNetworkStatistics;
import sonar.flux.client.gui.tabs.GuiTabWirelessCharging;
import sonar.flux.common.tileentity.TileFlux;
import sonar.flux.connection.FluxListener;

public enum EnumGuiTab {
    INDEX(FluxTranslate.GUI_TAB_INDEX, Lists.newArrayList((Object[])new FluxListener[]{FluxListener.SYNC_INDEX, FluxListener.SYNC_NETWORK_STATS}), 0, 0),
    NETWORK_SELECTION(FluxTranslate.GUI_TAB_NETWORK_SELECTION, Lists.newArrayList((Object[])new FluxListener[]{FluxListener.SYNC_NETWORK_LIST}), 128, 0),
    CONNECTIONS(FluxTranslate.GUI_TAB_CONNECTIONS, Lists.newArrayList((Object[])new FluxListener[]{FluxListener.SYNC_NETWORK_CONNECTIONS, FluxListener.SYNC_DISCONNECTED_CONNECTIONS}), 64, 0),
    NETWORK_STATISTICS(FluxTranslate.GUI_TAB_STATISTICS, Lists.newArrayList((Object[])new FluxListener[]{FluxListener.SYNC_NETWORK_STATS}), 192, 0),
    NETWORK_EDIT(FluxTranslate.GUI_TAB_NETWORK_EDIT, Lists.newArrayList((Object[])new FluxListener[]{FluxListener.SYNC_INDEX}), 256, 0),
    PLAYERS(FluxTranslate.GUI_TAB_PLAYERS, Lists.newArrayList((Object[])new FluxListener[]{FluxListener.SYNC_PLAYERS, FluxListener.SYNC_NETWORK_CONNECTIONS}), 386, 0),
    NETWORK_CREATE(FluxTranslate.GUI_TAB_NETWORK_CREATE, Lists.newArrayList((Object[])new FluxListener[]{FluxListener.SYNC_INDEX}), 320, 0),
    DEBUG(FluxTranslate.GUI_TAB_DEBUG, new ArrayList<FluxListener>(), 450, 0),
    WIRELESS_CHARGING(FluxTranslate.GUI_TAB_WIRELESS_CHARGING, new ArrayList<FluxListener>(), 0, 128),
    ADMIN_NETWORK_SELECTION(FluxTranslate.GUI_TAB_NETWORK_SELECTION, Lists.newArrayList((Object[])new FluxListener[]{FluxListener.ADMIN}), 128, 0);

    public Localisation name;
    public List<FluxListener> types;
    public int texX;
    public int texY;

    private EnumGuiTab(Localisation name, List<FluxListener> types, int texX, int texY) {
        this.name = name;
        this.types = types;
        this.texX = texX;
        this.texY = texY;
    }

    public String getClientName() {
        return this.name.t();
    }

    public List<FluxListener> getMonitoringTypes() {
        return this.types;
    }

    public Object getGuiScreen(List<EnumGuiTab> tabs) {
        switch (this) {
            case INDEX: {
                ItemStack stack = FluxNetworks.proxy.getFluxStack();
                TileFlux tile = FluxNetworks.proxy.getFluxTile();
                if (tile != null) {
                    return tile.getIndexScreen(tabs);
                }
                if (stack != null && stack.func_77973_b() instanceof IFluxItemGui) {
                    return ((IFluxItemGui)stack.func_77973_b()).getIndexScreen(stack, tabs);
                }
                return null;
            }
            case CONNECTIONS: {
                return new GuiTabNetworkConnections((List)tabs);
            }
            case NETWORK_CREATE: {
                return new GuiTabNetworkCreate(tabs);
            }
            case NETWORK_EDIT: {
                return new GuiTabNetworkEdit(tabs);
            }
            case NETWORK_SELECTION: {
                return new GuiTabNetworkSelection(tabs);
            }
            case NETWORK_STATISTICS: {
                return new GuiTabNetworkStatistics((List)tabs);
            }
            case PLAYERS: {
                return new GuiTabNetworkPlayers(tabs);
            }
            case DEBUG: {
                return new GuiTabNetworkDebug((List)tabs);
            }
            case WIRELESS_CHARGING: {
                return new GuiTabWirelessCharging(tabs);
            }
            case ADMIN_NETWORK_SELECTION: {
                return new GuiTabNetworkAdminSelection(tabs);
            }
        }
        return null;
    }
}

