/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.world.biomeprovider;

import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider.BiomeProviderDefinitionCustomMedium;
import com.bloodnbonesgaming.dimensionalcontrol.util.IOHelper;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.GenLayerAddMushroomIslandDC;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.GenLayerBaseSingle;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.GenLayerBiomeDC;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.GenLayerBiomeEdgeDC;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.GenLayerCombine;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.GenLayerCombineWhitelist;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.GenLayerDeepOceanDC;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.GenLayerHeatToBiomes;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.GenLayerHeatX;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.GenLayerHeatZ;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.GenLayerHillsDC;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.GenLayerRemoveTooMuchOceanDC;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.GenLayerReplaceAll;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.GenLayerRiverMixDC;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.GenLayerShoreDC;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.GenLayerTouching;
import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerAddIsland;
import net.minecraft.world.gen.layer.GenLayerAddMushroomIsland;
import net.minecraft.world.gen.layer.GenLayerAddSnow;
import net.minecraft.world.gen.layer.GenLayerBiome;
import net.minecraft.world.gen.layer.GenLayerBiomeEdge;
import net.minecraft.world.gen.layer.GenLayerDeepOcean;
import net.minecraft.world.gen.layer.GenLayerEdge;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerHills;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerRareBiome;
import net.minecraft.world.gen.layer.GenLayerRemoveTooMuchOcean;
import net.minecraft.world.gen.layer.GenLayerRiver;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.layer.GenLayerShore;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/biomeproviders/CustomMedium", classExplaination="The role of a BiomeProvider is to handle the generation of the dimensions biome map. This particular type allows for the creation of a layer based biome mapping system that allows for extreme configuration. The most important concept to keep in mind when building a BiomeProvider, is scale. Every zoom/magify increases the relative size of all GenLayers before it in the chain. This allows for things to be done on an extremely large scale at the top of the chain, and a very small scale at the bottom of the chain. This is extremely complicated, please see default configs for some examples.")
public class BiomeProviderCustomMedium
extends BiomeProvider {
    private Map<String, Class> classKeywords = new HashMap<String, Class>();
    private Map<String, Object> localVariables = new HashMap<String, Object>();
    private long seed = 0L;
    private final List<Biome> spawnBiomes = new ArrayList<Biome>();

    public BiomeProviderCustomMedium() {
        this.classKeywords.put("GenLayerIsland", GenLayerIsland.class);
        this.classKeywords.put("GenLayerFuzzyZoom", GenLayerFuzzyZoom.class);
        this.classKeywords.put("GenLayerAddIsland", GenLayerAddIsland.class);
        this.classKeywords.put("GenLayerZoom", GenLayerZoom.class);
        this.classKeywords.put("GenLayerRemoveTooMuchOcean", GenLayerRemoveTooMuchOcean.class);
        this.classKeywords.put("GenLayerAddSnow", GenLayerAddSnow.class);
        this.classKeywords.put("GenLayerEdge", GenLayerEdge.class);
        this.classKeywords.put("GenLayerAddMushroomIsland", GenLayerAddMushroomIsland.class);
        this.classKeywords.put("GenLayerDeepOcean", GenLayerDeepOcean.class);
        this.classKeywords.put("GenLayerRiverInit", GenLayerRiverInit.class);
        this.classKeywords.put("GenLayerBiome", GenLayerBiome.class);
        this.classKeywords.put("GenLayerBiomeEdge", GenLayerBiomeEdge.class);
        this.classKeywords.put("GenLayerHills", GenLayerHills.class);
        this.classKeywords.put("GenLayerRiver", GenLayerRiver.class);
        this.classKeywords.put("GenLayerSmooth", GenLayerSmooth.class);
        this.classKeywords.put("GenLayerRareBiome", GenLayerRareBiome.class);
        this.classKeywords.put("GenLayerShore", GenLayerShore.class);
        this.classKeywords.put("GenLayerRiverMix", GenLayerRiverMix.class);
        this.classKeywords.put("GenLayerVoronoiZoom", GenLayerVoronoiZoom.class);
        this.classKeywords.put("GenLayerAddMushroomIslandDC", GenLayerAddMushroomIslandDC.class);
        this.classKeywords.put("GenLayerBiomeDC", GenLayerBiomeDC.class);
        this.classKeywords.put("GenLayerBiomeEdgeDC", GenLayerBiomeEdgeDC.class);
        this.classKeywords.put("GenLayerDeepOceanDC", GenLayerDeepOceanDC.class);
        this.classKeywords.put("GenLayerHillsDC", GenLayerHillsDC.class);
        this.classKeywords.put("GenLayerRemoveTooMuchOceanDC", GenLayerRemoveTooMuchOceanDC.class);
        this.classKeywords.put("GenLayerRiverMixDC", GenLayerRiverMixDC.class);
        this.classKeywords.put("GenLayerShoreDC", GenLayerShoreDC.class);
        this.classKeywords.put("GenLayerTouching", GenLayerTouching.class);
        this.classKeywords.put("GenLayerReplaceAll", GenLayerReplaceAll.class);
        this.classKeywords.put("GenLayerBaseSingle", GenLayerBaseSingle.class);
        this.classKeywords.put("GenLayerHeatZ", GenLayerHeatZ.class);
        this.classKeywords.put("GenLayerHeatX", GenLayerHeatX.class);
        this.classKeywords.put("GenLayerHeatToBiomes", GenLayerHeatToBiomes.class);
        this.classKeywords.put("GenLayerCombineWhitelist", GenLayerCombineWhitelist.class);
        this.classKeywords.put("GenLayerCombine", GenLayerCombine.class);
        this.localVariables.put("Edge_Mode_Cool_Warm", GenLayerEdge.Mode.COOL_WARM);
        this.localVariables.put("Edge_Mode_Heat_Ice", GenLayerEdge.Mode.HEAT_ICE);
        this.localVariables.put("Edge_Mode_Special", GenLayerEdge.Mode.SPECIAL);
    }

    public void init(World world, BiomeProviderDefinitionCustomMedium definition) {
        this.localVariables.put("worldType", world.func_175624_G());
        this.localVariables.put("generatorString", world.func_72912_H().func_82571_y());
        this.seed = world.func_72905_C();
        IOHelper.loadBiomeProvider(definition.getScriptName(), (Object)this, this.classKeywords, this.localVariables);
    }

    @ScriptMethodDocumentation(args="Genlayer, Genlayer", usage="genlayer, zoomed genlayer", notes="Sets the Genlayer chain for this BiomeProvider. The second layer should be the same as the first layer, but with an added GenLayerVoronoiZoom on the end. The first one is used for the lerped terrain generation, the second is used for the detailed biome map.")
    public void setGenLayers(GenLayer layer1, GenLayer layer2) {
        DimensionalControl.instance.getLog().debug((Object)"Setting GenLayers");
        layer1.func_75905_a(this.seed);
        layer2.func_75905_a(this.seed);
        this.field_76944_d = layer1;
        this.field_76945_e = layer2;
    }

    @ScriptMethodDocumentation(args="long, Genlayer, int", usage="seed offset, genlayer to zoom, zoom count", notes="Adds zoom count GenLayerZoom layers to the provided GenLayer. This is just a helper method to quickly add multiple GenLayerZoom layers at once.")
    public GenLayer magnify(long seedOffset, GenLayer parent, int count) {
        return GenLayerZoom.func_75915_a((long)seedOffset, (GenLayer)parent, (int)count);
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome ID", notes="Adds a biome to the list for players to spawn in.")
    public void addSpawnBiome(int biomeID) {
        Biome biome = Biome.func_185357_a((int)biomeID);
        if (biome == null) {
            DimensionalControl.instance.getLog().info((Object)(biomeID + " is not a biome!"));
        } else {
            this.spawnBiomes.add(biome);
        }
    }

    public List<Biome> func_76932_a() {
        return this.spawnBiomes.isEmpty() ? super.func_76932_a() : this.spawnBiomes;
    }
}

