/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch;

import com.therandomlabs.randompatches.config.RPConfig;
import com.therandomlabs.randompatches.core.Patch;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class ItemBucketPatch
extends Patch {
    public static final String IS_SOLID = ItemBucketPatch.getName("isSolid", "func_76220_a");

    @Override
    public boolean apply(ClassNode node) {
        MethodNode method = ItemBucketPatch.findMethod(node, "tryPlaceContainedLiquid", "func_180616_a");
        MethodInsnNode isSolid = null;
        for (int i = 0; i < method.instructions.size(); ++i) {
            AbstractInsnNode instruction = method.instructions.get(i);
            if (!(instruction instanceof MethodInsnNode)) continue;
            isSolid = (MethodInsnNode)instruction;
            if (IS_SOLID.equals(isSolid.name)) break;
            isSolid = null;
        }
        ((VarInsnNode)isSolid.getPrevious()).var = 4;
        isSolid.setOpcode(184);
        isSolid.owner = ItemBucketPatch.getName(ItemBucketPatch.class);
        isSolid.name = "isSolid";
        isSolid.desc = "(Lnet/minecraft/block/state/IBlockState;)Z";
        return true;
    }

    public static boolean isSolid(IBlockState state) {
        Material material = state.func_185904_a();
        if (material.func_76220_a()) {
            return true;
        }
        if (!RPConfig.Misc.portalBucketReplacementFixForNetherPortals && state.func_177230_c() == Blocks.field_150427_aO) {
            return false;
        }
        return material == Material.field_151567_E;
    }
}

