/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.RecipeLoader;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirements.RequirementEnergy;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class MachineRecipe
implements Comparable<MachineRecipe> {
    private static int counter = 0;
    private static boolean frozen = false;
    private static final int PRIORITY_WEIGHT_ENERGY = 50000000;
    private static final int PRIORITY_WEIGHT_FLUID = 100;
    private static final int PRIORITY_WEIGHT_ITEM = 50000;
    private final int sortId;
    private final String recipeFilePath;
    private final ResourceLocation owningMachine;
    private final ResourceLocation registryName;
    private final int tickTime;
    private final List<ComponentRequirement> recipeRequirements = Lists.newArrayList();
    private final int configuredPriority;

    public MachineRecipe(String path, ResourceLocation registryName, ResourceLocation owningMachine, int tickTime, int configuredPriority) {
        this.sortId = counter++;
        this.recipeFilePath = path;
        this.registryName = registryName;
        this.owningMachine = owningMachine;
        this.tickTime = tickTime;
        this.configuredPriority = configuredPriority;
    }

    public String getRecipeFilePath() {
        return this.recipeFilePath;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public ResourceLocation getOwningMachineIdentifier() {
        return this.owningMachine;
    }

    public List<ComponentRequirement> getCraftingRequirements() {
        return Collections.unmodifiableList(this.recipeRequirements);
    }

    public void addRequirement(ComponentRequirement requirement) {
        if (frozen) {
            throw new IllegalStateException("Tried to add Requirement after recipes have been registered!");
        }
        if (requirement instanceof RequirementEnergy) {
            for (ComponentRequirement req : this.recipeRequirements) {
                if (!(req instanceof RequirementEnergy) || req.getActionType() != requirement.getActionType()) continue;
                throw new IllegalStateException("Tried to add multiple energy requirements for the same ioType! Please only add one for each ioType!");
            }
        }
        this.recipeRequirements.add(requirement);
    }

    public int getRecipeTotalTickTime() {
        return this.tickTime;
    }

    public int getConfiguredPriority() {
        return this.configuredPriority;
    }

    @Nullable
    public DynamicMachine getOwningMachine() {
        return MachineRegistry.getRegistry().getMachine(this.getOwningMachineIdentifier());
    }

    static boolean isFrozen() {
        return frozen;
    }

    static void freezeChanges() {
        frozen = true;
    }

    static void unfreeze() {
        frozen = false;
    }

    @Override
    public int compareTo(MachineRecipe o) {
        return Integer.compare(this.buildWeight(), o.buildWeight());
    }

    private int buildWeight() {
        int weightOut = this.sortId;
        for (ComponentRequirement req : this.recipeRequirements) {
            if (req.getActionType() == MachineComponent.IOType.OUTPUT) continue;
            switch (req.getRequiredComponentType().getRegistryName().toLowerCase()) {
                case "item": {
                    weightOut -= 50000;
                    break;
                }
                case "fluid": {
                    weightOut -= 100;
                    break;
                }
                case "energy": {
                    weightOut -= 50000000;
                }
            }
        }
        return weightOut;
    }

    public static class Deserializer
    implements JsonDeserializer<MachineRecipeContainer> {
        public MachineRecipeContainer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ResourceLocation parentName;
            JsonObject root = json.getAsJsonObject();
            if (!root.has("machine")) {
                throw new JsonParseException("No 'machine'-entry specified!");
            }
            if (!root.has("registryName") && !root.has("registryname")) {
                throw new JsonParseException("No 'registryName'-entry specified!");
            }
            if (!root.has("recipeTime")) {
                throw new JsonParseException("No 'recipeTime'-entry specified!");
            }
            JsonElement elementMachine = root.get("machine");
            LinkedList qualifiedMachineNames = Lists.newLinkedList();
            if (elementMachine.isJsonArray()) {
                if (elementMachine.getAsJsonArray().size() <= 0) {
                    throw new JsonParseException("'machine' is an array, but it's empty! Provide at least 1 owning-machine name!");
                }
                JsonArray jar = elementMachine.getAsJsonArray();
                for (JsonElement je : jar) {
                    if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isString()) {
                        qualifiedMachineNames.add(new ResourceLocation("modularmachinery", je.getAsJsonPrimitive().getAsString()));
                        continue;
                    }
                    throw new JsonParseException("Found an element in the array specified in 'machine' that is not a string! " + je.toString());
                }
                if (qualifiedMachineNames.isEmpty()) {
                    throw new JsonParseException("'machine' is an array, but it's empty! Provide at least 1 owning-machine name!");
                }
            } else if (elementMachine.isJsonPrimitive() && elementMachine.getAsJsonPrimitive().isString()) {
                qualifiedMachineNames.add(new ResourceLocation("modularmachinery", elementMachine.getAsJsonPrimitive().getAsString()));
            } else {
                throw new JsonParseException("'machine' has to be either an array of strings or just a string! - Found " + elementMachine.toString() + " instead!");
            }
            JsonElement elementRegistryName = root.get("registryName");
            if (elementRegistryName == null) {
                elementRegistryName = root.get("registryname");
            }
            if (!elementRegistryName.isJsonPrimitive() || !elementRegistryName.getAsJsonPrimitive().isString()) {
                throw new JsonParseException("'registryName' has to have as value only a String that defines its unique registry name!");
            }
            JsonElement elementTime = root.get("recipeTime");
            if (!elementTime.isJsonPrimitive() || !elementTime.getAsJsonPrimitive().isNumber()) {
                throw new JsonParseException("'recipeTime' has to be a number!");
            }
            int priority = 0;
            if (root.has("priority")) {
                JsonElement elementPriority = root.get("priority");
                if (!elementPriority.isJsonPrimitive() || !elementPriority.getAsJsonPrimitive().isNumber()) {
                    throw new JsonParseException("'priority' has to be a number! (if specified)");
                }
                priority = elementPriority.getAsInt();
            }
            if ((parentName = (ResourceLocation)Iterables.getFirst((Iterable)qualifiedMachineNames, null)) == null) {
                throw new IllegalStateException("Couldn't find machine name from qualified-names list: " + Arrays.toString(qualifiedMachineNames.toArray()));
            }
            String registryName = elementRegistryName.getAsJsonPrimitive().getAsString();
            int recipeTime = elementTime.getAsJsonPrimitive().getAsInt();
            MachineRecipe recipe = new MachineRecipe(RecipeLoader.currentlyReadingPath, new ResourceLocation("modularmachinery", registryName), parentName, recipeTime, priority);
            MachineRecipeContainer outContainer = new MachineRecipeContainer(recipe);
            outContainer.recipeOwnerList.addAll(qualifiedMachineNames);
            if (!root.has("requirements")) {
                throw new JsonParseException("No 'requirements'-entry specified!");
            }
            JsonElement elementRequirements = root.get("requirements");
            if (!elementRequirements.isJsonArray()) {
                throw new JsonParseException("'requirements' should be an array of recipe requirements!");
            }
            JsonArray requirementsArray = elementRequirements.getAsJsonArray();
            for (int i = 0; i < requirementsArray.size(); ++i) {
                JsonElement elementRequirement = requirementsArray.get(i);
                if (!elementRequirement.isJsonObject()) {
                    throw new JsonParseException("Each element in the 'requirements' array needs to be a fully defined requirement-object!");
                }
                recipe.recipeRequirements.add(this.deserializeRequirement(elementRequirement.getAsJsonObject()));
            }
            if (recipe.recipeRequirements.isEmpty()) {
                throw new JsonParseException("A recipe needs to have at least 1 requirement!");
            }
            return outContainer;
        }

        @Nonnull
        private ComponentRequirement deserializeRequirement(JsonObject requirement) throws JsonParseException {
            if (!(requirement.has("type") && requirement.get("type").isJsonPrimitive() && requirement.get("type").getAsJsonPrimitive().isString())) {
                throw new JsonParseException("'type' of a requirement is missing or isn't a string!");
            }
            String type = requirement.getAsJsonPrimitive("type").getAsString();
            if (!(requirement.has("io-type") && requirement.get("io-type").isJsonPrimitive() && requirement.get("io-type").getAsJsonPrimitive().isString())) {
                throw new JsonParseException("'io-type' of a requirement is missing or isn't a string!");
            }
            String ioType = requirement.getAsJsonPrimitive("io-type").getAsString();
            ComponentType componentType = ComponentType.Registry.getComponent(type);
            if (componentType == null) {
                throw new JsonParseException("'" + type + "' is not a valid ComponentType!");
            }
            MachineComponent.IOType machineIoType = MachineComponent.IOType.getByString(ioType);
            if (machineIoType == null) {
                throw new JsonParseException("'" + ioType + "' is not a valid IOType!");
            }
            return componentType.provideComponent(machineIoType, requirement);
        }
    }

    public static class MachineRecipeContainer {
        private final MachineRecipe parent;
        private List<ResourceLocation> recipeOwnerList = Lists.newLinkedList();

        private MachineRecipeContainer(MachineRecipe copyParent) {
            this.parent = copyParent;
        }

        public List<MachineRecipe> getRecipes() {
            ArrayList out = Lists.newArrayListWithCapacity((int)this.recipeOwnerList.size());
            for (int i = 0; i < this.recipeOwnerList.size(); ++i) {
                ResourceLocation location = this.recipeOwnerList.get(i);
                MachineRecipe rec = new MachineRecipe(this.parent.recipeFilePath + "_sub_" + i, new ResourceLocation(this.parent.registryName.func_110624_b(), this.parent.registryName.func_110623_a() + "_sub_" + i), location, this.parent.tickTime, this.parent.configuredPriority);
                for (ComponentRequirement req : this.parent.recipeRequirements) {
                    rec.recipeRequirements.add(req.deepCopy());
                }
                out.add(rec);
            }
            return out;
        }
    }
}

