/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife;

import java.io.File;
import java.util.concurrent.Callable;
import net.minecraft.command.ICommand;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.FoodModifier;
import squeek.spiceoflife.foodtracker.FoodTracker;
import squeek.spiceoflife.foodtracker.capability.IFoodHistory;
import squeek.spiceoflife.foodtracker.commands.CommandResetHistory;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupConfig;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.gui.TooltipHandler;
import squeek.spiceoflife.helpers.GuiHelper;
import squeek.spiceoflife.helpers.MovementHelper;
import squeek.spiceoflife.network.PacketHandler;

@Mod(modid="spiceoflife", version="1.3.12", dependencies="required-after:applecore", acceptedMinecraftVersions="[1.12]")
public class ModSpiceOfLife {
    public static final Logger Log = LogManager.getLogger((String)"spiceoflife");
    @Mod.Instance(value="spiceoflife")
    public static ModSpiceOfLife instance;
    public File sourceFile;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.sourceFile = event.getSourceFile();
        ModConfig.init(event.getSuggestedConfigurationFile());
        CapabilityManager.INSTANCE.register(IFoodHistory.class, (Capability.IStorage)new Capability.IStorage<IFoodHistory>(){

            public NBTBase writeNBT(Capability<IFoodHistory> capability, IFoodHistory instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<IFoodHistory> capability, IFoodHistory instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
            }
        }, (Callable)new Callable<IFoodHistory>(){

            @Override
            public IFoodHistory call() throws Exception {
                return new FoodHistory();
            }
        });
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GuiHelper.init();
        MovementHelper.init();
        FoodTracker foodTracker = new FoodTracker();
        MinecraftForge.EVENT_BUS.register((Object)foodTracker);
        MinecraftForge.EVENT_BUS.register((Object)new FoodModifier());
        if (event.getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new TooltipHandler());
        }
        PacketHandler.PacketType.values();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        FoodGroupConfig.load();
        FMLInterModComms.sendRuntimeMessage((Object)"spiceoflife", (String)"VersionChecker", (String)"addVersionCheck", (String)"http://www.ryanliptak.com/minecraft/versionchecker/squeek502/SpiceOfLife");
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        FoodGroupRegistry.setInStone();
        event.registerServerCommand((ICommand)new CommandResetHistory());
    }
}

