/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tools;

import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.common.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.common.tools.UniqueItem;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;

public class BlockMapIntState {
    public Map<Short, IBlockState> intStateMap = new HashMap<Short, IBlockState>();
    public Map<IBlockState, UniqueItem> intStackMap = new HashMap<IBlockState, UniqueItem>();

    public Map<Short, IBlockState> getIntStateMap() {
        return this.intStateMap;
    }

    public Map<IBlockState, UniqueItem> getIntStackMap() {
        return this.intStackMap;
    }

    public void addToMap(IBlockState mapState) {
        if (this.findSlot(mapState) == -1) {
            short nextSlot = (short)this.intStateMap.size();
            nextSlot = (short)(nextSlot + 1);
            this.intStateMap.put(nextSlot, mapState);
        }
    }

    public void addToStackMap(UniqueItem uniqueItem, IBlockState blockState) {
        if (this.findStackSlot(uniqueItem) != blockState) {
            this.intStackMap.put(blockState, uniqueItem);
        }
    }

    public Short findSlot(IBlockState mapState) {
        for (Map.Entry<Short, IBlockState> entry : this.intStateMap.entrySet()) {
            if (entry.getValue() != mapState) continue;
            return entry.getKey();
        }
        return (short)-1;
    }

    @Nullable
    private IBlockState findStackSlot(UniqueItem uniqueItem) {
        for (Map.Entry<IBlockState, UniqueItem> entry : this.intStackMap.entrySet()) {
            if (entry.getValue().item != uniqueItem.item || entry.getValue().meta != uniqueItem.meta) continue;
            return entry.getKey();
        }
        return null;
    }

    public IBlockState getStateFromSlot(Short slot) {
        return this.intStateMap.get(slot);
    }

    public UniqueItem getStackFromSlot(IBlockState blockState) {
        return this.intStackMap.get(blockState);
    }

    public Map<Short, IBlockState> getIntStateMapFromNBT(NBTTagList tagList) {
        this.intStateMap = new HashMap<Short, IBlockState>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound = tagList.func_150305_b(i);
            this.intStateMap.put(compound.func_74765_d("mapSlot"), NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("mapState")));
        }
        return this.intStateMap;
    }

    public NBTTagList putIntStateMapIntoNBT() {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<Short, IBlockState> entry : this.intStateMap.entrySet()) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagCompound state = new NBTTagCompound();
            NBTUtil.func_190009_a((NBTTagCompound)state, (IBlockState)entry.getValue());
            compound.func_74777_a("mapSlot", entry.getKey().shortValue());
            compound.func_74782_a("mapState", (NBTBase)state);
            tagList.func_74742_a((NBTBase)compound);
        }
        return tagList;
    }

    public Map<IBlockState, UniqueItem> getIntStackMapFromNBT(NBTTagList tagList) {
        this.intStackMap = new HashMap<IBlockState, UniqueItem>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound = tagList.func_150305_b(i);
            this.intStackMap.put(GadgetUtils.compoundToState(compound.func_74775_l("state")), new UniqueItem(Item.func_150899_d((int)compound.func_74762_e("item")), compound.func_74762_e("meta")));
        }
        return this.intStackMap;
    }

    public NBTTagList putIntStackMapIntoNBT() {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<IBlockState, UniqueItem> entry : this.intStackMap.entrySet()) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("item", Item.func_150891_b((Item)entry.getValue().item));
            compound.func_74768_a("meta", entry.getValue().meta);
            compound.func_74782_a("state", (NBTBase)GadgetUtils.stateToCompound(entry.getKey()));
            tagList.func_74742_a((NBTBase)compound);
        }
        return tagList;
    }

    @Nonnull
    public static UniqueItem blockStateToUniqueItem(IBlockState state, EntityPlayer player, BlockPos pos) {
        ItemStack itemStack;
        try {
            itemStack = state.func_177230_c().getPickBlock(state, null, player.field_70170_p, pos, player);
        }
        catch (Exception e) {
            itemStack = InventoryManipulation.getSilkTouchDrop(state);
        }
        if (itemStack.func_190926_b()) {
            itemStack = InventoryManipulation.getSilkTouchDrop(state);
        }
        if (!itemStack.func_190926_b()) {
            UniqueItem uniqueItem = new UniqueItem(itemStack.func_77973_b(), itemStack.func_77960_j());
            return uniqueItem;
        }
        UniqueItem uniqueItem = new UniqueItem(Items.field_190931_a, 0);
        return uniqueItem;
    }

    public void makeStackMapFromStateMap(EntityPlayer player) {
        this.intStackMap.clear();
        for (Map.Entry<Short, IBlockState> entry : this.intStateMap.entrySet()) {
            try {
                this.intStackMap.put(entry.getValue(), BlockMapIntState.blockStateToUniqueItem(entry.getValue(), player, new BlockPos(0, 0, 0)));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }
}

