/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.integration;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEPartLocation;
import appeng.me.helpers.PlayerSource;
import appeng.util.item.AEItemStack;
import com.direwolf20.buildinggadgets.common.integration.IntegrationHandler;
import com.direwolf20.buildinggadgets.common.tools.NetworkIO;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;

@IntegrationHandler.IntegratedMod(value="appliedenergistics2")
public class AppliedEnergistics2
implements IntegrationHandler.IIntegratedMod {
    private static boolean isLoaded;

    @Override
    public void initialize() {
        isLoaded = true;
    }

    @Nullable
    public static IItemHandler getWrappedNetwork(TileEntity te, EntityPlayer player, NetworkIO.Operation operation) {
        ISecurityGrid security;
        IGridNode node;
        if (isLoaded && te instanceof IGridHost && (node = ((IGridHost)te).getGridNode(AEPartLocation.INTERNAL)) != null && (security = (ISecurityGrid)node.getGrid().getCache(ISecurityGrid.class)).hasPermission(player, operation == NetworkIO.Operation.EXTRACT ? SecurityPermissions.EXTRACT : SecurityPermissions.INJECT)) {
            IStorageGrid grid = (IStorageGrid)node.getGrid().getCache(IStorageGrid.class);
            IMEMonitor network = grid.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            return new NetworkAppliedEnergistics2IO(player, (IMEMonitor<IAEItemStack>)network, operation);
        }
        return null;
    }

    private static class NetworkAppliedEnergistics2IO
    extends NetworkIO<StackProviderAE2> {
        private IMEMonitor<IAEItemStack> network;

        public NetworkAppliedEnergistics2IO(EntityPlayer player, IMEMonitor<IAEItemStack> network, NetworkIO.Operation operation) {
            super(player, operation == NetworkIO.Operation.INSERT ? null : (Collection)Streams.stream((Iterable)network.getStorageList()).map(aeStack -> new StackProviderAE2((IAEItemStack)aeStack)).collect(Collectors.toList()));
            this.network = network;
        }

        @Override
        @Nullable
        public ItemStack insertItemInternal(ItemStack stack, boolean simulate) {
            AEItemStack aeStack = AEItemStack.fromItemStack((ItemStack)stack);
            if (aeStack == null) {
                return ItemStack.field_190927_a;
            }
            IAEItemStack remainder = (IAEItemStack)this.network.injectItems((IAEStack)aeStack, this.getAction(simulate), (IActionSource)new PlayerSource(this.player, null));
            return remainder == null ? null : remainder.createItemStack();
        }

        @Override
        @Nullable
        public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
            IAEItemStack remainder = (IAEItemStack)this.network.extractItems((IAEStack)((StackProviderAE2)this.getStackProviderInSlot(slot)).withSize(amount), this.getAction(simulate), (IActionSource)new PlayerSource(this.player, null));
            return remainder == null ? null : remainder.createItemStack();
        }

        private Actionable getAction(boolean simulate) {
            return simulate ? Actionable.SIMULATE : Actionable.MODULATE;
        }
    }

    public static class StackProviderAE2
    implements NetworkIO.IStackProvider {
        @Nonnull
        private IAEItemStack aeStack;

        public StackProviderAE2(@Nonnull IAEItemStack aeStack) {
            this.aeStack = aeStack;
        }

        @Override
        @Nonnull
        public ItemStack getStack() {
            return this.aeStack.createItemStack();
        }

        public IAEItemStack withSize(int amount) {
            return (IAEItemStack)this.aeStack.copy().setStackSize((long)amount);
        }
    }
}

