/*
 * Decompiled with CFR 0.152.
 */
package openmods.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigStorage {
    public static final ConfigStorage instance = new ConfigStorage();
    private Multimap<String, Configuration> configs = ArrayListMultimap.create();

    public void register(Configuration value) {
        ModContainer mod = Loader.instance().activeModContainer();
        Preconditions.checkNotNull((Object)mod, (Object)"Can't register outside initialization");
        String modId = mod.getModId();
        this.configs.put((Object)modId, (Object)value);
    }

    public Collection<Configuration> getConfigs(String modId) {
        return this.configs.get((Object)modId);
    }

    public void saveAll(String modId) {
        for (Configuration config : this.configs.get((Object)modId)) {
            if (!config.hasChanged()) continue;
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.PostConfigChangedEvent evt) {
        this.saveAll(evt.getModID());
    }
}

