/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.item.cyclicwand.ItemCyclicWand;
import com.lothrazar.cyclicmagic.registry.SpellRegistry;
import com.lothrazar.cyclicmagic.spell.ISpell;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class UtilSpellCaster {
    public static ItemStack getPlayerWandIfHeld(EntityPlayer player) {
        ItemStack wand = player.func_184614_ca();
        if (!wand.func_190926_b() && wand.func_77973_b() instanceof ItemCyclicWand) {
            return wand;
        }
        wand = player.func_184592_cb();
        if (!wand.func_190926_b() && wand.func_77973_b() instanceof ItemCyclicWand) {
            return wand;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean spellsEnabled(EntityPlayer player) {
        return !UtilSpellCaster.getPlayerWandIfHeld(player).func_190926_b();
    }

    public static boolean tryCastCurrent(World world, EntityPlayer player, BlockPos pos, EnumFacing side, ItemStack wand, EnumHand hand) {
        return UtilSpellCaster.tryCast(UtilSpellCaster.getPlayerCurrentISpell(player), world, player, pos, side, wand, hand);
    }

    public static boolean tryCast(ISpell spell, World world, EntityPlayer player, BlockPos pos, EnumFacing side, ItemStack wand, EnumHand hand) {
        if (wand.func_190926_b()) {
            return false;
        }
        if (spell.canPlayerCast(world, player, pos)) {
            if (spell.cast(world, player, wand, pos, side)) {
                if (hand != null) {
                    player.func_184609_a(hand);
                }
                return true;
            }
            return false;
        }
        spell.onCastFailure(world, player, pos);
        return false;
    }

    public static void shiftLeft(EntityPlayer player) {
        ItemStack wand = UtilSpellCaster.getPlayerWandIfHeld(player);
        if (wand.func_190926_b()) {
            return;
        }
        ISpell curr = ItemCyclicWand.Spells.getSpellCurrent(wand);
        int left = SpellRegistry.prev(wand, curr).getID();
        ItemCyclicWand.Spells.setSpellCurrent(wand, left);
    }

    public static void shiftRight(EntityPlayer player) {
        ItemStack wand = UtilSpellCaster.getPlayerWandIfHeld(player);
        if (wand.func_190926_b()) {
            return;
        }
        ISpell curr = ItemCyclicWand.Spells.getSpellCurrent(wand);
        int right = SpellRegistry.next(wand, curr).getID();
        ItemCyclicWand.Spells.setSpellCurrent(wand, right);
    }

    public static ISpell getPlayerCurrentISpell(EntityPlayer player) {
        ItemStack wand = UtilSpellCaster.getPlayerWandIfHeld(player);
        ISpell current = SpellRegistry.getSpellFromID(ItemCyclicWand.Spells.getSpellIDCurrent(wand));
        if (current == null) {
            current = SpellRegistry.getSpellbook(wand).get(0);
        }
        return current;
    }

    public static void rechargeWithExp(EntityPlayer player) {
    }
}

