/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import com.lothrazar.cyclicmagic.block.ore.BlockDimensionOre;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.guide.GuideItem;
import com.lothrazar.cyclicmagic.guide.GuideRegistry;
import com.lothrazar.cyclicmagic.registry.module.WorldModule;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BlockOreRegistry {
    static boolean DEFAULT_MODORES_ENABLED = true;

    private static void addOre(BlockDimensionOre ore) {
        WorldModule.ores.add(ore);
    }

    private static BlockDimensionOre createOre(int dimension, String name, int harvestLevel, String ... oreDict) {
        String block = null;
        String dimName = null;
        if (dimension == -1) {
            dimName = "nether";
            block = "minecraft:netherrack";
        } else if (dimension == 1) {
            dimName = "end";
            block = "minecraft:end_stone";
        } else if (dimension == 0) {
            dimName = "world";
            block = "minecraft:stone";
        }
        String cateogry = name + "." + dimName;
        BlockDimensionOre ore = new BlockDimensionOre();
        ore.registerOreDict(oreDict);
        ore.config.setDimension(dimension).setBlockToReplace(block).setConfigCategory(cateogry).setBlockCountConfig("blockCount").setSpawnChanceConfig("spawnChance").setRegisteredDefault(DEFAULT_MODORES_ENABLED).setBlockCountDefault(8).setHarvestLevelDefault(harvestLevel).setSpawnChanceDefault(5).setBlockId(name + "_" + dimName + "_ore");
        BlockOreRegistry.addOre(ore);
        return ore;
    }

    private static void createNetherAndEndOres(String name, int harvestLevel, String oreDict) {
        BlockOreRegistry.createOre(-1, name, harvestLevel, "ore" + oreDict, "oreNether" + oreDict);
        BlockOreRegistry.createOre(1, name, harvestLevel, "ore" + oreDict, "oreEnd" + oreDict);
    }

    public static void register() {
        boolean coalHarvest = false;
        boolean ironHarvest = true;
        boolean lapisHarvest = true;
        int emeraldHarvest = 2;
        int diamondHarvest = 2;
        int goldHarvest = 2;
        int redstoneHarvest = 2;
        BlockOreRegistry.createNetherAndEndOres("titanium", 1, "Titanium");
        BlockOreRegistry.createNetherAndEndOres("aquamarine", 1, "Aquamarine");
        BlockOreRegistry.createNetherAndEndOres("bauxite", 1, "Bauxite");
        BlockOreRegistry.createNetherAndEndOres("boron", 1, "Boron");
        BlockOreRegistry.createNetherAndEndOres("cobalt", 1, "Cobalt");
        BlockOreRegistry.createNetherAndEndOres("copper", 1, "Copper");
        BlockOreRegistry.createNetherAndEndOres("dilithium", 1, "Dilithium");
        BlockOreRegistry.createNetherAndEndOres("galena", 1, "Galena");
        BlockOreRegistry.createNetherAndEndOres("iridium", 1, "Iridium");
        BlockOreRegistry.createNetherAndEndOres("lead", 1, "Lead");
        BlockOreRegistry.createNetherAndEndOres("lithium", 1, "Lithium");
        BlockOreRegistry.createNetherAndEndOres("magnesium", 1, "Magnesium");
        BlockOreRegistry.createNetherAndEndOres("mithril", 1, "Mithril");
        BlockOreRegistry.createNetherAndEndOres("nickel", 1, "Nickel");
        BlockOreRegistry.createNetherAndEndOres("nitre", 1, "Saltpeter");
        BlockOreRegistry.createNetherAndEndOres("osmium", 1, "Osmium");
        BlockOreRegistry.createNetherAndEndOres("platinum", 1, "Platinum");
        BlockOreRegistry.createNetherAndEndOres("quartz_black", 1, "QuartzBlack");
        BlockOreRegistry.createNetherAndEndOres("quartz_certus", 1, "CertusQuartz");
        BlockOreRegistry.createNetherAndEndOres("quartz_certus_charged", 1, "ChargedCertusQuartz");
        BlockOreRegistry.createNetherAndEndOres("sapphire", 1, "Sapphire");
        BlockOreRegistry.createNetherAndEndOres("thorium", 1, "Thorium");
        BlockOreRegistry.createNetherAndEndOres("tungsten", 1, "Tungsten");
        BlockOreRegistry.createNetherAndEndOres("ruby", 1, "Ruby");
        BlockOreRegistry.createNetherAndEndOres("silver", 1, "Silver");
        BlockOreRegistry.createNetherAndEndOres("tin", 1, "Tin");
        BlockOreRegistry.createNetherAndEndOres("uranium", 1, "Uranium");
        BlockOreRegistry.createNetherAndEndOres("yellorite", 1, "Yellorium");
        BlockDimensionOre nether_redstone_ore = new BlockDimensionOre(Items.field_151137_ax);
        nether_redstone_ore.setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 2).registerSmeltingOutput(Items.field_151137_ax).registerOreDict("oreRedstone", "oreNetherRedstone");
        nether_redstone_ore.config.setDimension(-1).setBlockToReplace("minecraft:netherrack").setConfigCategory("cyclicmagic.world generation.netherorecustom").setBlockCountConfig("blockCountRedstone").setSpawnChanceConfig("spawnChanceRedstone").setBlockCountDefault(8).setVanilla().setSpawnChanceDefault(8).setHarvestLevelDefault(1).setBlockId("nether_redstone_ore");
        BlockOreRegistry.addOre(nether_redstone_ore);
        BlockDimensionOre nether_iron_ore = new BlockDimensionOre(Items.field_191525_da, 0, 12);
        nether_iron_ore.setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 2).registerSmeltingOutput(Items.field_151042_j).registerOreDict("oreIron", "oreNetherIron");
        nether_iron_ore.config.setDimension(-1).setBlockToReplace("minecraft:netherrack").setVanilla().setConfigCategory("cyclicmagic.world generation.netherorecustom").setBlockCountConfig("blockCountIron").setSpawnChanceConfig("spawnChanceIron").setBlockCountDefault(12).setSpawnChanceDefault(10).setHarvestLevelDefault(1).setBlockId("nether_iron_ore");
        BlockOreRegistry.addOre(nether_iron_ore);
        BlockDimensionOre nether_gold_ore = new BlockDimensionOre(Items.field_151074_bl, 0, 4);
        nether_gold_ore.setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 1).registerSmeltingOutput(Items.field_151043_k).registerOreDict("oreGold", "oreNetherGold");
        nether_gold_ore.config.setDimension(-1).setBlockToReplace("minecraft:netherrack").setConfigCategory("cyclicmagic.world generation.netherorecustom").setBlockCountConfig("blockCountGold").setVanilla().setSpawnChanceConfig("spawnChanceGold").setBlockCountDefault(8).setHarvestLevelDefault(2).setSpawnChanceDefault(40).setBlockId("nether_gold_ore");
        BlockOreRegistry.addOre(nether_gold_ore);
        BlockDimensionOre nether_coal_ore = new BlockDimensionOre(Items.field_151044_h);
        nether_coal_ore.setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 1).registerSmeltingOutput(Items.field_151044_h).registerOreDict("oreCoal", "oreNetherCoal");
        nether_coal_ore.config.setDimension(-1).setBlockToReplace("minecraft:netherrack").setVanilla().setConfigCategory("cyclicmagic.world generation.netherorecustom").setBlockCountConfig("blockCountCoal").setSpawnChanceConfig("spawnChanceCoal").setBlockCountDefault(8).setHarvestLevelDefault(0).setSpawnChanceDefault(20).setBlockId("nether_coal_ore");
        BlockOreRegistry.addOre(nether_coal_ore);
        BlockDimensionOre nether_lapis_ore = new BlockDimensionOre(Items.field_151100_aR, EnumDyeColor.BLUE.func_176767_b(), 3);
        nether_lapis_ore.setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 2).registerSmeltingOutput(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b())).registerOreDict("oreLapis", "oreNetherLapis");
        nether_lapis_ore.config.setDimension(-1).setBlockToReplace("minecraft:netherrack").setVanilla().setConfigCategory("cyclicmagic.world generation.netherorecustom").setBlockCountConfig("blockCountLapis").setSpawnChanceConfig("spawnChanceLapis").setBlockCountDefault(8).setHarvestLevelDefault(1).setSpawnChanceDefault(10).setBlockId("nether_lapis_ore");
        BlockOreRegistry.addOre(nether_lapis_ore);
        BlockDimensionOre nether_emerald_ore = new BlockDimensionOre(Items.field_151166_bC);
        nether_emerald_ore.setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 5).registerSmeltingOutput(Items.field_151166_bC).registerOreDict("oreEmerald", "oreNetherEmerald");
        nether_emerald_ore.config.setDimension(-1).setBlockToReplace("minecraft:netherrack").setVanilla().setConfigCategory("cyclicmagic.world generation.netherorecustom").setBlockCountConfig("blockCountEmerald").setSpawnChanceConfig("spawnChanceEmerald").setBlockCountDefault(8).setHarvestLevelDefault(2).setSpawnChanceDefault(1).setBlockId("nether_emerald_ore");
        BlockOreRegistry.addOre(nether_emerald_ore);
        BlockDimensionOre nether_diamond_ore = new BlockDimensionOre(Items.field_151045_i);
        nether_diamond_ore.setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 8).registerSmeltingOutput(Items.field_151045_i).registerOreDict("oreDiamond", "oreNetherDiamond");
        nether_diamond_ore.config.setDimension(-1).setBlockToReplace("minecraft:netherrack").setVanilla().setConfigCategory("cyclicmagic.world generation.netherorecustom").setBlockCountConfig("blockCountDiamond").setSpawnChanceConfig("spawnChanceDiamond").setBlockCountDefault(8).setHarvestLevelDefault(2).setSpawnChanceDefault(1).setBlockId("nether_diamond_ore");
        BlockOreRegistry.addOre(nether_diamond_ore);
        BlockDimensionOre end_redstone_ore = new BlockDimensionOre(Items.field_151137_ax);
        end_redstone_ore.setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 3).registerSmeltingOutput(Items.field_151137_ax).registerOreDict("oreRedstone", "oreEndRedstone");
        end_redstone_ore.config.setDimension(1).setBlockToReplace("minecraft:end_stone").setVanilla().setConfigCategory("cyclicmagic.world generation.endorecustom").setBlockCountConfig("blockCountRedstone").setSpawnChanceConfig("spawnChanceRedstone").setBlockCountDefault(8).setHarvestLevelDefault(2).setSpawnChanceDefault(15).setBlockId("end_redstone_ore");
        BlockOreRegistry.addOre(end_redstone_ore);
        BlockDimensionOre end_coal_ore = new BlockDimensionOre(Items.field_151044_h);
        end_coal_ore.setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 1).registerSmeltingOutput(Items.field_151044_h).registerOreDict("oreCoal", "oreEndCoal");
        end_coal_ore.config.setDimension(1).setBlockToReplace("minecraft:end_stone").setVanilla().setConfigCategory("cyclicmagic.world generation.endorecustom").setBlockCountConfig("blockCountCoal").setSpawnChanceConfig("spawnChanceCoal").setBlockCountDefault(8).setHarvestLevelDefault(0).setSpawnChanceDefault(10).setBlockId("end_coal_ore");
        BlockOreRegistry.addOre(end_coal_ore);
        BlockDimensionOre end_lapis_ore = new BlockDimensionOre(Items.field_151100_aR, EnumDyeColor.BLUE.func_176767_b(), 3);
        end_lapis_ore.setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 5).registerSmeltingOutput(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b())).registerOreDict("oreLapis", "oreEndLapis");
        end_lapis_ore.config.setDimension(1).setBlockToReplace("minecraft:end_stone").setVanilla().setConfigCategory("cyclicmagic.world generation.endorecustom").setBlockCountConfig("blockCountLapis").setSpawnChanceConfig("spawnChanceLapis").setBlockCountDefault(8).setHarvestLevelDefault(1).setSpawnChanceDefault(12).setBlockId("end_lapis_ore");
        BlockOreRegistry.addOre(end_lapis_ore);
        BlockDimensionOre end_emerald_ore = new BlockDimensionOre(Items.field_151166_bC);
        end_emerald_ore.setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 8).registerSmeltingOutput(Items.field_151166_bC).registerOreDict("oreEmerald", "oreEndEmerald");
        end_emerald_ore.config.setDimension(1).setBlockToReplace("minecraft:end_stone").setConfigCategory("cyclicmagic.world generation.endorecustom").setBlockCountConfig("blockCountEmerald").setVanilla().setSpawnChanceConfig("spawnChanceEmerald").setBlockCountDefault(8).setHarvestLevelDefault(2).setSpawnChanceDefault(1).setBlockId("end_emerald_ore");
        BlockOreRegistry.addOre(end_emerald_ore);
        BlockDimensionOre end_diamond_ore = new BlockDimensionOre(Items.field_151045_i);
        end_diamond_ore.setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 8).registerSmeltingOutput(Items.field_151045_i).registerOreDict("oreDiamond", "oreEndDiamond");
        end_diamond_ore.config.setDimension(1).setBlockToReplace("minecraft:end_stone").setVanilla().setConfigCategory("cyclicmagic.world generation.endorecustom").setBlockCountConfig("blockCountDiamond").setSpawnChanceConfig("spawnChanceDiamond").setBlockCountDefault(8).setHarvestLevelDefault(2).setSpawnChanceDefault(1).setBlockId("end_diamond_ore");
        BlockOreRegistry.addOre(end_diamond_ore);
        BlockDimensionOre end_gold_ore = new BlockDimensionOre(Items.field_151043_k);
        end_gold_ore.setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 2).registerSmeltingOutput(Items.field_151043_k).registerOreDict("oreGold", "oreEndGold");
        end_gold_ore.config.setDimension(1).setBlockToReplace("minecraft:end_stone").setVanilla().setConfigCategory("cyclicmagic.world generation.endorecustom").setBlockCountConfig("blockCountGold").setSpawnChanceConfig("spawnChanceGold").setBlockCountDefault(8).setHarvestLevelDefault(2).setSpawnChanceDefault(4).setBlockId("end_gold_ore");
        BlockOreRegistry.addOre(end_gold_ore);
        BlockDimensionOre end_iron_ore = new BlockDimensionOre(Items.field_191525_da, 0, 16);
        end_iron_ore.setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 2).registerSmeltingOutput(Items.field_151042_j).registerOreDict("oreIron", "oreEndIron");
        end_iron_ore.config.setDimension(1).setBlockToReplace("minecraft:end_stone").setVanilla().setConfigCategory("cyclicmagic.world generation.endorecustom").setBlockCountConfig("blockCountIron").setSpawnChanceConfig("spawnChanceIron").setBlockCountDefault(8).setHarvestLevelDefault(1).setSpawnChanceDefault(4).setBlockId("end_iron_ore");
        BlockOreRegistry.addOre(end_iron_ore);
        GuideItem page = GuideRegistry.register(GuideCategory.WORLD, Item.func_150898_a((Block)nether_gold_ore), "world.netherore.title");
        page.addTextPage("world.netherore.guide");
        page = GuideRegistry.register(GuideCategory.WORLD, Item.func_150898_a((Block)end_redstone_ore), "world.endore.title");
        page.addTextPage("world.endore.guide");
    }
}

