/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.equipbauble;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.core.BaseCharm;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.LootTableRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class ItemAutoTorch
extends BaseCharm
implements IHasRecipe,
IContent {
    private static final int durability = 256;
    private static int lightLimit = 7;
    private boolean enabled;

    public ItemAutoTorch() {
        super(256);
    }

    @Override
    public void onTick(ItemStack stack, EntityPlayer player) {
        ItemStack torches;
        if (!this.canTick(stack)) {
            return;
        }
        World world = player.field_70170_p;
        BlockPos pos = player.func_180425_c();
        if (world.func_175721_c(pos, true) < lightLimit && !player.func_175149_v() && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) && world.func_175623_d(pos)) {
            if (UtilPlaceBlocks.placeStateSafe(world, player, pos, Blocks.field_150478_aa.func_176223_P())) {
                super.damageCharm(player, stack);
            }
        } else if (stack.func_77951_h() && !(torches = this.findAmmo(player, Item.func_150898_a((Block)Blocks.field_150478_aa))).func_190926_b()) {
            torches.func_190918_g(1);
            UtilItemStack.repairItem(player, stack);
        }
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "cic", " i ", "cic", Character.valueOf('c'), "blockCoal", Character.valueOf('i'), Blocks.field_150411_aY);
    }

    @Override
    public void register() {
        ItemRegistry.register(this, "tool_auto_torch", GuideCategory.ITEMBAUBLES);
        ModCyclic.instance.events.register(this);
        LootTableRegistry.registerLoot(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("AutomaticTorch", "cyclicmagic.content", true, "Set false to delete - requires restart");
        lightLimit = config.getInt("AutoTorchLightLevel", "modpacks", 7, 1, 14, "At which light level will auto torch place.  Set to 7 means it will place a torch 7 or darker.  (15 is full light, 0 is full dark)");
    }
}

