/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.boomerang;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.entity.EntityThrowableDispensable;
import com.lothrazar.cyclicmagic.item.boomerang.RenderSnowballSpin;
import com.lothrazar.cyclicmagic.potion.PotionEffectRegistry;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class EntityBoomerang
extends EntityThrowableDispensable {
    @GameRegistry.ObjectHolder(value="cyclicmagic:boomerang")
    public static final Item boomerangItem = null;
    private static final int STUN_TICKS = 45;
    private static final int TICKS_UNTIL_RETURN = 12;
    private static final int TICKS_UNTIL_DEATH = 900;
    private static final double SPEED = 0.95;
    static final float DAMAGE_MIN = 1.5f;
    static final float DAMAGE_MAX = 2.8f;
    private static final DataParameter<Byte> IS_RETURNING = EntityDataManager.func_187226_a(EntityBoomerang.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> REDSTONE_TRIGGERED = EntityDataManager.func_187226_a(EntityBoomerang.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<String> OWNER = EntityDataManager.func_187226_a(EntityBoomerang.class, (DataSerializer)DataSerializers.field_187194_d);
    private EntityLivingBase targetEntity;
    private ItemStack boomerangThrown = ItemStack.field_190927_a;

    public EntityBoomerang(World worldIn) {
        super(worldIn);
    }

    public EntityBoomerang(World worldIn, EntityLivingBase ent) {
        super(worldIn, ent);
    }

    public EntityBoomerang(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public void setOwner(EntityLivingBase ent) {
        this.targetEntity = ent;
        this.field_70180_af.func_187227_b(OWNER, (Object)ent.func_110124_au().toString());
    }

    public ItemStack getBoomerangThrown() {
        return this.boomerangThrown;
    }

    public void setBoomerangThrown(ItemStack boomerangThrown) {
        this.boomerangThrown = boomerangThrown;
    }

    private void setRedstoneHasTriggered() {
        this.field_70180_af.func_187227_b(REDSTONE_TRIGGERED, (Object)1);
    }

    private boolean hasTriggeredRedstoneAlready() {
        return (Byte)this.field_70180_af.func_187225_a(REDSTONE_TRIGGERED) > 0;
    }

    public boolean isOwner(Entity entityHit) {
        String id = (String)this.field_70180_af.func_187225_a(OWNER);
        return id.equalsIgnoreCase(entityHit.func_110124_au().toString());
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74778_a("OWNER", (String)this.field_70180_af.func_187225_a(OWNER));
        tag.func_74774_a("returning", ((Byte)this.field_70180_af.func_187225_a(IS_RETURNING)).byteValue());
        tag.func_74774_a("REDSTONE_TRIGGERED", ((Byte)this.field_70180_af.func_187225_a(REDSTONE_TRIGGERED)).byteValue());
        this.boomerangThrown.func_77955_b(tag);
        super.func_70014_b(tag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.field_70180_af.func_187227_b(OWNER, (Object)tag.func_74779_i("OWNER"));
        this.field_70180_af.func_187227_b(IS_RETURNING, (Object)tag.func_74771_c("returning"));
        this.field_70180_af.func_187227_b(REDSTONE_TRIGGERED, (Object)tag.func_74771_c("REDSTONE_TRIGGERED"));
        this.boomerangThrown = new ItemStack(tag);
        super.func_70037_a(tag);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(REDSTONE_TRIGGERED, (Object)0);
        this.field_70180_af.func_187214_a(IS_RETURNING, (Object)0);
        this.field_70180_af.func_187214_a(OWNER, (Object)"");
        super.func_70088_a();
    }

    @Override
    protected void processImpact(RayTraceResult mop) {
        if (mop.field_72308_g != null) {
            if (this.isOwner(mop.field_72308_g)) {
                this.dropAsItem();
            } else {
                EntityLivingBase living;
                float damage = MathHelper.func_151240_a((Random)this.field_70170_p.field_73012_v, (float)1.5f, (float)2.8f);
                mop.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), damage);
                if (mop.field_72308_g instanceof EntityLivingBase && !(living = (EntityLivingBase)mop.field_72308_g).func_70644_a((Potion)PotionEffectRegistry.STUN)) {
                    living.func_70690_d(new PotionEffect((Potion)PotionEffectRegistry.STUN, 45, 1));
                }
            }
        } else {
            IBlockState block;
            if (mop.func_178782_a() != null && this.isBreakable(block = this.field_70170_p.func_180495_p(mop.func_178782_a()))) {
                this.field_70170_p.func_175655_b(mop.func_178782_a(), true);
            }
            this.setIsReturning();
        }
    }

    private boolean isBreakable(IBlockState block) {
        Block bk = block.func_177230_c();
        return bk == Blocks.field_185766_cS || bk == Blocks.field_150473_bD || bk == Blocks.field_150395_bd;
    }

    private void dropAsItem() {
        if (this.targetEntity != null) {
            if (this.targetEntity.func_184614_ca().func_190926_b()) {
                this.targetEntity.func_184611_a(EnumHand.MAIN_HAND, this.boomerangThrown);
            } else {
                this.targetEntity.func_70099_a(this.boomerangThrown, 0.5f);
            }
        } else {
            UtilItemStack.dropItemStackInWorld(this.field_70170_p, this.func_180425_c().func_177984_a(), this.boomerangThrown);
        }
        this.func_70106_y();
    }

    private void setIsReturning() {
        this.field_70180_af.func_187227_b(IS_RETURNING, (Object)1);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 900) {
            this.dropAsItem();
            return;
        }
        if (this.field_70173_aa > 12) {
            this.setIsReturning();
        }
        BlockPos pos = this.func_180425_c();
        if (!this.hasTriggeredRedstoneAlready() && !this.field_70170_p.func_175623_d(pos)) {
            this.tryToggleRedstone(pos);
        }
        this.tryPickupNearby();
        this.movementReturnCheck();
    }

    private void tryToggleRedstone(BlockPos pos) {
        if (this.field_70192_c instanceof EntityPlayer) {
            try {
                IBlockState blockState = this.field_70170_p.func_180495_p(pos);
                Block block = blockState.func_177230_c();
                boolean hasTriggered = block.func_180639_a(this.field_70170_p, pos, blockState, (EntityPlayer)this.field_70192_c, EnumHand.MAIN_HAND, EnumFacing.UP, 0.5f, 0.5f, 0.5f);
                if (hasTriggered) {
                    this.setRedstoneHasTriggered();
                }
            }
            catch (Throwable e) {
                ModCyclic.logger.error("Error on activate block", e);
            }
        }
    }

    private void movementReturnCheck() {
        boolean returning;
        boolean bl = returning = (Byte)this.field_70180_af.func_187225_a(IS_RETURNING) == 1;
        if (returning && this.targetEntity != null) {
            this.moveTowardsTarget();
        }
    }

    private void tryPickupNearby() {
        boolean range = true;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b((double)range, (double)range, (double)range));
        for (Entity entityHit : list) {
            if (!(entityHit instanceof EntityItem) && !(entityHit instanceof EntityXPOrb)) continue;
            entityHit.func_184220_m((Entity)this);
            break;
        }
    }

    protected float func_70185_h() {
        return -0.02f;
    }

    private void moveTowardsTarget() {
        this.field_70177_z = (float)Math.toRadians(UtilEntity.yawDegreesBetweenPoints(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.targetEntity.field_70165_t, this.targetEntity.field_70163_u, this.targetEntity.field_70161_v));
        this.field_70125_A = (float)Math.toRadians(UtilEntity.pitchDegreesBetweenPoints(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.targetEntity.field_70165_t, this.targetEntity.field_70163_u, this.targetEntity.field_70161_v));
        Vec3d moveVec = UtilEntity.lookVector(this.field_70177_z, this.field_70125_A).func_186678_a(0.95);
        this.field_70159_w = 0.5 * this.field_70159_w + 0.5 * moveVec.field_72450_a;
        this.field_70181_x = 0.5 * this.field_70181_x + (double)0.503f * moveVec.field_72448_b;
        this.field_70179_y = 0.5 * this.field_70179_y + 0.5 * moveVec.field_72449_c;
    }

    public static class FactoryFire
    implements IRenderFactory<EntityBoomerang> {
        public Render<? super EntityBoomerang> createRenderFor(RenderManager rm) {
            return new RenderSnowballSpin(rm, boomerangItem, Minecraft.func_71410_x().func_175599_af());
        }
    }
}

