/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.item.core.BaseTool;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class ItemWaterSpreader
extends BaseTool
implements IHasRecipe,
IContent {
    private static final int DURABILITY = 2048;
    private static final int COOLDOWN = 10;
    private static final int RADIUS = 4;
    private boolean enabled;

    public ItemWaterSpreader() {
        super(2048);
    }

    @Override
    public void register() {
        ItemRegistry.register(this, "water_spreader");
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("WaterSpreader", "cyclicmagic.content", true, "Set false to delete - requires restart");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (pos == null) {
            return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
        }
        if (side != null) {
            pos = pos.func_177972_a(side);
        }
        if (this.spreadWaterFromCenter(world, player, pos)) {
            super.onUse(stack, player, world, hand);
        }
        return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.spreadWaterFromCenter(world, player, player.func_180425_c())) {
            super.onUse(stack, player, world, hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private boolean spreadWaterFromCenter(World world, EntityPlayer player, BlockPos posCenter) {
        boolean success;
        int count = 0;
        for (BlockPos pos : UtilWorld.findBlocks(world, posCenter, (Block)Blocks.field_150355_j, 4)) {
            BlockDynamicLiquid blockdynamicliquid = BlockLiquid.func_176361_a((Material)Material.field_151586_h);
            IBlockState state = blockdynamicliquid.func_176223_P();
            world.func_180501_a(pos, blockdynamicliquid.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, state.func_177229_b((IProperty)BlockLiquid.field_176367_b)), 2);
            world.func_175684_a(pos, (Block)blockdynamicliquid, blockdynamicliquid.func_149738_a(world));
            UtilParticle.spawnParticle(world, EnumParticleTypes.WATER_SPLASH, pos);
            UtilParticle.spawnParticle(world, EnumParticleTypes.WATER_SPLASH, pos.func_177984_a());
            ++count;
        }
        boolean bl = success = count > 0;
        if (success) {
            UtilEntity.setCooldownItem(player, this, 10);
            UtilSound.playSound(player, SoundEvents.field_187806_ee);
        }
        return success;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "w w", "iwi", " o ", Character.valueOf('w'), new ItemStack(Items.field_151131_as), Character.valueOf('o'), "ingotGold", Character.valueOf('i'), "blockLapis");
    }
}

