/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.ore;

import com.google.common.base.Predicate;
import com.lothrazar.cyclicmagic.block.ore.BlockDimensionOre;
import com.lothrazar.cyclicmagic.registry.module.WorldModule;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenNewOre
implements IWorldGenerator {
    private static final int MIN_HEIGHT = 5;
    private static final int MAX_HEIGHT = 128;

    public WorldGenNewOre() {
        for (BlockDimensionOre ore : WorldModule.ores) {
            if (!ore.config.isVanilla() && !WorldModule.enableModCompatOres) continue;
            if (ore.config.isVanilla()) {
                if (ore.config.getDimension() == -1 && !WorldModule.netherOreEnabled) {
                    return;
                }
                if (ore.config.getDimension() == 1 && !WorldModule.endOreEnabled) {
                    return;
                }
            }
            if (ore.config.getBlockCount() <= 0 || !ore.config.isRegistered()) continue;
            ore.config.setGen(new WorldGenMinable(ore.func_176223_P(), ore.config.getBlockCount(), (Predicate)BlockMatcher.func_177642_a((Block)ore.config.getBlockToReplaceObject())));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        for (BlockDimensionOre ore : WorldModule.ores) {
            if (ore.config.getGen() == null || !ore.config.isRegistered() || ore.config.getSpawnChance() <= 0 || ore.config.getDimension() != world.field_73011_w.getDimension()) continue;
            this.run((WorldGenerator)ore.config.getGen(), world, random, chunkX * 16, chunkZ * 16, ore.config.getSpawnChance(), 5, 128);
        }
    }

    private void run(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z + rand.nextInt(16);
            BlockPos pos = new BlockPos(x, y, z);
            generator.func_180709_b(world, rand, pos);
        }
    }
}

