/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.laser;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.data.BlockPosDim;
import com.lothrazar.cyclicmagic.data.OffsetEnum;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.item.location.ItemLocation;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class TileEntityLaser
extends TileEntityBaseMachineInvo
implements ITickable,
ITileRedstoneToggle {
    public static final int MAX_TIMER = 100;
    private int needsRedstone = 0;
    private int red = 255;
    private int green = 0;
    private int blue = 0;
    private int alpha = 30;
    private boolean isPulsing = true;
    private boolean isExtending = false;
    private OffsetEnum xOffset = OffsetEnum.CENTER;
    private OffsetEnum yOffset = OffsetEnum.CENTER;
    private OffsetEnum zOffset = OffsetEnum.CENTER;

    public TileEntityLaser() {
        super(4);
        this.setSetRenderGlobally(true);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        ++this.timer;
        if (this.timer > 100) {
            this.timer = 0;
        }
    }

    BlockPosDim getTarget(int slot) {
        return ItemLocation.getPosition(this.func_70301_a(slot));
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.needsRedstone = tags.func_74762_e("redst");
        this.red = tags.func_74762_e("red");
        this.green = tags.func_74762_e("green");
        this.blue = tags.func_74762_e("blue");
        this.alpha = tags.func_74762_e("alpha");
        this.isPulsing = tags.func_74767_n("puls");
        this.isExtending = tags.func_74767_n("extend");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74768_a("redst", this.needsRedstone);
        tags.func_74768_a("red", this.red);
        tags.func_74768_a("green", this.green);
        tags.func_74768_a("blue", this.blue);
        tags.func_74768_a("alpha", this.alpha);
        tags.func_74757_a("puls", this.isPulsing);
        tags.func_74757_a("extend", this.isExtending);
        return super.func_189515_b(tags);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case B: {
                return this.blue;
            }
            case G: {
                return this.green;
            }
            case R: {
                return this.red;
            }
            case ALPHA: {
                return this.alpha;
            }
            case PULSE: {
                return this.isPulsing ? 1 : 0;
            }
            case EXTENDING: {
                return this.isExtending ? 1 : 0;
            }
            case XOFF: {
                return this.xOffset.ordinal();
            }
            case YOFF: {
                return this.yOffset.ordinal();
            }
            case ZOFF: {
                return this.zOffset.ordinal();
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case B: {
                this.blue = value;
                break;
            }
            case G: {
                this.green = value;
                break;
            }
            case R: {
                this.red = value;
                break;
            }
            case ALPHA: {
                this.alpha = value;
                break;
            }
            case PULSE: {
                this.isPulsing = value == 1;
                break;
            }
            case EXTENDING: {
                this.isExtending = value == 1;
                break;
            }
            case XOFF: {
                if (value >= OffsetEnum.values().length) {
                    value = 0;
                }
                this.xOffset = OffsetEnum.values()[value];
                break;
            }
            case YOFF: {
                if (value >= OffsetEnum.values().length) {
                    value = 0;
                }
                this.yOffset = OffsetEnum.values()[value];
                break;
            }
            case ZOFF: {
                if (value >= OffsetEnum.values().length) {
                    value = 0;
                }
                this.zOffset = OffsetEnum.values()[value];
                break;
            }
        }
    }

    public boolean isPulsing() {
        return this.isPulsing;
    }

    public boolean isExtending() {
        return this.isExtending;
    }

    public float alphaCalculated() {
        return (float)this.alpha / 100.0f;
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(this.func_174890_g());
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    public OffsetEnum getxOffset() {
        return this.xOffset;
    }

    public OffsetEnum getyOffset() {
        return this.yOffset;
    }

    public OffsetEnum getzOffset() {
        return this.zOffset;
    }

    public float[] getColor() {
        return new float[]{(float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f};
    }

    public static enum Fields {
        REDSTONE,
        TIMER,
        R,
        G,
        B,
        ALPHA,
        PULSE,
        EXTENDING,
        XOFF,
        YOFF,
        ZOFF;

    }
}

