/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.fire;

import com.lothrazar.cyclicmagic.util.UtilChat;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFireBase
extends BlockFire {
    public BlockFireBase() {
        this.func_149711_c(0.0f).func_149715_a(1.0f);
        this.field_149790_y = false;
        this.field_149762_H = SoundType.field_185854_g;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(UtilChat.lang(this.func_149739_a() + ".tooltip"));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.func_82736_K().func_82766_b("doFireTick")) {
            if (!this.func_176196_c(worldIn, pos)) {
                worldIn.func_175698_g(pos);
            }
            Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
            boolean isBlockBelowFireSource = block.isFireSource(worldIn, pos.func_177977_b(), EnumFacing.UP);
            int intAge = (Integer)state.func_177229_b((IProperty)field_176543_a);
            if (!isBlockBelowFireSource && worldIn.func_72896_J() && this.func_176537_d(worldIn, pos) && rand.nextFloat() < 0.2f + (float)intAge * 0.03f) {
                worldIn.func_175698_g(pos);
            } else {
                if (intAge < 15) {
                    state = state.func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(intAge + rand.nextInt(3) / 2));
                    worldIn.func_180501_a(pos, state, 4);
                } else if (!isBlockBelowFireSource && intAge == 15 && worldIn.field_73012_v.nextDouble() < 0.5) {
                    worldIn.func_175698_g(pos);
                }
                worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn) + rand.nextInt(10));
                if (!isBlockBelowFireSource) {
                    if (!this.canNeighborCatchFire(worldIn, pos)) {
                        if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) || intAge > 3) {
                            worldIn.func_175698_g(pos);
                        }
                        return;
                    }
                    if (!this.canCatchFire((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) && intAge == 15 && rand.nextInt(4) == 0) {
                        worldIn.func_175698_g(pos);
                        return;
                    }
                }
                boolean isHumid = worldIn.func_180502_D(pos);
                int humidity = 0;
                if (isHumid) {
                    humidity = -50;
                }
                this.tryCatchFire(worldIn, pos.func_177974_f(), 300 + humidity, rand, intAge, EnumFacing.WEST);
                this.tryCatchFire(worldIn, pos.func_177976_e(), 300 + humidity, rand, intAge, EnumFacing.EAST);
                this.tryCatchFire(worldIn, pos.func_177977_b(), 250 + humidity, rand, intAge, EnumFacing.UP);
                this.tryCatchFire(worldIn, pos.func_177984_a(), 250 + humidity, rand, intAge, EnumFacing.DOWN);
                this.tryCatchFire(worldIn, pos.func_177978_c(), 300 + humidity, rand, intAge, EnumFacing.SOUTH);
                this.tryCatchFire(worldIn, pos.func_177968_d(), 300 + humidity, rand, intAge, EnumFacing.NORTH);
                for (int k = -1; k <= 1; ++k) {
                    for (int l = -1; l <= 1; ++l) {
                        for (int i1 = -1; i1 <= 4; ++i1) {
                            BlockPos blockpos;
                            int k1;
                            if (k == 0 && i1 == 0 && l == 0) continue;
                            int j1 = 100;
                            if (i1 > 1) {
                                j1 += (i1 - 1) * 100;
                            }
                            if ((k1 = this.getNeighborEncouragement(worldIn, blockpos = pos.func_177982_a(k, i1, l))) <= 0) continue;
                            int l1 = (k1 + 40 + worldIn.func_175659_aa().func_151525_a() * 7) / (intAge + 30);
                            if (isHumid) {
                                l1 /= 2;
                            }
                            if (l1 <= 0 || rand.nextInt(j1) > l1 || worldIn.func_72896_J() && this.func_176537_d(worldIn, blockpos)) continue;
                            int i2 = intAge + rand.nextInt(5) / 4;
                            if (i2 > 15) {
                                i2 = 15;
                            }
                            worldIn.func_180501_a(blockpos, state.func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(i2)), 3);
                        }
                    }
                }
            }
        }
    }

    private boolean canNeighborCatchFire(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.canCatchFire((IBlockAccess)worldIn, pos.func_177972_a(enumfacing), enumfacing.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(World worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos)) {
            return 0;
        }
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            i = Math.max(worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c().getFireSpreadSpeed((IBlockAccess)worldIn, pos.func_177972_a(enumfacing), enumfacing.func_176734_d()), i);
        }
        return i;
    }

    private void tryCatchFire(World worldIn, BlockPos pos, int chance, Random random, int age, EnumFacing face) {
        int i = worldIn.func_180495_p(pos).func_177230_c().getFlammability((IBlockAccess)worldIn, pos, face);
        if (random.nextInt(chance) < i && worldIn.func_175623_d(pos)) {
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            if (random.nextInt(age + 10) < 5 && !worldIn.func_175727_C(pos)) {
                int j = age + random.nextInt(5) / 4;
                if (j > 15) {
                    j = 15;
                }
                worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(j)), 3);
            }
            if (iblockstate.func_177230_c() == Blocks.field_150335_W) {
                Blocks.field_150335_W.func_176206_d(worldIn, pos, iblockstate.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)));
            }
        }
    }
}

