/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.core;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.core.BaseTESR;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class BaseMachineTESR<T extends TileEntityBaseMachineInvo>
extends BaseTESR<T> {
    protected int itemSlotAbove = -1;

    public BaseMachineTESR(Block res, int slot) {
        super(res);
        this.itemSlotAbove = slot;
    }

    public BaseMachineTESR(int slot) {
        this(null, slot);
    }

    public BaseMachineTESR() {
        this(null, -1);
    }

    public abstract void renderBasic(TileEntityBaseMachineInvo var1);

    public void render(TileEntityBaseMachineInvo te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179101_C();
        if (te.isRunning()) {
            this.renderBasic(te);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    protected void renderAnimation(@Nonnull TileEntityBaseMachineInvo te) {
        if (Minecraft.func_71410_x() == null || Minecraft.func_71410_x().func_175602_ab() == null || Minecraft.func_71410_x().func_175602_ab().func_175019_b() == null || this.getBakedModel() == null) {
            ModCyclic.logger.error("TESR render animation caught by null check");
            return;
        }
        GlStateManager.func_179094_E();
        EnumFacing facing = te.getCurrentFacing();
        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
        }
        double currTenthOfSec = System.currentTimeMillis() / 100L;
        double ratio = currTenthOfSec % 8.0 / 10.0;
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-1.0 * ratio));
        RenderHelper.func_74518_a();
        this.func_147499_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        World world = te.func_145831_w();
        try {
            GlStateManager.func_179109_b((float)(-te.func_174877_v().func_177958_n()), (float)(-te.func_174877_v().func_177956_o()), (float)(-te.func_174877_v().func_177952_p()));
            Tessellator tessellator = Tessellator.func_178181_a();
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)world, this.getBakedModel(), world.func_180495_p(te.func_174877_v()), te.func_174877_v(), Tessellator.func_178181_a().func_178180_c(), false);
            tessellator.func_78381_a();
        }
        catch (IllegalStateException alreadyBuilding) {
            ModCyclic.logger.info("Already building!  BufferBuilder:isDrawing == true I suppose: " + alreadyBuilding.getMessage());
        }
        catch (Exception e) {
            ModCyclic.logger.error("TESR render baked model exception", e);
        }
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }
}

