/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.beaconpotion;

import com.google.common.collect.Lists;
import com.lothrazar.cyclicmagic.block.beaconempty.BeamSegment;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBeaconPotion
extends TileEntityBaseMachineInvo
implements ITickable,
ITileRedstoneToggle {
    static final int MAX_POTION = 16000;
    private static final int POTION_TICKS = 400;
    private static final int MAX_RADIUS = 8;
    static boolean doesConsumePotions;
    static List<String> blacklist;
    @SideOnly(value=Side.CLIENT)
    private long beamRenderCounter;
    @SideOnly(value=Side.CLIENT)
    private float beamRenderScale;
    private EntityType entityType = EntityType.PLAYERS;
    private final List<BeamSegment> beamSegments = Lists.newArrayList();
    private String customName;
    @Nullable
    private List<PotionEffect> effects;
    private int needsRedstone;
    private int radius = 6;

    public TileEntityBeaconPotion() {
        super(9);
        this.setSetRenderGlobally(true);
        this.timer = 0;
        this.setSlotsForBoth();
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        this.shiftAllUp(1);
        if (this.timer == 0) {
            this.effects = new ArrayList<PotionEffect>();
            ItemStack s = this.func_70301_a(0);
            List newEffects = PotionUtils.func_185189_a((ItemStack)s);
            if (newEffects != null && newEffects.size() > 0) {
                this.effects = new ArrayList<PotionEffect>();
                if (this.isPotionValid(newEffects)) {
                    for (PotionEffect eff : newEffects) {
                        this.effects.add(new PotionEffect(eff.func_188419_a(), 400, eff.func_76458_c(), true, false));
                    }
                    this.timer = 16000;
                    if (doesConsumePotions) {
                        this.func_70299_a(0, ItemStack.field_190927_a);
                    }
                }
            }
        } else if (this.field_145850_b.func_82737_E() % 80L == 0L) {
            this.updateTimerIsZero();
            this.updateBeacon();
            this.field_145850_b.func_175641_c(this.field_174879_c, (Block)Blocks.field_150461_bJ, 1, 0);
        }
    }

    private boolean isPotionValid(List<PotionEffect> newEffects) {
        for (PotionEffect eff : newEffects) {
            String id = eff.func_188419_a().getRegistryName().toString();
            for (String match : blacklist) {
                if (!id.equals(match)) continue;
                return false;
            }
        }
        return true;
    }

    public void updateBeacon() {
        if (this.field_145850_b != null) {
            this.updateSegmentColors();
            this.addEffectsToEntities();
        }
    }

    public String getFirstEffectName() {
        if (this.effects == null || this.effects.size() == 0) {
            return "";
        }
        return this.effects.get(0).func_76453_d();
    }

    private void addEffectsToEntities() {
        if (this.effects == null || this.effects.size() == 0) {
            return;
        }
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        int theRadius = (int)Math.pow(2.0, this.radius);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_186662_g((double)theRadius).func_72321_a(0.0, (double)this.field_145850_b.func_72800_K(), 0.0);
        boolean skipPlayers = this.entityType == EntityType.NONPLAYER;
        boolean showParticles = this.entityType == EntityType.PLAYERS;
        EnumCreatureType creatureType = this.getCreatureType();
        ArrayList list = new ArrayList();
        if (this.entityType == EntityType.PLAYERS) {
            list.addAll(this.field_145850_b.func_72872_a(EntityPlayer.class, axisalignedbb));
        } else {
            list.addAll(this.field_145850_b.func_72872_a(EntityLivingBase.class, axisalignedbb));
        }
        for (EntityLivingBase entity : list) {
            if (skipPlayers && entity instanceof EntityPlayer || creatureType != null && !entity.isCreatureType(creatureType, false)) continue;
            for (PotionEffect eff : this.effects) {
                if (entity.func_70660_b(eff.func_188419_a()) != null) {
                    entity.func_70660_b(eff.func_188419_a()).func_76452_a(eff);
                    continue;
                }
                entity.func_70690_d(new PotionEffect(eff.func_188419_a(), 400, eff.func_76458_c(), true, showParticles));
            }
        }
    }

    private EnumCreatureType getCreatureType() {
        switch (this.entityType) {
            case AMBIENT: {
                return EnumCreatureType.AMBIENT;
            }
            case CREATURE: {
                return EnumCreatureType.CREATURE;
            }
            case MONSTER: {
                return EnumCreatureType.MONSTER;
            }
            case WATER: {
                return EnumCreatureType.WATER_CREATURE;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSegmentColors() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        this.beamSegments.clear();
        BeamSegment tileentitybeacon$beamsegment = new BeamSegment(EnumDyeColor.WHITE.func_193349_f());
        this.beamSegments.add(tileentitybeacon$beamsegment);
        boolean flag = true;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i1 = j + 1;
        while (i1 < 256) {
            block9: {
                float[] afloat;
                block6: {
                    IBlockState iblockstate;
                    block7: {
                        block8: {
                            block5: {
                                iblockstate = this.field_145850_b.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(i, i1, k));
                                if (iblockstate.func_177230_c() != Blocks.field_150399_cn) break block5;
                                afloat = ((EnumDyeColor)iblockstate.func_177229_b((IProperty)BlockStainedGlass.field_176547_a)).func_193349_f();
                                break block6;
                            }
                            if (iblockstate.func_177230_c() == Blocks.field_150397_co) break block7;
                            if (iblockstate.getLightOpacity((IBlockAccess)this.field_145850_b, (BlockPos)blockpos$mutableblockpos) >= 15 && iblockstate.func_177230_c() != Blocks.field_150357_h) {
                                this.beamSegments.clear();
                                return;
                            }
                            float[] customColor = iblockstate.func_177230_c().getBeaconColorMultiplier(iblockstate, this.field_145850_b, (BlockPos)blockpos$mutableblockpos, this.func_174877_v());
                            if (customColor == null) break block8;
                            afloat = customColor;
                            break block6;
                        }
                        tileentitybeacon$beamsegment.incrementHeight();
                        break block9;
                    }
                    afloat = ((EnumDyeColor)iblockstate.func_177229_b((IProperty)BlockStainedGlassPane.field_176245_a)).func_193349_f();
                }
                if (!flag) {
                    afloat = new float[]{(tileentitybeacon$beamsegment.getColors()[0] + afloat[0]) / 2.0f, (tileentitybeacon$beamsegment.getColors()[1] + afloat[1]) / 2.0f, (tileentitybeacon$beamsegment.getColors()[2] + afloat[2]) / 2.0f};
                }
                if (Arrays.equals(afloat, tileentitybeacon$beamsegment.getColors())) {
                    tileentitybeacon$beamsegment.incrementHeight();
                } else {
                    tileentitybeacon$beamsegment = new BeamSegment(afloat);
                    this.beamSegments.add(tileentitybeacon$beamsegment);
                }
                flag = false;
            }
            ++i1;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<BeamSegment> getBeamSegments() {
        return this.beamSegments;
    }

    @SideOnly(value=Side.CLIENT)
    public float shouldBeamRender() {
        if (!this.isRunning()) {
            return 0.0f;
        }
        int i = (int)(this.field_145850_b.func_82737_E() - this.beamRenderCounter);
        this.beamRenderCounter = this.field_145850_b.func_82737_E();
        if (i > 1) {
            this.beamRenderScale -= (float)i / 40.0f;
            if (this.beamRenderScale < 0.0f) {
                this.beamRenderScale = 0.0f;
            }
        }
        this.beamRenderScale += 0.025f;
        if (this.beamRenderScale > 1.0f) {
            this.beamRenderScale = 1.0f;
        }
        return this.beamRenderScale;
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    @Nullable
    private static Potion isBeaconEffect(int i) {
        return Potion.func_188412_a((int)i);
    }

    @Override
    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setName(String name) {
        this.customName = name;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemPotion;
    }

    @Override
    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.updateBeacon();
            return true;
        }
        return super.func_145842_c(id, type);
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
            case FUELMAX: {
                return 16000;
            }
            case ENTITYTYPE: {
                return this.entityType.ordinal();
            }
            case RANGE: {
                return this.radius;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case FUELMAX: {
                break;
            }
            case ENTITYTYPE: {
                if (value >= EntityType.values().length) {
                    value = 0;
                }
                if (value < 0) {
                    value = EntityType.values().length - 1;
                }
                this.entityType = EntityType.values()[value];
                break;
            }
            case RANGE: {
                this.radius = value > 8 ? 3 : Math.min(value, 8);
            }
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        this.func_174885_b(Fields.REDSTONE.ordinal(), (this.needsRedstone + 1) % 2);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.radius = tagCompound.func_74762_e("radius");
        this.needsRedstone = tagCompound.func_74762_e("red");
        int eType = tagCompound.func_74762_e("et");
        NBTTagList tagList = tagCompound.func_150295_c("potion_list", 10);
        this.effects = new ArrayList<PotionEffect>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            String potion = tag.func_74779_i("potion_effect");
            int strength = tag.func_74762_e("potion_strength");
            Potion p = Potion.func_180142_b((String)potion);
            if (p == null) continue;
            this.effects.add(new PotionEffect(p, 400, strength));
        }
        if (eType >= 0 && eType < EntityType.values().length) {
            this.entityType = EntityType.values()[eType];
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("radius", this.radius);
        tagCompound.func_74768_a("et", this.entityType.ordinal());
        tagCompound.func_74768_a("red", this.needsRedstone);
        NBTTagList itemList = new NBTTagList();
        if (this.effects != null) {
            for (PotionEffect e : this.effects) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("potion_effect", e.func_188419_a().getRegistryName().toString());
                tag.func_74768_a("potion_strength", e.func_76458_c());
                itemList.func_74742_a((NBTBase)tag);
            }
        }
        tagCompound.func_74782_a("potion_list", (NBTBase)itemList);
        return super.func_189515_b(tagCompound);
    }

    public EntityType getEntityType() {
        int type = this.func_174887_a_(Fields.ENTITYTYPE.ordinal());
        return EntityType.values()[type];
    }

    public int getRadiusCalc() {
        return (int)Math.pow(2.0, this.radius);
    }

    public static enum EntityType {
        PLAYERS,
        NONPLAYER,
        ALL,
        MONSTER,
        CREATURE,
        AMBIENT,
        WATER;

    }

    public static enum Fields {
        REDSTONE,
        TIMER,
        FUELMAX,
        ENTITYTYPE,
        RANGE;

    }
}

