/*
 * Decompiled with CFR 0.152.
 */
package shadows.deadly.gen;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import shadows.Apotheosis;
import shadows.deadly.config.DeadlyConfig;
import shadows.deadly.gen.WorldFeature;
import shadows.deadly.gen.WorldGenerator;
import shadows.ench.EnchModule;
import shadows.placebo.util.AttributeHelper;
import shadows.placebo.util.PlaceboUtil;
import shadows.util.ArmorSet;
import shadows.util.NameHelper;

public class BossItem
extends WorldFeature.WorldFeatureItem {
    public static final List<Potion> POTIONS = new ArrayList<Potion>();
    public static final List<Enchantment> BOW_ENCHANTMENTS = PlaceboUtil.asList((Object[])new Enchantment[]{Enchantments.field_185304_p, Enchantments.field_185307_s, Enchantments.field_185309_u, Enchantments.field_185310_v, Enchantments.field_185311_w, Enchantments.field_185312_x});
    public static final List<Enchantment> SWORD_ENCHANTMENTS = PlaceboUtil.asList((Object[])new Enchantment[]{Enchantments.field_185302_k, Enchantments.field_185303_l, Enchantments.field_180312_n, Enchantments.field_180313_o, Enchantments.field_77334_n, Enchantments.field_185304_p});
    public static final List<Enchantment> TOOL_ENCHANTMENTS = PlaceboUtil.asList((Object[])new Enchantment[]{Enchantments.field_185305_q, Enchantments.field_185306_r, Enchantments.field_185307_s, Enchantments.field_185308_t});
    public static final List<Enchantment> ARMOR_ENCHANTMENTS = PlaceboUtil.asList((Object[])new Enchantment[]{Enchantments.field_180310_c, Enchantments.field_185297_d, Enchantments.field_180309_e, Enchantments.field_185297_d, Enchantments.field_185297_d, Enchantments.field_185298_f, Enchantments.field_185299_g, Enchantments.field_92091_k, Enchantments.field_185307_s});
    public static final ArmorSet CHAIN_GEAR = new ArmorSet(0, Items.field_151052_q, Items.field_185159_cQ, Items.field_151029_X, Items.field_151022_W, Items.field_151023_V, Items.field_151020_U).addExtraMains(Items.field_151049_t, Items.field_151051_r, Items.field_151050_s);
    public static final ArmorSet GOLD_GEAR = new ArmorSet(1, Items.field_151010_B, Items.field_185159_cQ, Items.field_151151_aj, Items.field_151149_ai, Items.field_151171_ah, Items.field_151169_ag).addExtraMains(Items.field_151006_E, Items.field_151011_C, Items.field_151005_D);
    public static final ArmorSet IRON_GEAR = new ArmorSet(2, Items.field_151040_l, Items.field_185159_cQ, Items.field_151167_ab, Items.field_151165_aa, Items.field_151030_Z, Items.field_151028_Y).addExtraMains(Items.field_151036_c, Items.field_151037_a, Items.field_151035_b);
    public static final ArmorSet DIAMOND_GEAR = new ArmorSet(3, Items.field_151048_u, Items.field_185159_cQ, Items.field_151175_af, Items.field_151173_ae, Items.field_151163_ad, Items.field_151161_ac).addExtraMains(Items.field_151056_x, Items.field_151047_v, Items.field_151046_w);
    public static final Predicate<EntityAITasks.EntityAITaskEntry> IS_VILLAGER_ATTACK;
    protected final EntityEntry entityEntry;
    protected AxisAlignedBB entityAABB;

    public BossItem(int weight, ResourceLocation entity) {
        super(weight);
        this.entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(entity);
        Preconditions.checkNotNull((Object)this.entityEntry, (Object)("Invalid BossItem (not an entity) created with reloc: " + entity));
        if (!EntityLiving.class.isAssignableFrom(this.entityEntry.getEntityClass())) {
            throw new RuntimeException("Invalid BossItem (not an EntityLiving) created with class: " + this.entityEntry.getEntityClass());
        }
    }

    public AxisAlignedBB getAABB(World world) {
        if (this.entityAABB == null) {
            this.entityAABB = this.entityEntry.newInstance(world).func_70046_E();
        }
        if (this.entityAABB == null) {
            this.entityAABB = Block.field_185505_j;
        }
        return this.entityAABB;
    }

    @Override
    public void place(World world, BlockPos pos) {
        this.place(world, pos, world.field_73012_v);
    }

    public void place(World world, BlockPos pos, Random rand) {
        EntityLiving entity = (EntityLiving)this.entityEntry.newInstance(world);
        BossItem.initBoss(rand, entity);
        entity.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        entity.func_110163_bv();
        world.func_72838_d((Entity)entity);
        entity.field_70714_bg.field_75782_a.removeIf(IS_VILLAGER_ATTACK);
        for (BlockPos p : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-2, -1, -2), (BlockPos)pos.func_177982_a(2, 1, 2))) {
            world.func_180501_a(p, Blocks.field_150350_a.func_176223_P(), 2);
        }
        for (BlockPos p : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-2, -2, -2), (BlockPos)pos.func_177982_a(2, -2, 2))) {
            world.func_180501_a(p, Blocks.field_180395_cM.func_176223_P(), 2);
        }
        WorldGenerator.debugLog(pos, "Boss " + entity.func_70005_c_());
    }

    public static void initBoss(Random random, EntityLiving entity) {
        if (DeadlyConfig.bossRegenLevel > 0) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, DeadlyConfig.bossRegenLevel));
        }
        if (DeadlyConfig.bossResistLevel > 0) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, DeadlyConfig.bossResistLevel));
        }
        if (DeadlyConfig.bossFireRes) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76426_n, Integer.MAX_VALUE));
        }
        if (DeadlyConfig.bossWaterBreathing) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76427_o, Integer.MAX_VALUE));
        }
        AttributeHelper.addToBase((EntityLivingBase)entity, (IAttribute)SharedMonsterAttributes.field_111264_e, (String)"boss_damage_bonus", (double)DeadlyConfig.bossDamageBonus);
        AttributeHelper.multiplyFinal((EntityLivingBase)entity, (IAttribute)SharedMonsterAttributes.field_111267_a, (String)"boss_health_mult", (double)(DeadlyConfig.bossHealthMultiplier - 1.0f));
        AttributeHelper.max((EntityLivingBase)entity, (IAttribute)SharedMonsterAttributes.field_111266_c, (String)"boss_knockback_resist", (double)DeadlyConfig.bossKnockbackResist);
        AttributeHelper.multiplyFinal((EntityLivingBase)entity, (IAttribute)SharedMonsterAttributes.field_111263_d, (String)"boss_speed_mult", (double)(DeadlyConfig.bossSpeedMultiplier - 1.0f));
        entity.func_70606_j(entity.func_110138_aP());
        String name = NameHelper.setEntityName(random, entity);
        entity.func_110163_bv();
        int level = 0;
        for (int i = 0; i < ArmorSet.SORTED_SETS.size() - 1; ++i) {
            if (!(random.nextDouble() < (double)DeadlyConfig.bossLevelUpChance)) continue;
            ++level;
        }
        ArmorSet.SORTED_SETS.get(level).apply((EntityLivingBase)entity);
        if (entity instanceof EntitySkeleton) {
            entity.func_184611_a(EnumHand.MAIN_HAND, new ItemStack((Item)Items.field_151031_f));
        }
        int guaranteed = random.nextInt(6);
        ItemStack stack = entity.func_184582_a(EntityEquipmentSlot.values()[guaranteed]);
        while (guaranteed == 1 || stack.func_190926_b()) {
            guaranteed = random.nextInt(6);
            stack = entity.func_184582_a(EntityEquipmentSlot.values()[guaranteed]);
        }
        for (EntityEquipmentSlot s : EntityEquipmentSlot.values()) {
            if (s.ordinal() == guaranteed) {
                entity.func_184642_a(s, 2.0f);
            } else {
                entity.func_184642_a(s, ThreadLocalRandom.current().nextFloat());
            }
            ItemStack enchantedItem = stack;
            if (s.ordinal() == guaranteed) {
                List<Enchantment> enchants = EquipmentType.getTypeForStack(stack).getEnchants();
                Enchantment enchantment = enchants.get(random.nextInt(enchants.size()));
                if (enchants.stream().anyMatch(e -> e.func_92089_a(enchantedItem))) {
                    while (!enchantment.func_92089_a(stack)) {
                        enchantment = enchants.get(random.nextInt(enchants.size()));
                    }
                }
                NameHelper.setItemName(random, stack, name, enchantment);
                for (int i = 0; i < 5; ++i) {
                    BossItem.addSingleEnchantment(stack, random, 28 + (Apotheosis.enableEnch ? 10 : 3) * i, true);
                }
                Map enchMap = EnchantmentHelper.func_82781_a((ItemStack)stack);
                for (Enchantment e2 : enchMap.keySet()) {
                    enchMap.put(e2, Math.min(EnchModule.getMaxLevel(e2), (Integer)enchMap.get(e2) + random.nextInt(2)));
                }
                EnchantmentHelper.func_82782_a((Map)enchMap, (ItemStack)stack);
                BossItem.addSingleEnchantment(stack, random, Apotheosis.enableEnch ? 150 : 60, true);
                continue;
            }
            if (!(random.nextDouble() < (double)DeadlyConfig.bossEnchantChance)) continue;
            EnchantmentHelper.func_77504_a((Random)random, (ItemStack)stack, (int)(30 + random.nextInt(Apotheosis.enableEnch ? 50 : 25)), (boolean)true);
        }
        if (POTIONS.isEmpty()) {
            for (Potion p : ForgeRegistries.POTIONS) {
                if (!p.field_188415_h) continue;
                POTIONS.add(p);
            }
        }
        if (random.nextDouble() < (double)DeadlyConfig.bossPotionChance) {
            entity.func_70690_d(new PotionEffect(POTIONS.get(random.nextInt(POTIONS.size())), Integer.MAX_VALUE, random.nextInt(3) + 1));
        }
    }

    public static void addSingleEnchantment(ItemStack stack, Random rand, int level, boolean treasure) {
        List datas = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)stack, (int)level, (boolean)treasure);
        if (datas.isEmpty()) {
            return;
        }
        EnchantmentData d = (EnchantmentData)datas.get(rand.nextInt(datas.size()));
        stack.func_77966_a(d.field_76302_b, d.field_76303_c);
    }

    static {
        ArmorSet.LEVEL_TO_SETS.put(0, CHAIN_GEAR);
        ArmorSet.LEVEL_TO_SETS.put(1, GOLD_GEAR);
        ArmorSet.LEVEL_TO_SETS.put(2, IRON_GEAR);
        ArmorSet.LEVEL_TO_SETS.put(3, DIAMOND_GEAR);
        IS_VILLAGER_ATTACK = a -> a.field_75733_a instanceof EntityAINearestAttackableTarget && ObfuscationReflectionHelper.getPrivateValue(EntityAINearestAttackableTarget.class, (Object)((EntityAINearestAttackableTarget)a.field_75733_a), (String[])new String[]{"targetClass", "field_75307_b"}) == EntityVillager.class;
    }

    public static enum EquipmentType {
        SWORD(SWORD_ENCHANTMENTS),
        BOW(BOW_ENCHANTMENTS),
        TOOL(TOOL_ENCHANTMENTS),
        ARMOR(ARMOR_ENCHANTMENTS);

        final List<Enchantment> enchants;

        private EquipmentType(List<Enchantment> enchants) {
            this.enchants = enchants;
        }

        public List<Enchantment> getEnchants() {
            return this.enchants;
        }

        public static EquipmentType getTypeForStack(ItemStack stack) {
            Item i = stack.func_77973_b();
            if (i instanceof ItemSword) {
                return SWORD;
            }
            if (i instanceof ItemBow) {
                return BOW;
            }
            if (i instanceof ItemArmor || i instanceof ISpecialArmor) {
                return ARMOR;
            }
            return TOOL;
        }
    }
}

