/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.container.base.ContainerTile;
import fi.dy.masa.enderutilities.inventory.container.base.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.container.base.SlotRange;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.tileentity.TileEntityInserter;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ContainerInserter
extends ContainerTile {
    private final TileEntityInserter tef;
    private final IItemHandler invFilters;
    private SlotRange filterSlots = new SlotRange(0, 0);
    private int delayLast = -1;
    private int stackLimitLast = -1;
    private int filtersLast = -1;
    private int redstoneLast = -1;

    public ContainerInserter(EntityPlayer player, TileEntityInserter te) {
        super(player, te);
        this.tef = te;
        this.invFilters = te.getFilterInventory();
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(8, te.isFiltered() ? 115 : 59);
    }

    @Override
    protected void addCustomInventorySlots() {
        int posX = 8;
        int posY = 47;
        this.customInventorySlots = new MergeSlotRange(this.field_75151_b.size(), 1);
        this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, 0, 80, 27));
        if (this.tef.isFiltered()) {
            this.filterSlots = new SlotRange(this.field_75151_b.size(), 27);
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 9; ++column) {
                    this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.invFilters, row * 9 + column, posX + column * 18, posY + row * 18));
                }
            }
        }
    }

    @Override
    public void func_75142_b() {
        int delay = this.tef.getUpdateDelay();
        int stackLimit = this.tef.getBaseItemHandler().getInventoryStackLimit();
        int filters = this.tef.getFilterMask();
        int redstone = this.tef.getRedstoneModeIntValue();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            if (delay != this.delayLast) {
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 0, delay & 0xFFFF);
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 1, delay >>> 16 & 0xFFFF);
            }
            if (stackLimit != this.stackLimitLast) {
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 2, stackLimit);
            }
            if (filters != this.filtersLast) {
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 3, filters);
            }
            if (redstone == this.redstoneLast) continue;
            ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 4, redstone);
        }
        this.delayLast = delay;
        this.stackLimitLast = stackLimit;
        this.filtersLast = filters;
        this.redstoneLast = redstone;
        super.func_75142_b();
    }

    @Override
    public void func_75137_b(int id, int data) {
        super.func_75137_b(id, data);
        switch (id) {
            case 0: {
                data = this.tef.getUpdateDelay() & 0xFFFF0000 | data;
                this.tef.setUpdateDelay(data);
                break;
            }
            case 1: {
                data = this.tef.getUpdateDelay() & 0xFFFF | data << 16;
                this.tef.setUpdateDelay(data);
                break;
            }
            case 2: {
                this.tef.setStackLimit(data);
                break;
            }
            case 3: {
                this.tef.setFilterMask(data);
                break;
            }
            case 4: {
                this.tef.setRedstoneModeFromInteger(data);
            }
        }
    }

    protected boolean fakeSlotClick(int slotNum, int button, ClickType clickType, EntityPlayer player) {
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        ItemStack stackCursor = player.field_71071_by.func_70445_o();
        if (!(clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE || button != 0 && button != 1)) {
            if (slot == null || slot.getItemHandler() != this.invFilters) {
                return false;
            }
            if (!stackCursor.func_190926_b()) {
                ItemStack stackTmp = stackCursor.func_77946_l();
                stackTmp.func_190920_e(1);
                slot.insertItem(stackTmp, false);
            } else {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            return true;
        }
        if (this.isDragging) {
            if (clickType == ClickType.QUICK_CRAFT && (button == 2 || button == 6)) {
                if (!stackCursor.func_190926_b()) {
                    ItemStack stackTmp = stackCursor.func_77946_l();
                    stackTmp.func_190920_e(1);
                    Iterator iterator = this.draggedSlots.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        SlotItemHandlerGeneric slotTmp = this.getSlotItemHandler(i);
                        if (slotTmp == null || slotTmp.getItemHandler() != this.invFilters) continue;
                        slotTmp.insertItem(stackTmp.func_77946_l(), false);
                    }
                }
                this.isDragging = false;
            } else if (clickType == ClickType.QUICK_CRAFT && (button == 1 || button == 5)) {
                this.draggedSlots.add(slotNum);
            }
        } else if (clickType == ClickType.QUICK_CRAFT && (button == 0 || button == 4)) {
            this.isDragging = true;
            this.draggingRightClick = button == 4;
            this.draggedSlots.clear();
        }
        return false;
    }

    @Override
    public ItemStack func_184996_a(int slotNum, int dragType, ClickType clickType, EntityPlayer player) {
        if (this.tef.isFiltered()) {
            if (this.filterSlots.contains(slotNum)) {
                this.fakeSlotClick(slotNum, dragType, clickType, player);
                return ItemStack.field_190927_a;
            }
            if (clickType == ClickType.QUICK_CRAFT && slotNum == -999) {
                Iterator iterator = this.draggedSlots.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    if (!this.filterSlots.contains(i)) continue;
                    this.fakeSlotClick(i, dragType, clickType, player);
                    return ItemStack.field_190927_a;
                }
            }
        }
        return super.func_184996_a(slotNum, dragType, clickType, player);
    }
}

