/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFloor
extends BlockEnderUtilities {
    public static final AxisAlignedBB BOUNDS_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    public static final AxisAlignedBB BOUNDS_TOP = new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0);
    public static final PropertyEnum<EnumHalf> HALF = PropertyEnum.func_177709_a((String)"half", EnumHalf.class);
    public static final PropertyEnum<FloorType> TYPE = PropertyEnum.func_177709_a((String)"type", FloorType.class);

    public BlockFloor(String name, float hardness, float resistance, int harvestLevel, Material material) {
        super(name, hardness, resistance, harvestLevel, material);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(HALF, (Comparable)((Object)EnumHalf.TOP)).func_177226_a(TYPE, (Comparable)((Object)FloorType.NORMAL)));
        this.func_149672_a(SoundType.field_185848_a);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF, TYPE});
    }

    @Override
    protected String[] generateUnlocalizedNames() {
        return new String[]{"floor", "floor_cracked"};
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return ((FloorType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumHalf.fromMeta(meta))).func_177226_a(TYPE, (Comparable)((Object)FloorType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((FloorType)((Object)state.func_177229_b(TYPE))).getMeta() | ((EnumHalf)((Object)state.func_177229_b(HALF))).getMeta();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (facing != EnumFacing.UP && hitY > 0.5f) {
            state = state.func_177226_a(HALF, (Comparable)((Object)EnumHalf.TOP));
        }
        return state;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return ((EnumHalf)((Object)state.func_177229_b(HALF))).equals((Object)EnumHalf.BOTTOM) ? BOUNDS_BOTTOM : BOUNDS_TOP;
    }

    @Deprecated
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (state.func_177229_b(TYPE) == FloorType.CRACKED) {
            if (!(entityIn instanceof EntityItem) && !(entityIn instanceof EntityXPOrb)) {
                BlockFloor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185890_d((IBlockAccess)worldIn, pos));
            }
        } else {
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, p_185477_7_);
        }
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < FloorType.values().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, FloorType.values()[i].getMeta()));
        }
    }

    public static enum FloorType implements IStringSerializable
    {
        NORMAL(0, "normal"),
        CRACKED(1, "cracked");

        private final String name;
        private final int meta;

        private FloorType(int meta, String name) {
            this.name = name;
            this.meta = meta;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static FloorType fromMeta(int meta) {
            return FloorType.values()[meta & 3];
        }
    }

    public static enum EnumHalf implements IStringSerializable
    {
        BOTTOM(0, "bottom"),
        TOP(8, "top");

        private final String name;
        private final int meta;

        private EnumHalf(int meta, String name) {
            this.name = name;
            this.meta = meta;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumHalf fromMeta(int meta) {
            return EnumHalf.values()[(meta & 8) >>> 3];
        }
    }
}

