/*
 * Decompiled with CFR 0.152.
 */
package de.errorcraftlp.cryingobsidian;

import de.errorcraftlp.cryingobsidian.CryingObsidianConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Utils {
    public static final String ID = "cryingobsidian";
    public static final String NAME = "Crying Obsidian";
    public static final String VERSION = "1.1.3";
    public static final String CLIENT_PROXY = "de.errorcraftlp.cryingobsidian.proxy.ClientProxy";
    public static final String SERVER_PROXY = "de.errorcraftlp.cryingobsidian.proxy.ServerProxy";
    public static final String UPDATE_JSON = "https://raw.githubusercontent.com/ErrorCraftLP/Crying-Obsidian/master/version.json";
    public static final String ACCEPTED_VERSIONS = "[1.12,1.12.1]";
    public static final String DEPENDENCIES = "required-after:forge@[14.21.1.2387,);";

    public static void setSpawnPointAtPlayer(World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            BlockPos playerPos = player.func_180425_c();
            if (player.func_70090_H()) {
                BlockPos correctedPos = new BlockPos(playerPos.func_177958_n(), world.func_181545_F(), playerPos.func_177952_p());
                player.func_180473_a(correctedPos, true);
                player.setSpawnDimension(Integer.valueOf(player.field_71093_bK));
            } else {
                player.func_180473_a(playerPos, true);
                player.setSpawnDimension(Integer.valueOf(player.field_71093_bK));
            }
            if (CryingObsidianConfig.enableChatMessage) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.spawnpoint_set", new Object[]{player.func_145748_c_(), playerPos.func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p()}));
            }
        }
    }

    public static void setSpawnPointAtBlock(World world, EntityPlayer player, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockPos correctedPos1 = pos.func_177984_a();
            BlockPos correctedPos2 = pos.func_177981_b(2);
            BlockPos correctedPos3 = pos.func_177977_b();
            IBlockState stateAtCorrectedPos1 = world.func_180495_p(correctedPos1);
            IBlockState stateAtCorrectedPos2 = world.func_180495_p(correctedPos2);
            IBlockState stateAtCorrectedPos3 = world.func_180495_p(correctedPos3);
            while (Utils.hasNoPlace(correctedPos1, stateAtCorrectedPos1, world) || Utils.hasNoPlace(correctedPos2, stateAtCorrectedPos2, world) || Utils.isDangerous(stateAtCorrectedPos3)) {
                correctedPos1 = correctedPos1.func_177984_a();
                correctedPos2 = correctedPos1.func_177984_a();
                correctedPos3 = correctedPos1.func_177977_b();
                stateAtCorrectedPos1 = world.func_180495_p(correctedPos1);
                stateAtCorrectedPos2 = world.func_180495_p(correctedPos2);
                stateAtCorrectedPos3 = world.func_180495_p(correctedPos3);
            }
            player.func_180473_a(correctedPos1, true);
            player.setSpawnDimension(Integer.valueOf(player.field_71093_bK));
            if (CryingObsidianConfig.enableChatMessage) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.spawnpoint_set", new Object[]{player.func_145748_c_(), correctedPos1.func_177958_n(), correctedPos1.func_177956_o(), correctedPos1.func_177952_p()}));
            }
        }
    }

    public static boolean hasNoPlace(BlockPos pos, IBlockState state, World world) {
        Block block = state.func_177230_c();
        return !block.isAir(state, (IBlockAccess)world, pos);
    }

    public static boolean isDangerous(IBlockState state) {
        Block block = state.func_177230_c();
        return block.equals(Blocks.field_150353_l) || block.equals(Blocks.field_150356_k) || block.equals(Blocks.field_150480_ab);
    }
}

