/*
 * Decompiled with CFR 0.152.
 */
package terrails.statskeeper.event;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import terrails.statskeeper.api.capabilities.IHealth;
import terrails.statskeeper.api.capabilities.SKCapabilities;
import terrails.statskeeper.config.configs.SKHealthConfig;

public class HealthEventHandler {
    private static final UUID STATS_KEEPER_HEALTH_UUID = UUID.fromString("b4720be1-df42-4347-9625-34152fb82b3f");

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        IHealth health = SKCapabilities.getCapability(player);
        if (SKHealthConfig.enabled) {
            if (!health.isHealthEnabled() || this.hasConfigChanged(player)) {
                this.clearHealthData(player);
                this.setHealth(player, Operation.STARTING);
            } else {
                this.updateThreshold(player);
                if (!this.hasModifier(player)) {
                    this.setAdditionalHealth(player, health.getAdditionalHealth());
                }
                if (health.getCurrentThreshold() > 0 && this.getCurrentHealth(player) < health.getCurrentThreshold()) {
                    this.setHealth(player, Operation.THRESHOLD);
                } else if (this.getCurrentHealth(player) < SKHealthConfig.min_health) {
                    this.setHealth(player, Operation.MIN);
                } else if (this.getCurrentHealth(player) > SKHealthConfig.max_health) {
                    this.setHealth(player, Operation.MAX);
                } else if (this.getCurrentHealth(player) < SKHealthConfig.max_health && SKHealthConfig.min_health <= 0) {
                    this.setHealth(player, Operation.MAX);
                }
            }
        } else if (this.hasModifier(player)) {
            this.removeModifier(player);
            player.func_70606_j(player.func_110138_aP());
        }
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        if (SKHealthConfig.enabled) {
            EntityPlayer player = event.getEntityPlayer();
            IHealth oldHealth = SKCapabilities.getCapability(event.getOriginal());
            IHealth health = SKCapabilities.getCapability(player);
            if (!oldHealth.isHealthEnabled()) {
                return;
            }
            if (SKHealthConfig.starting_health == SKHealthConfig.max_health && SKHealthConfig.min_health <= 0) {
                this.setHealth(player, Operation.MAX);
                return;
            }
            this.setHealth(player, Operation.SAVE);
            health.setAdditionalHealth(oldHealth.getAdditionalHealth());
            health.setCurrentThreshold(oldHealth.getCurrentThreshold());
            this.updateThreshold(player);
            if (event.isWasDeath() && SKHealthConfig.health_decrease > 0 && SKHealthConfig.min_health > 0 && this.getCurrentHealth(player) > Math.abs(health.getCurrentThreshold())) {
                this.setHealth(player, Operation.REMOVE);
                double removedAmount = oldHealth.getAdditionalHealth() - health.getAdditionalHealth();
                if (SKHealthConfig.health_message && removedAmount > 0.0) {
                    this.playerMessage(player, "health.statskeeper.death_remove", removedAmount);
                }
            } else {
                this.setAdditionalHealth(player, oldHealth.getAdditionalHealth());
            }
        }
    }

    @SubscribeEvent
    public void itemUseFinished(LivingEntityUseItemEvent.Finish event) {
        if (!SKHealthConfig.enabled || !(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        for (SKHealthConfig.HealthItem healthItem : SKHealthConfig.health_items) {
            if (healthItem.getItem() != event.getItem().func_77973_b() || healthItem.getMeta() != event.getItem().func_77960_j() && healthItem.getMeta() != Short.MAX_VALUE) continue;
            this.addHealth((EntityPlayer)event.getEntityLiving(), healthItem.getHealthAmount());
            break;
        }
    }

    @SubscribeEvent
    public void itemUse(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_175149_v() || event.getWorld().field_72995_K) {
            return;
        }
        if (!SKHealthConfig.enabled) {
            return;
        }
        ItemStack stack = player.func_184586_b(event.getHand());
        if (stack.func_77973_b() instanceof ItemFood && player.func_71043_e(this.isItemFoodAlwaysEdible((ItemFood)stack.func_77973_b()))) {
            return;
        }
        if (stack.func_77975_n() == EnumAction.DRINK) {
            return;
        }
        for (SKHealthConfig.HealthItem healthItem : SKHealthConfig.health_items) {
            if (healthItem.getItem() != stack.func_77973_b() || healthItem.getMeta() != stack.func_77960_j() && healthItem.getMeta() != Short.MAX_VALUE) continue;
            if (!this.addHealth(player, healthItem.getHealthAmount())) break;
            stack.func_190918_g(1);
            return;
        }
    }

    private boolean isItemFoodAlwaysEdible(ItemFood item) {
        return (Boolean)ObfuscationReflectionHelper.getPrivateValue(ItemFood.class, (Object)item, (String)"field_77852_bZ");
    }

    private void setHealth(EntityPlayer player, Operation type) {
        IHealth health = SKCapabilities.getCapability(player);
        int baseHealth = (int)this.getAttribute(player).func_111125_b();
        health.setHealthEnabled(true);
        switch (type) {
            case STARTING: {
                health.setStartingHealth(SKHealthConfig.starting_health);
                this.setAdditionalHealth(player, SKHealthConfig.starting_health - baseHealth);
                this.setHealth(player, Operation.SAVE);
                break;
            }
            case MAX: {
                health.setMaxHealth(SKHealthConfig.max_health);
                this.setAdditionalHealth(player, SKHealthConfig.max_health - baseHealth);
                this.setHealth(player, Operation.SAVE);
                break;
            }
            case MIN: {
                health.setMinHealth(SKHealthConfig.min_health);
                this.setAdditionalHealth(player, SKHealthConfig.min_health - baseHealth);
                this.setHealth(player, Operation.SAVE);
                break;
            }
            case THRESHOLD: {
                this.setAdditionalHealth(player, health.getCurrentThreshold() - baseHealth);
                this.setHealth(player, Operation.SAVE);
                break;
            }
            case REMOVE: {
                health.setMaxHealth(SKHealthConfig.max_health);
                health.setMinHealth(SKHealthConfig.min_health);
                int min_health = Math.max(SKHealthConfig.min_health, Math.abs(health.getCurrentThreshold()));
                int removedHealth = this.getCurrentHealth(player) - SKHealthConfig.health_decrease;
                int addedHealth = Math.max(removedHealth, min_health) - baseHealth;
                this.setAdditionalHealth(player, addedHealth);
                this.setHealth(player, Operation.SAVE);
                break;
            }
            case SAVE: {
                health.setMaxHealth(SKHealthConfig.max_health);
                health.setMinHealth(SKHealthConfig.min_health);
                health.setStartingHealth(SKHealthConfig.starting_health);
            }
        }
    }

    private boolean addHealth(EntityPlayer player, int amount) {
        IHealth health = SKCapabilities.getCapability(player);
        if (amount > 0) {
            if (this.getCurrentHealth(player) >= SKHealthConfig.max_health) {
                return false;
            }
            if (this.getCurrentHealth(player) + amount > SKHealthConfig.max_health) {
                amount = SKHealthConfig.max_health - this.getCurrentHealth(player);
            }
        } else if (amount < 0) {
            if (this.getCurrentHealth(player) <= SKHealthConfig.min_health) {
                return false;
            }
            if (this.getCurrentHealth(player) + amount < SKHealthConfig.min_health) {
                amount = SKHealthConfig.min_health - this.getCurrentHealth(player);
            }
        }
        health.setAdditionalHealth(health.getAdditionalHealth() + amount);
        this.setAdditionalHealth(player, health.getAdditionalHealth());
        this.setHealth(player, Operation.SAVE);
        if (!this.updateThreshold(player)) {
            String key = amount > 0 ? "health.statskeeper.item_add" : "health.statskeeper.item_lose";
            this.playerMessage(player, key, Math.abs(amount));
        }
        return true;
    }

    private void setAdditionalHealth(EntityPlayer player, int value) {
        IHealth health = SKCapabilities.getCapability(player);
        this.removeModifier(player);
        health.setAdditionalHealth(value);
        this.addModifier(player, value);
        player.func_70606_j(player.func_110138_aP());
    }

    private boolean hasConfigChanged(EntityPlayer player) {
        IHealth health = SKCapabilities.getCapability(player);
        for (String string : SKHealthConfig.on_change_reset) {
            if ((string = string.toUpperCase()).equals("MIN_HEALTH") && SKHealthConfig.min_health != health.getMinHealth()) {
                return true;
            }
            if (string.equals("MAX_HEALTH") && SKHealthConfig.max_health != health.getMaxHealth()) {
                return true;
            }
            if (!string.equals("STARTING_HEALTH") || SKHealthConfig.starting_health == health.getStartingHealth()) continue;
            return true;
        }
        return false;
    }

    private int getCurrentHealth(EntityPlayer player) {
        IHealth health = SKCapabilities.getCapability(player);
        int baseHealth = (int)this.getAttribute(player).func_111125_b();
        return health.getAdditionalHealth() + baseHealth;
    }

    private boolean updateThreshold(EntityPlayer player) {
        IHealth health = SKCapabilities.getCapability(player);
        if (SKHealthConfig.health_thresholds.length == 0) {
            health.setCurrentThreshold(0);
            return false;
        }
        List thresholdList = Arrays.stream(SKHealthConfig.health_thresholds).boxed().collect(Collectors.toList());
        int oldThreshold = health.getCurrentThreshold();
        if (health.getCurrentThreshold() != 0 && !thresholdList.contains(health.getCurrentThreshold()) || this.getCurrentHealth(player) < health.getCurrentThreshold()) {
            Stream<Integer> stream = thresholdList.stream().filter(i -> Math.abs(i) <= this.getCurrentHealth(player));
            int value = stream.reduce((first, second) -> second).orElse((Integer)thresholdList.get(0));
            health.setCurrentThreshold(value);
        }
        for (int i2 : SKHealthConfig.health_thresholds) {
            if (health.getCurrentThreshold() == 0 && i2 < 0) {
                health.setCurrentThreshold(i2);
                break;
            }
            if (Math.abs(health.getCurrentThreshold()) >= Math.abs(i2) || this.getCurrentHealth(player) < Math.abs(i2)) continue;
            health.setCurrentThreshold(i2);
        }
        if (oldThreshold != health.getCurrentThreshold() && (oldThreshold != 0 || (Integer)thresholdList.get(0) > 0)) {
            this.playerMessage(player, "health.statskeeper.threshold", Math.abs(health.getCurrentThreshold()));
            return true;
        }
        return false;
    }

    private void clearHealthData(EntityPlayer player) {
        IHealth health = SKCapabilities.getCapability(player);
        health.setAdditionalHealth(0);
        health.setStartingHealth(0);
        health.setCurrentThreshold(0);
        health.setMinHealth(0);
        health.setMaxHealth(0);
        health.setHealthEnabled(false);
    }

    private IAttributeInstance getAttribute(EntityPlayer player) {
        return player.func_110148_a(SharedMonsterAttributes.field_111267_a);
    }

    private void addModifier(EntityPlayer player, int amount) {
        IAttributeInstance attribute = this.getAttribute(player);
        attribute.func_111121_a(new AttributeModifier(STATS_KEEPER_HEALTH_UUID, "stats_keeper", (double)amount, 0));
    }

    private void removeModifier(EntityPlayer player) {
        AttributeModifier modifier = this.getAttribute(player).func_111127_a(STATS_KEEPER_HEALTH_UUID);
        if (modifier != null) {
            this.getAttribute(player).func_111124_b(modifier);
        }
    }

    private boolean hasModifier(EntityPlayer player) {
        return this.getAttribute(player).func_111127_a(STATS_KEEPER_HEALTH_UUID) != null;
    }

    private void playerMessage(EntityPlayer player, String key, double health) {
        if (health == 0.0) {
            return;
        }
        double messageAmount = health / 2.0;
        TextComponentTranslation component = messageAmount % 1.0 != 0.0 ? new TextComponentTranslation(key, new Object[]{messageAmount}) : new TextComponentTranslation(key, new Object[]{(int)messageAmount});
        player.func_146105_b((ITextComponent)component, true);
    }

    private static enum Operation {
        STARTING,
        MAX,
        MIN,
        THRESHOLD,
        REMOVE,
        SAVE;

    }
}

