/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.item;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.util.RequesterReference;
import cofh.api.item.IMultiModeItem;
import cofh.core.item.ItemCore;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.render.IModelRegister;
import cofh.core.util.RayTracer;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.item.StackMap;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermalfoundation.item.ItemMaterial;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

public class ItemManager
extends ItemCore
implements IMultiModeItem,
IInitializer,
IModelRegister {
    public ItemManager(String name) {
        this.name = name;
        this.func_77655_b("logistics." + name);
        this.setRegistryName(name);
        this.func_77637_a(ThermalLogistics.INSTANCE.tab);
        this.func_77625_d(1);
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        stack.func_190919_e("Link");
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187750_dc, SoundCategory.PLAYERS, 0.6f, 0.4f + 0.2f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.logistics.manager.c." + this.getMode(stack), new Object[0]));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.logistics.manager.a.2"));
        tooltip.add(StringHelper.getNoticeText((String)("info.logistics.manager.a." + this.getMode(stack))));
        tooltip.add(StringHelper.localizeFormat((String)("info.logistics.manager.b." + this.getMode(stack)), (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        if (this.getMode(item) == 0) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileGrid) {
                TileGrid grid = (TileGrid)tile;
                int face = -1;
                RayTraceResult target = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (BlockPos)pos);
                if (target != null) {
                    int s = -1;
                    int subHit = target.subHit;
                    if (subHit < 6) {
                        s = subHit;
                    } else if (subHit >= 14 && subHit < 20) {
                        s = subHit - 14;
                    }
                    if (s != -1) {
                        face = (byte)s;
                    }
                }
                if (face == -1) {
                    return EnumActionResult.PASS;
                }
                DuctUnitItem duct = (DuctUnitItem)grid.getDuct(DuctToken.ITEMS);
                if (duct == null) {
                    return EnumActionResult.PASS;
                }
                if (world.field_72995_K) {
                    return EnumActionResult.SUCCESS;
                }
                StackMap map = (StackMap)((GridItem)duct.getGrid()).travelingItems.get(duct.pos().func_177972_a(EnumFacing.field_82609_l[face]));
                if (map == null || map.isEmpty()) {
                    ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.logistics.manager.e.2", new Object[0]));
                } else {
                    ArrayList<TextComponentTranslation> list = new ArrayList<TextComponentTranslation>();
                    list.add(new TextComponentTranslation("info.logistics.manager.e.0", new Object[0]));
                    for (ItemStack stack : map.getItems()) {
                        list.add(new TextComponentTranslation("info.logistics.manager.e.1", new Object[]{stack.func_190916_E(), stack.func_151000_E()}));
                    }
                    ChatHelper.sendIndexedChatMessagesToPlayer((EntityPlayer)player, list);
                }
                return EnumActionResult.SUCCESS;
            }
        } else {
            ICrafter crafter = null;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileGrid) {
                Attachment attachment;
                RayTraceResult raytrace = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (BlockPos)pos);
                if (raytrace != null && raytrace.subHit >= 14 && raytrace.subHit < 20 && (attachment = ((TileGrid)tile).getAttachment(raytrace.subHit - 14)) instanceof ICrafter) {
                    crafter = (ICrafter)attachment;
                }
            } else if (tile instanceof ICrafter) {
                crafter = (ICrafter)tile;
            }
            if (crafter == null) {
                return EnumActionResult.PASS;
            }
            if (world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            if (!item.func_77942_o()) {
                item.func_77982_d(new NBTTagCompound());
            }
            if (item.func_179543_a("Link") != null) {
                IRequester other = RequesterReference.readNBT(item.func_179543_a("Link")).getAttachment();
                if (other instanceof ICrafter && other != crafter) {
                    if (crafter.hasLinked((ICrafter)other)) {
                        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.logistics.manager.d.2", new Object[0]));
                    } else {
                        crafter.link((ICrafter)other, true);
                        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.logistics.manager.d.3", new Object[0]));
                    }
                } else if (other == crafter) {
                    ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.logistics.manager.d.4", new Object[0]));
                } else {
                    ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.logistics.manager.d.1", new Object[0]));
                }
                item.func_77978_p().func_82580_o("Link");
            } else {
                item.func_77978_p().func_74782_a("Link", (NBTBase)RequesterReference.writeNBT(crafter.getReference()));
                ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.logistics.manager.d.0", new Object[0]));
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean preInit() {
        return true;
    }

    public boolean initialize() {
        RecipeHelper.addShapedRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"iRi", "iCi", "iSi", Character.valueOf('i'), "nuggetIron", Character.valueOf('R'), Blocks.field_150429_aA, Character.valueOf('C'), ItemMaterial.partToolCasing, Character.valueOf('S'), "dustSulfur"});
        return true;
    }

    public void registerModels() {
        ModelResourceLocation location = new ModelResourceLocation("thermallogistics:" + this.name);
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)location);
    }
}

