/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.client.gui.tab;

import astavie.thermallogistics.util.StackHandler;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.init.CoreTextures;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.tileentity.TileEntity;

public class TabRequest
extends TabBase {
    private static final int HEIGHT = 18;
    private final List<?> list;
    private final TileEntity tile;
    private int num;
    private int max;
    private int first = 0;

    public TabRequest(GuiContainerCore gui, List<?> list, TileEntity tile) {
        this(gui, 1, list, tile);
    }

    public TabRequest(GuiContainerCore gui, int side, List<?> list, TileEntity tile) {
        super(gui, side);
        this.list = list;
        this.tile = tile;
        this.maxWidth = 88;
        this.maxHeight = 96;
        this.backgroundColor = -16744320;
        this.textColor = -1;
        this.num = Math.min((this.maxHeight - 24) / 18, list.size());
        this.max = list.size() - this.num;
    }

    public void update() {
        super.update();
        if (this.max != this.list.size() - this.num || this.num > this.list.size()) {
            this.num = Math.min((this.maxHeight - 24) / 18, this.list.size());
            this.max = this.list.size() - this.num;
            if (this.first > this.max) {
                this.first = this.max;
            }
        }
    }

    protected void drawForeground() {
        GlStateManager.func_179140_f();
        this.drawTabIcon(this.list.isEmpty() ? CoreTextures.ICON_RS_TORCH_OFF : CoreTextures.ICON_RS_TORCH_ON);
        if (!this.isFullyOpened()) {
            return;
        }
        int mouseX = this.gui.getMouseX() - this.posX();
        int mouseY = this.gui.getMouseY() - this.posY;
        if (this.first > 0) {
            this.gui.drawIcon(CoreTextures.ICON_ARROW_UP, this.sideOffset() + this.maxWidth - 20, 16);
        } else {
            this.gui.drawIcon(CoreTextures.ICON_ARROW_UP_INACTIVE, this.sideOffset() + this.maxWidth - 20, 16);
        }
        if (this.first < this.max) {
            this.gui.drawIcon(CoreTextures.ICON_ARROW_DOWN, this.sideOffset() + this.maxWidth - 20, 76);
        } else {
            this.gui.drawIcon(CoreTextures.ICON_ARROW_DOWN_INACTIVE, this.sideOffset() + this.maxWidth - 20, 76);
        }
        this.getFontRenderer().func_175063_a(this.getTitle(), (float)(this.sideOffset() + 18), 6.0f, this.headerColor);
        RenderHelper.func_74518_a();
        RenderHelper.func_74520_c();
        for (int i = this.first; i < this.first + this.num; ++i) {
            int x = this.sideOffset() + 2;
            int y = 21 + (i - this.first) * 18;
            StackHandler.render(this.gui, x, y, this.list.get(i), true);
            if (mouseX >= x + 53 && mouseX < x + 69 && mouseY >= y && mouseY < y + 16) {
                this.gui.drawIcon(CoreTextures.ICON_CANCEL, x + 53, y);
                continue;
            }
            this.gui.drawIcon(CoreTextures.ICON_CANCEL_INACTIVE, x + 53, y);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private String getTitle() {
        return StringHelper.localize((String)"info.logistics.tab.request");
    }

    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(this.getTitle());
        } else {
            int mouseX = this.gui.getMouseX() - this.posX();
            int mouseY = this.gui.getMouseY() - this.posY;
            for (int i = this.first; i < this.first + this.num; ++i) {
                int x = this.sideOffset() + 2;
                int y = 21 + (i - this.first) * 18;
                if (mouseX < x - 1 || mouseX >= x + 17 || mouseY < y - 1 || mouseY >= y + 17) continue;
                list.addAll(StackHandler.getTooltip(this.gui, this.list.get(i)));
            }
        }
    }

    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.isFullyOpened()) {
            return false;
        }
        int shiftedMouseX = mouseX - this.posX();
        int shiftedMouseY = mouseY - this.posY;
        if (shiftedMouseX < this.maxWidth - 16) {
            int x = shiftedMouseX - this.sideOffset() - 2;
            int y = shiftedMouseY - 22;
            if (x >= 53 && x < 69 && y >= 0 && y < 18 * this.num) {
                int n = this.first + y / 18;
                this.list.remove(n);
                PacketTileInfo packet = PacketTileInfo.newPacket((TileEntity)this.tile);
                packet.addByte(1);
                packet.addInt(n);
                PacketHandler.sendToServer((PacketBase)packet);
                GuiContainerCore.playClickSound((float)1.0f);
                return true;
            }
            return super.onMousePressed(mouseX, mouseY, mouseButton);
        }
        this.first = shiftedMouseY < 52 ? MathHelper.clamp((int)(this.first - 1), (int)0, (int)this.max) : MathHelper.clamp((int)(this.first + 1), (int)0, (int)this.max);
        return true;
    }

    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if (movement > 0) {
            this.first = MathHelper.clamp((int)(this.first - 1), (int)0, (int)this.max);
            return true;
        }
        if (movement < 0) {
            this.first = MathHelper.clamp((int)(this.first + 1), (int)0, (int)this.max);
            return true;
        }
        return false;
    }
}

