/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.client.gui.element;

import astavie.thermallogistics.client.gui.IFluidGui;
import astavie.thermallogistics.client.gui.element.ElementSlot;
import astavie.thermallogistics.util.StackHandler;
import codechicken.lib.fluid.FluidUtils;
import cofh.core.gui.GuiContainerCore;
import cofh.core.util.helpers.FluidHelper;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ElementSlotFluid
extends ElementSlot {
    private final Supplier<FluidStack> fluid;
    private final Consumer<FluidStack> consumer;
    private final boolean count;

    public ElementSlotFluid(GuiContainerCore gui, int posX, int posY, Supplier<FluidStack> fluid, Consumer<FluidStack> consumer, boolean count) {
        super(gui, posX, posY);
        this.fluid = fluid;
        this.consumer = consumer;
        this.count = count;
    }

    @Override
    protected void drawSlot(int mouseX, int mouseY) {
        FluidStack fluid = this.fluid.get();
        if (fluid != null) {
            StackHandler.render(this.gui, this.posX + 1, this.posY + 1, (Object)fluid, this.count);
        }
    }

    @Override
    protected void addTooltip(int mouseX, int mouseY, List<String> list) {
        if (this.fluid.get() != null) {
            list.add(this.fluid.get().getLocalizedName());
        }
    }

    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton < 2 && this.intersectsWith(mouseX, mouseY)) {
            FluidStack get = this.fluid.get();
            FluidStack drag = null;
            if (this.gui instanceof IFluidGui) {
                drag = ((IFluidGui)this.gui).getFluid();
            }
            if (drag == null) {
                drag = FluidHelper.getFluidForFilledItem((ItemStack)(this.gui.field_147012_x.func_190926_b() ? this.gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o() : this.gui.field_147012_x));
            }
            FluidStack fluid = drag == null ? null : (mouseButton == 0 || !this.count ? drag.copy() : (FluidHelper.isFluidEqual((FluidStack)get, (FluidStack)drag) ? FluidUtils.copy((FluidStack)get, (int)(get.amount + drag.amount)) : drag.copy()));
            this.consumer.accept(fluid);
            return true;
        }
        return false;
    }
}

