/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.loaders.recipe.RecyclingRecipes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class RecyclingRecipeHandler {
    private static final List<Object> CRUSHING_PREFIXES = Arrays.asList(new Object[]{OrePrefix.ingot, OrePrefix.gem, OrePrefix.stick, OrePrefix.plate, OrePrefix.plank, OrePrefix.ring, OrePrefix.stickLong, OrePrefix.foil, OrePrefix.bolt, OrePrefix.screw, OrePrefix.nugget, OrePrefix.gearSmall, OrePrefix.gear, OrePrefix.frameGt, OrePrefix.plateDense, OrePrefix.spring, OrePrefix.springSmall, OrePrefix.block, OrePrefix.wireFine, OrePrefix.rotor, OrePrefix.lens, OrePrefix.turbineBlade, orePrefix -> orePrefix.name().startsWith("toolHead"), orePrefix -> orePrefix.name().startsWith("gem"), orePrefix -> orePrefix.name().startsWith("cableGt"), orePrefix -> orePrefix.name().startsWith("wireGt")});
    private static final List<OrePrefix> IGNORE_ARC_SMELTING = Arrays.asList(OrePrefix.ingot, OrePrefix.gem, OrePrefix.nugget, OrePrefix.block);

    public static void register() {
        for (OrePrefix orePrefix : OrePrefix.values()) {
            if (!CRUSHING_PREFIXES.stream().anyMatch(object -> {
                if (object instanceof OrePrefix) {
                    return object == orePrefix;
                }
                if (object instanceof Predicate) {
                    return ((Predicate)object).test(orePrefix);
                }
                return false;
            })) continue;
            orePrefix.addProcessingHandler(DustMaterial.class, RecyclingRecipeHandler::processCrushing);
        }
    }

    public static void processCrushing(OrePrefix thingPrefix, DustMaterial material) {
        ArrayList<MaterialStack> materialStacks = new ArrayList<MaterialStack>();
        materialStacks.add(new MaterialStack(material, thingPrefix.getMaterialAmount(material)));
        materialStacks.addAll(thingPrefix.secondaryMaterials);
        boolean ignoreArcSmelting = IGNORE_ARC_SMELTING.contains((Object)thingPrefix) && (!(material instanceof IngotMaterial) || ((IngotMaterial)material).arcSmeltInto == material);
        RecyclingRecipes.registerArcRecyclingRecipe(builder -> builder.input(thingPrefix, material), materialStacks, ignoreArcSmelting);
    }
}

