/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.FluidMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class DecompositionRecipeHandler {
    public static void runRecipeGeneration() {
        Iterator<Material> iterator = Material.MATERIAL_REGISTRY.iterator();
        while (iterator.hasNext()) {
            Material material = iterator.next();
            if (!(material instanceof FluidMaterial)) continue;
            OrePrefix prefix = material instanceof DustMaterial ? OrePrefix.dust : null;
            DecompositionRecipeHandler.processDecomposition(prefix, (FluidMaterial)material);
        }
    }

    public static void processDecomposition(OrePrefix decomposePrefix, FluidMaterial material) {
        if (material.materialComponents.isEmpty() || !material.hasFlag(Material.MatFlags.DECOMPOSITION_BY_ELECTROLYZING) && !material.hasFlag(Material.MatFlags.DECOMPOSITION_BY_CENTRIFUGING) || material.hasFlag(Material.MatFlags.DISABLE_DECOMPOSITION)) {
            return;
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
        int totalInputAmount = 0;
        for (MaterialStack component : material.materialComponents) {
            totalInputAmount = (int)((long)totalInputAmount + component.amount);
            if (component.material instanceof DustMaterial) {
                outputs.add(OreDictUnifier.get(OrePrefix.dust, component.material, (int)component.amount));
                continue;
            }
            if (!(component.material instanceof FluidMaterial)) continue;
            FluidMaterial componentMaterial = (FluidMaterial)component.material;
            fluidOutputs.add(componentMaterial.getFluid((int)(1000L * component.amount)));
        }
        Object builder = material.hasFlag(Material.MatFlags.DECOMPOSITION_BY_ELECTROLYZING) ? ((SimpleRecipeBuilder)RecipeMaps.ELECTROLYZER_RECIPES.recipeBuilder().duration((int)material.getAverageProtons() * totalInputAmount * 8)).EUt(DecompositionRecipeHandler.getElectrolyzingVoltage(material.materialComponents.stream().map(s -> s.material).collect(Collectors.toList()))) : ((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration((int)material.getAverageMass() * totalInputAmount * 2)).EUt(30);
        ((RecipeBuilder)builder).outputs(outputs);
        ((RecipeBuilder)builder).fluidOutputs(fluidOutputs);
        if (decomposePrefix != null) {
            ((RecipeBuilder)builder).input(decomposePrefix, material, totalInputAmount);
        } else {
            ((RecipeBuilder)builder).fluidInputs(material.getFluid(1000 * totalInputAmount));
        }
        if (material.hasFlag(Material.MatFlags.DECOMPOSITION_REQUIRES_HYDROGEN)) {
            ((RecipeBuilder)builder).fluidInputs(Materials.Hydrogen.getFluid(1000 * totalInputAmount));
        }
        ((RecipeBuilder)builder).buildAndRegister();
    }

    private static int getElectrolyzingVoltage(List<Material> components) {
        if (components.contains(Materials.Tungsten)) {
            return 1920;
        }
        if (components.size() <= 2) {
            return 30;
        }
        return Math.min(2, components.size()) * 30;
    }
}

