/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import codechicken.lib.raytracer.RayTracer;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTUtility;
import gregtech.common.tools.ToolBase;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class ToolUtility {
    public static EnumFacing getSideHit(World world, BlockPos blockPos, EntityPlayer harvester) {
        RayTraceResult result = RayTracer.retraceBlock((World)world, (EntityPlayer)harvester, (BlockPos)blockPos);
        return result == null ? harvester.func_174811_aO() : result.field_178784_b;
    }

    public static int applyTimberAxe(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer harvester, List<ItemStack> drops) {
        if (harvester.func_70093_af() || !GTUtility.isBlockOrePrefixed((IBlockAccess)world, blockPos, blockState, OrePrefix.log, drops)) {
            return 0;
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(blockPos);
        int destroyedAmount = 0;
        while (true) {
            mutableBlockPos.func_189536_c(EnumFacing.UP);
            IBlockState targetState = world.func_180495_p((BlockPos)mutableBlockPos);
            if (targetState != blockState || !world.func_175660_a(harvester, (BlockPos)mutableBlockPos) || !((EntityPlayerMP)harvester).field_71134_c.func_180237_b((BlockPos)mutableBlockPos)) {
                return destroyedAmount;
            }
            ++destroyedAmount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int applyShearable(World world, BlockPos blockPos, IBlockState blockState, List<ItemStack> drops, EntityPlayer harvester) {
        block8: {
            if (blockState.func_177230_c() instanceof IShearable) {
                IShearable shearable = (IShearable)blockState.func_177230_c();
                ItemStack selfStack = harvester.func_184586_b(EnumHand.MAIN_HAND);
                world.func_180501_a(blockPos, blockState, 0);
                try {
                    if (shearable.isShearable(selfStack, (IBlockAccess)world, blockPos)) {
                        drops.clear();
                        int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)selfStack);
                        drops.addAll(shearable.onSheared(selfStack, (IBlockAccess)world, blockPos, fortuneLevel));
                        int n = drops.size();
                        return n;
                    }
                    break block8;
                }
                finally {
                    world.func_175698_g(blockPos);
                }
            }
            if (blockState.func_185904_a() == Material.field_151584_j) {
                int stackMetadata = blockState.func_177230_c().func_176201_c(blockState);
                ItemStack dropStack = new ItemStack(blockState.func_177230_c(), 1, stackMetadata);
                if (!dropStack.func_190926_b()) {
                    if (!dropStack.func_77973_b().func_77614_k()) {
                        dropStack.func_77964_b(0);
                    }
                    drops.clear();
                    drops.add(dropStack);
                    return 1;
                }
            }
        }
        return 0;
    }

    public static int applyMultiBreak(World world, BlockPos blockPos, EntityPlayer harvester, ToolBase self, int size) {
        int conversions = 0;
        ItemStack selfStack = harvester.func_184586_b(EnumHand.MAIN_HAND);
        for (int i = -size; i <= size; ++i) {
            for (int j = -size; j <= size; ++j) {
                for (int k = -size; k <= size; ++k) {
                    BlockPos block;
                    if (i == 0 && j == 0 && k == 0 || !self.isMinableBlock(world.func_180495_p(block = blockPos.func_177982_a(i, j, k)), selfStack) || !world.canMineBlockBody(harvester, block) || !((EntityPlayerMP)harvester).field_71134_c.func_180237_b(block)) continue;
                    ++conversions;
                }
            }
        }
        return conversions;
    }

    public static int applyHammerDrops(Random random, IBlockState blockState, List<ItemStack> drops, int fortuneLevel) {
        ItemStack itemStack = new ItemStack(blockState.func_177230_c(), 1, blockState.func_177230_c().func_176201_c(blockState));
        Recipe recipe = RecipeMaps.FORGE_HAMMER_RECIPES.findRecipe(Long.MAX_VALUE, Collections.singletonList(itemStack), Collections.emptyList());
        if (recipe != null && !recipe.getOutputs().isEmpty()) {
            drops.clear();
            for (ItemStack outputStack : recipe.getResultItemOutputs(random, 1)) {
                if (OreDictUnifier.getPrefix(outputStack = outputStack.func_77946_l()) == OrePrefix.crushed) {
                    int growAmount = Math.round((float)outputStack.func_190916_E() * random.nextFloat());
                    if (fortuneLevel > 0) {
                        int i = Math.max(0, random.nextInt(fortuneLevel + 2) - 1);
                        growAmount += outputStack.func_190916_E() * i;
                    }
                    outputStack.func_190917_f(growAmount);
                }
                drops.add(outputStack);
            }
            return 1;
        }
        return 0;
    }
}

