/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.fluidpipe.tile;

import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.common.covers.CoverPump;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipe;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFluidPipeActive
extends TileEntityFluidPipe
implements ITickable {
    private static final Predicate<FluidStack> FLUID_FILTER_ALWAYS_TRUE = fluid -> true;
    private boolean isActive;

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public void func_73660_a() {
        this.getCoverableImplementation().update();
        if (this.isActive) {
            TileEntityFluidPipeActive.pushFluidsFromTank(this);
        }
    }

    @Override
    public boolean supportsTicking() {
        return true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("ActiveNode", this.isActive);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.isActive = compound.func_74767_n("ActiveNode");
    }

    public static void pushFluidsFromTank(IPipeTile<?, ?> pipeTile) {
        BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        int blockedConnections = pipeTile.getBlockedConnections();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TileEntity tileEntity;
            if ((blockedConnections & 1 << side.func_176745_a()) > 0) continue;
            blockPos.func_189533_g((Vec3i)pipeTile.getPipePos()).func_189536_c(side);
            if (!pipeTile.getPipeWorld().func_175667_e((BlockPos)blockPos) || (tileEntity = pipeTile.getPipeWorld().func_175625_s((BlockPos)blockPos)) == null || pipeTile.getPipeBlock().getPipeTileEntity(tileEntity) != null) continue;
            IFluidHandler sourceHandler = (IFluidHandler)pipeTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
            IFluidHandler receiverHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
            if (sourceHandler == null || receiverHandler == null) continue;
            CoverPump.moveHandlerFluids(sourceHandler, receiverHandler, Integer.MAX_VALUE, FLUID_FILTER_ALWAYS_TRUE);
        }
        blockPos.func_185344_t();
    }
}

