/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric.generator;

import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.FuelRecipeMapWorkableHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.machines.FuelRecipeMap;
import gregtech.api.recipes.recipes.FuelRecipe;
import gregtech.api.unification.material.Materials;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class DieselEngineWorkableHandler
extends FuelRecipeMapWorkableHandler {
    private final int maxCycleLength = 20;
    private int currentCycle = 0;
    private boolean isUsingOxygen = false;

    public DieselEngineWorkableHandler(MetaTileEntity metaTileEntity, FuelRecipeMap recipeMap, Supplier<IEnergyContainer> energyContainer, Supplier<IMultipleTankHandler> fluidTank, long maxVoltage) {
        super(metaTileEntity, recipeMap, energyContainer, fluidTank, maxVoltage);
    }

    public FluidStack getFuelStack() {
        if (this.previousRecipe == null) {
            return null;
        }
        FluidStack fuelStack = this.previousRecipe.getRecipeFluid();
        return ((IMultipleTankHandler)this.fluidTank.get()).drain(new FluidStack(fuelStack.getFluid(), Integer.MAX_VALUE), false);
    }

    @Override
    protected boolean checkRecipe(FuelRecipe recipe) {
        FluidStack lubricantStack = Materials.Lubricant.getFluid(2);
        FluidStack drainStack = ((IMultipleTankHandler)this.fluidTank.get()).drain(lubricantStack, false);
        return drainStack != null && drainStack.amount >= 2 || this.currentCycle < 20;
    }

    @Override
    protected int calculateFuelAmount(FuelRecipe currentRecipe) {
        FluidStack oxygenStack = Materials.Oxygen.getFluid(2);
        FluidStack drainOxygenStack = ((IMultipleTankHandler)this.fluidTank.get()).drain(oxygenStack, false);
        this.isUsingOxygen = drainOxygenStack != null && drainOxygenStack.amount >= 2;
        return super.calculateFuelAmount(currentRecipe) * (this.isUsingOxygen ? 2 : 1);
    }

    @Override
    protected long startRecipe(FuelRecipe currentRecipe, int fuelAmountUsed, int recipeDuration) {
        if (this.currentCycle >= 20) {
            FluidStack lubricantStack = Materials.Lubricant.getFluid(2);
            ((IMultipleTankHandler)this.fluidTank.get()).drain(lubricantStack, true);
            this.currentCycle = 0;
        } else {
            ++this.currentCycle;
        }
        if (this.isUsingOxygen) {
            FluidStack oxygenStack = Materials.Oxygen.getFluid(2);
            ((IMultipleTankHandler)this.fluidTank.get()).drain(oxygenStack, true);
        }
        return this.maxVoltage * (long)(this.isUsingOxygen ? 3 : 1);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74768_a("Cycle", this.currentCycle);
        return compound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.currentCycle = compound.func_74762_e("Cycle");
    }
}

